/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.query.expression;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.path.ParserContext;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.query.PropertyPlaceholder;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.ExpressionVisitor;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class Path
implements Variable {
    private final PropertyPlaceholder rawElements;
    private final List<Property> elements;

    public Path() {
        this.rawElements = null;
        this.elements = new ArrayList<Property>();
    }

    public Path(PropertyPlaceholder rawElements) {
        this.rawElements = rawElements;
        this.elements = new ArrayList<Property>();
    }

    public Path(Property ... elements) {
        this.rawElements = null;
        this.elements = Arrays.asList(elements);
    }

    public Path(List<Property> elements) {
        this.rawElements = null;
        this.elements = elements;
    }

    @Override
    public void validate(ParserContext context, EntityType type) {
        if (!this.elements.isEmpty()) {
            throw new IllegalStateException("Double Validation of Path!");
        }
        EntityType localType = type;
        String topName = this.rawElements.getName();
        Property property = context.parseProperty(localType, topName, null);
        if (property == null) {
            throw new IllegalArgumentException("Unknown Property: " + topName);
        }
        this.elements.add(property);
        if (property instanceof NavigationPropertyMain) {
            NavigationPropertyMain npm = (NavigationPropertyMain)property;
            localType = npm.getEntityType();
        }
        for (String rawElement : this.rawElements.getSubPath()) {
            property = context.parseProperty(localType, rawElement, property);
            if (property instanceof NavigationProperty) {
                NavigationProperty navigationProperty = (NavigationProperty)property;
                localType = navigationProperty.getEntityType();
            }
            if (property == null) {
                throw new IllegalArgumentException("Unknown Property: " + rawElement);
            }
            this.elements.add(property);
        }
    }

    public List<Property> getElements() {
        if (this.elements.isEmpty() && this.rawElements != null) {
            throw new IllegalStateException("Path with raw elements must be validated before use.");
        }
        return this.elements;
    }

    public Property lastElement() {
        if (this.elements.isEmpty() && this.rawElements != null) {
            throw new IllegalStateException("Path with raw elements must be validated before use.");
        }
        return this.elements.get(this.elements.size() - 1);
    }

    public int hashCode() {
        return Objects.hash(this.elements);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Path other = (Path)obj;
        return Objects.equals(this.elements, other.elements);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean firstDone = false;
        for (Property p : this.elements) {
            if (firstDone) {
                sb.append("/");
            } else {
                firstDone = true;
            }
            sb.append(p.getName());
        }
        return sb.toString();
    }

    @Override
    public String toUrl() {
        if (this.elements.isEmpty() && this.rawElements != null) {
            throw new IllegalStateException("Path with raw elements must be validated before use.");
        }
        return this.toString();
    }

    @Override
    public <O> O accept(ExpressionVisitor<O> visitor) {
        return visitor.visit(this);
    }
}

