/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.query;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.NavigableElement;
import de.fraunhofer.iosb.ilt.frostserver.model.core.PrimaryKey;
import de.fraunhofer.iosb.ilt.frostserver.path.ParserContext;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElement;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementCustomProperty;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementProperty;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyCustomSelect;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.query.Expand;
import de.fraunhofer.iosb.ilt.frostserver.query.Metadata;
import de.fraunhofer.iosb.ilt.frostserver.query.OrderBy;
import de.fraunhofer.iosb.ilt.frostserver.query.PropertyPlaceholder;
import de.fraunhofer.iosb.ilt.frostserver.query.QueryDefaults;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.Expression;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import de.fraunhofer.iosb.ilt.frostserver.util.user.PrincipalExtended;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class Query {
    private static final String ERROR_ADD_PLACEHOLDER_OR_PROPERTY = "Either add PropertyPlaceholder or Property instances, not both.";
    private static final Set<EntityPropertyMain> refSelect = Collections.unmodifiableSet(new HashSet<EntityPropertyMain>(Arrays.asList(ModelRegistry.EP_SELFLINK)));
    private final QueryDefaults settings;
    private final ModelRegistry modelRegistry;
    private final PrincipalExtended principal;
    private ResourcePath path;
    private Expand parentExpand;
    private EntityType entityType;
    private Set<EntityPropertyMain> selectEntityPropMain;
    private Set<NavigationPropertyMain> selectNavProp;
    private Optional<Integer> top;
    private Optional<Integer> skip;
    private Optional<Boolean> count;
    private final List<PropertyPlaceholder> rawSelect;
    private final Set<Property> select;
    private boolean selectDistinct = false;
    private Expression filter;
    private Expression skipFilter;
    private List<Expand> expand;
    private List<OrderBy> orderBy;
    private String id;
    private boolean pkOrder = false;
    private String format;
    private Metadata metadata;

    public Query(ModelRegistry modelRegistry, QueryDefaults settings, ResourcePath path) {
        this(modelRegistry, settings, path, PrincipalExtended.ANONYMOUS_PRINCIPAL);
    }

    public Query(Query expandParent) {
        this(expandParent.getModelRegistry(), expandParent.getSettings(), expandParent.getPath(), expandParent.getPrincipal());
    }

    public Query(ModelRegistry modelRegistry, QueryDefaults settings, ResourcePath path, PrincipalExtended principal) {
        this.modelRegistry = modelRegistry;
        this.path = path;
        this.settings = settings;
        this.principal = principal;
        this.top = Optional.empty();
        this.skip = Optional.empty();
        this.count = Optional.empty();
        this.orderBy = new ArrayList<OrderBy>();
        this.expand = new ArrayList<Expand>();
        this.rawSelect = new ArrayList<PropertyPlaceholder>();
        this.select = new LinkedHashSet<Property>();
    }

    public boolean isEmpty() {
        return this.top.isEmpty() && this.skip.isEmpty() && this.count.isEmpty() && this.select.isEmpty() && this.expand.isEmpty() && this.filter == null;
    }

    public Query validate() {
        PathElement mainElement = this.path.getMainElement();
        if (mainElement instanceof PathElementProperty || mainElement instanceof PathElementCustomProperty) {
            throw new IllegalArgumentException("No queries allowed for property paths.");
        }
        EntityType pathEntityType = this.path.getMainElementType();
        if (pathEntityType == null) {
            throw new IllegalStateException("Unkown ResourcePathElementType found.");
        }
        this.validate(null, pathEntityType);
        return this;
    }

    public Query validate(EntityType entityType) {
        return this.validate(null, entityType);
    }

    public Query validate(ParserContext context, EntityType entityType) {
        if (context == null) {
            context = new ParserContext(this.modelRegistry);
        }
        if (this.entityType == null) {
            this.entityType = entityType;
        }
        this.selectEntityPropMain = null;
        for (PropertyPlaceholder pp : this.rawSelect) {
            Property property = entityType.getProperty(pp.getName());
            if (property == null) {
                property = this.path.getVersion().syntheticPropertyRegistry.getProperty(pp.getName());
            }
            if (property == null) {
                throw new IllegalArgumentException("Invalid property '" + pp.getName() + "' found in select, for entity type " + entityType.entityName);
            }
            if (property instanceof NavigationProperty) {
                this.select.add(property);
                continue;
            }
            if (!(property instanceof EntityPropertyMain)) continue;
            if (pp.hasSubPath()) {
                this.select.add(new EntityPropertyCustomSelect(property.getName()).addToSubPath(pp.getSubPath()));
                continue;
            }
            this.select.add(property);
        }
        for (Expand e : this.expand) {
            e.validate(context, entityType);
        }
        this.reNestExpands();
        if (this.filter != null) {
            this.filter.validate(context, entityType);
        }
        if (this.skipFilter != null) {
            this.skipFilter.validate(context, entityType);
        }
        PrimaryKey primaryKey = entityType.getPrimaryKey();
        int pkCount = 0;
        for (EntityPropertyMain keyProp : primaryKey.getKeyProperties()) {
            String pkName = keyProp.getName();
            for (OrderBy order : this.orderBy) {
                order.getExpression().validate(context, entityType);
                if (!pkName.equals(order.getExpression().toUrl())) continue;
                ++pkCount;
            }
        }
        boolean bl = this.pkOrder = pkCount >= primaryKey.getKeyProperties().size();
        if (this.settings.isAlwaysOrder() && !this.pkOrder && !this.selectDistinct) {
            for (OrderBy dfltOrder : entityType.getOrderbyDefaults()) {
                boolean found = false;
                for (OrderBy order : this.orderBy) {
                    if (!order.getExpression().toUrl().equalsIgnoreCase(dfltOrder.getExpression().toUrl())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.orderBy.add(dfltOrder);
            }
            this.pkOrder = true;
        }
        return this;
    }

    public Version getVersion() {
        return this.path.getVersion();
    }

    public ModelRegistry getModelRegistry() {
        return this.modelRegistry;
    }

    public QueryDefaults getSettings() {
        return this.settings;
    }

    public ResourcePath getPath() {
        return this.path;
    }

    public void setPath(ResourcePath path) {
        this.path = path;
    }

    public String getServiceRootUrl() {
        return this.path.getServiceRootUrl();
    }

    public boolean hasParentExpand() {
        return this.parentExpand != null;
    }

    public Expand getParentExpand() {
        return this.parentExpand;
    }

    public void setParentExpand(Expand parentExpand) {
        this.parentExpand = parentExpand;
    }

    public Optional<Integer> getTop() {
        return this.top;
    }

    public int getTopOrDefault() {
        if (this.top.isPresent()) {
            return this.top.get();
        }
        return this.settings.getTopDefault();
    }

    public Optional<Integer> getSkip() {
        return this.skip;
    }

    public int getSkip(int dflt) {
        if (this.skip.isPresent()) {
            return this.skip.get();
        }
        return dflt;
    }

    public Optional<Boolean> getCount() {
        return this.count;
    }

    public boolean isCountOrDefault() {
        if (this.count.isPresent()) {
            return this.count.get();
        }
        return this.settings.isCountDefault();
    }

    public Query clearSelect() {
        this.select.clear();
        return this;
    }

    public Query addSelect(PropertyPlaceholder property) {
        if (!this.select.isEmpty()) {
            throw new IllegalStateException(ERROR_ADD_PLACEHOLDER_OR_PROPERTY);
        }
        this.rawSelect.add(property);
        return this;
    }

    public Query addSelect(Collection<PropertyPlaceholder> properties) {
        if (!this.select.isEmpty()) {
            throw new IllegalStateException(ERROR_ADD_PLACEHOLDER_OR_PROPERTY);
        }
        this.rawSelect.addAll(properties);
        return this;
    }

    public Query addSelect(Property property) {
        if (!this.rawSelect.isEmpty()) {
            throw new IllegalStateException(ERROR_ADD_PLACEHOLDER_OR_PROPERTY);
        }
        this.select.add(property);
        return this;
    }

    public Query addSelect(Property ... properties) {
        this.select.addAll(Arrays.asList(properties));
        return this;
    }

    public Query addSelect(List<EntityPropertyMain> properties) {
        this.select.addAll(properties);
        return this;
    }

    public Set<Property> getSelect() {
        return this.select;
    }

    public void setSelectDistinct(boolean selectDistinct) {
        this.selectDistinct = selectDistinct;
    }

    public boolean isSelectDistinct() {
        return this.selectDistinct;
    }

    public Set<EntityPropertyMain> getSelectMainEntityProperties(boolean inExpand) {
        if (this.selectEntityPropMain == null) {
            return this.initSelectedProperties(inExpand);
        }
        return this.selectEntityPropMain;
    }

    public Set<NavigationPropertyMain> getSelectNavProperties(boolean inExpand) {
        if (this.selectNavProp == null) {
            this.initSelectedProperties(inExpand);
        }
        return this.selectNavProp;
    }

    private Set<EntityPropertyMain> initSelectedProperties(boolean inExpand) {
        if (this.path != null && this.path.isRef()) {
            this.selectEntityPropMain = refSelect;
            this.selectNavProp = new HashSet<NavigationPropertyMain>();
            return refSelect;
        }
        LinkedHashSet<EntityPropertyMain> selectedEntityPropMain = new LinkedHashSet<EntityPropertyMain>();
        this.selectNavProp = new LinkedHashSet<NavigationPropertyMain>();
        if (this.select.isEmpty()) {
            if (this.entityType == null) {
                this.validate();
            }
            if (this.getMetadata() == Metadata.FULL) {
                selectedEntityPropMain.add(ModelRegistry.EP_SELFLINK);
            }
            selectedEntityPropMain.addAll(this.entityType.getEntityProperties());
            if (!inExpand) {
                for (NavigationPropertyMain<Entity> navigationPropertyMain : this.entityType.getNavigationEntities()) {
                    if (navigationPropertyMain.isAdminOnly() && !this.principal.isAdmin()) continue;
                    this.selectNavProp.add(navigationPropertyMain);
                }
                for (NavigationPropertyMain<NavigableElement> navigationPropertyMain : this.entityType.getNavigationSets()) {
                    if (navigationPropertyMain.isAdminOnly() && !this.principal.isAdmin()) continue;
                    this.selectNavProp.add(navigationPropertyMain);
                }
            }
        } else {
            for (Property property : this.select) {
                NavigationPropertyMain np;
                if (property instanceof EntityPropertyMain) {
                    EntityPropertyMain epm = (EntityPropertyMain)property;
                    selectedEntityPropMain.add(epm);
                    continue;
                }
                if (property instanceof EntityPropertyCustomSelect) {
                    EntityPropertyCustomSelect epcs = (EntityPropertyCustomSelect)property;
                    selectedEntityPropMain.add(this.entityType.getEntityProperty(epcs.getMainEntityPropertyName()));
                    continue;
                }
                if (!(property instanceof NavigationPropertyMain) || (np = (NavigationPropertyMain)property).isAdminOnly() && !this.principal.isAdmin()) continue;
                this.selectNavProp.add(np);
            }
        }
        this.selectEntityPropMain = selectedEntityPropMain;
        return selectedEntityPropMain;
    }

    public Expression getFilter() {
        return this.filter;
    }

    public Query setFilter(Expression filter) {
        this.filter = filter;
        return this;
    }

    public Expression getSkipFilter() {
        return this.skipFilter;
    }

    public void setSkipFilter(Expression skipFilter) {
        this.skipFilter = skipFilter;
    }

    public String getFormat() {
        return this.format;
    }

    public Metadata getMetadata() {
        if (this.metadata == null) {
            return Metadata.DEFAULT;
        }
        return this.metadata;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public List<Expand> getExpand() {
        return this.expand;
    }

    public List<OrderBy> getOrderBy() {
        return this.orderBy;
    }

    public boolean isPkOrder() {
        return this.pkOrder;
    }

    public Query setTop(int top) {
        this.top = top <= this.settings.getTopMax() ? Optional.of(top) : Optional.of(this.settings.getTopMax());
        return this;
    }

    public Query setSkip(int skip) {
        this.skip = Optional.of(skip);
        return this;
    }

    public Query setCount(boolean count) {
        this.count = Optional.of(count);
        return this;
    }

    public Query setFormat(String format) {
        this.format = format;
        return this;
    }

    public Query setMetadata(Metadata metadata) {
        Objects.requireNonNull(metadata);
        this.metadata = metadata;
        return this;
    }

    public Query setExpand(List<Expand> expand) {
        this.expand = expand;
        for (Expand e : expand) {
            e.setParentQuery(this);
        }
        return this;
    }

    public Query addExpand(Expand expand) {
        this.expand.add(expand);
        expand.setParentQuery(this);
        return this;
    }

    private void addExpand(List<Expand> expands) {
        this.expand.addAll(expands);
        for (Expand e : expands) {
            e.setParentQuery(this);
        }
    }

    public void reNestExpands() {
        ArrayList<Expand> newExpands = new ArrayList<Expand>();
        HashMap<String, Expand> expandMap = new HashMap<String, Expand>();
        for (Expand oldExpand : this.expand) {
            List<String> rawPath = oldExpand.getRawPath();
            String first = rawPath.get(0);
            int rawCount = rawPath.size();
            if (rawCount == 1 && expandMap.containsKey(first)) {
                Expand existing = (Expand)expandMap.get(first);
                existing.getSubQuery().addExpand(oldExpand.getSubQuery().getExpand());
                existing.getSubQuery().reNestExpands();
                continue;
            }
            newExpands.add(oldExpand);
            if (rawPath.size() != 1) continue;
            expandMap.put(first, oldExpand);
        }
        this.expand.clear();
        this.expand.addAll(newExpands);
    }

    public Query addOrderBy(OrderBy orderBy) {
        if (this.orderBy == null) {
            this.orderBy = new ArrayList<OrderBy>();
        }
        this.orderBy.add(orderBy);
        return this;
    }

    public Query setOrderBy(List<OrderBy> orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.top, this.skip, this.count, this.select, this.filter, this.skipFilter, this.format, this.expand, this.orderBy, this.path, this.selectDistinct, this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Query other = (Query)obj;
        return Objects.equals(this.count, other.count) && Objects.equals(this.top, other.top) && Objects.equals(this.skip, other.skip) && Objects.equals(this.select, other.select) && Objects.equals(this.selectDistinct, other.selectDistinct) && Objects.equals(this.filter, other.filter) && Objects.equals(this.skipFilter, other.skipFilter) && Objects.equals(this.format, other.format) && Objects.equals(this.expand, other.expand) && Objects.equals(this.orderBy, other.orderBy) && Objects.equals(this.path, other.path) && Objects.equals(this.id, other.id);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean inExpand) {
        char separator = inExpand ? (char)';' : '&';
        StringBuilder sb = new StringBuilder();
        this.addTopToUrl(sb, separator);
        this.addSkipToUrl(sb, separator);
        this.addSelectToUrl(sb, separator, inExpand);
        this.addFilterToUrl(sb, separator, inExpand);
        this.addFormatToUrl(sb, separator);
        this.addExpandToUrl(sb, separator, inExpand);
        this.addOrderbyToUrl(sb, separator, inExpand);
        this.addCountToUrl(sb, separator);
        if (sb.length() > 0) {
            return sb.substring(1);
        }
        return "";
    }

    private void addCountToUrl(StringBuilder sb, char separator) {
        if (this.count.isPresent()) {
            sb.append(separator).append("$count=").append(this.count.get());
        }
    }

    private void addFormatToUrl(StringBuilder sb, char separator) {
        if (this.format != null) {
            sb.append(separator).append("$resultFormat=").append(StringHelper.urlEncode(this.format));
        }
    }

    private void addSkipToUrl(StringBuilder sb, char separator) {
        if (this.skip.isPresent()) {
            sb.append(separator).append("$skip=").append(this.skip.get());
        }
    }

    private void addTopToUrl(StringBuilder sb, char separator) {
        if (this.top.isPresent()) {
            sb.append(separator).append("$top=").append(this.top.get());
        }
    }

    private void addOrderbyToUrl(StringBuilder sb, char separator, boolean inExpand) {
        if (!this.orderBy.isEmpty()) {
            sb.append(separator).append("$orderby=");
            boolean firstDone = false;
            for (OrderBy ob : this.orderBy) {
                if (firstDone) {
                    sb.append(",");
                } else {
                    firstDone = true;
                }
                String orderUrl = ob.toString();
                if (!inExpand) {
                    orderUrl = StringHelper.urlEncode(orderUrl);
                }
                sb.append(orderUrl);
            }
        }
    }

    private void addExpandToUrl(StringBuilder sb, char separator, boolean inExpand) {
        if (!this.expand.isEmpty()) {
            sb.append(separator).append("$expand=");
            boolean firstDone = false;
            for (Expand e : this.expand) {
                if (firstDone) {
                    sb.append(",");
                } else {
                    firstDone = true;
                }
                String expandUrl = e.toString();
                if (!inExpand) {
                    expandUrl = StringHelper.urlEncode(expandUrl);
                }
                sb.append(expandUrl);
            }
        }
    }

    private void addFilterToUrl(StringBuilder sb, char separator, boolean inExpand) {
        if (this.filter != null) {
            sb.append(separator).append("$filter=");
            String filterUrl = this.filter.toUrl();
            if (inExpand) {
                sb.append(filterUrl);
            } else {
                sb.append(StringHelper.urlEncode(filterUrl));
            }
        }
    }

    private void addSelectToUrl(StringBuilder sb, char separator, boolean inExpand) {
        if (!this.select.isEmpty()) {
            sb.append(separator).append("$select=");
            if (this.isSelectDistinct()) {
                sb.append("distinct:");
            }
            boolean firstDone = false;
            for (Property property : this.select) {
                if (firstDone) {
                    sb.append(",");
                } else {
                    firstDone = true;
                }
                if (inExpand) {
                    sb.append(property.getName());
                    continue;
                }
                sb.append(StringHelper.urlEncode(property.getName()));
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public PrincipalExtended getPrincipal() {
        return this.principal;
    }
}

