/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.query;

import de.fraunhofer.iosb.ilt.frostserver.query.expression.Expression;
import java.util.Objects;

public class OrderBy {
    private final Expression expression;
    private final OrderType type;

    public OrderBy(Expression expression, OrderType type) {
        this.expression = expression;
        this.type = type;
    }

    public OrderBy(Expression expression) {
        this.expression = expression;
        this.type = OrderType.ASCENDING;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public OrderType getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.expression, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrderBy other = (OrderBy)obj;
        return Objects.equals(this.expression, other.expression) && this.type == other.type;
    }

    public String toString() {
        return this.expression.toUrl() + " " + this.type.direction;
    }

    public static enum OrderType {
        ASCENDING("asc"),
        DESCENDING("desc");

        public final String direction;

        private OrderType(String direction) {
            this.direction = direction;
        }
    }
}

