/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.query;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.path.ParserContext;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElement;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementCustomProperty;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementProperty;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyCustom;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class Expand {
    private ModelRegistry modelRegistry;
    private List<String> rawPath;
    private NavigationProperty validatedPath;
    private Query parentQuery;
    private Query subQuery;

    public Expand(ModelRegistry modelRegistry) {
        this.modelRegistry = modelRegistry;
    }

    public Expand(ModelRegistry modelRegistry, Query subQuery) {
        this.modelRegistry = modelRegistry;
        if (subQuery != null) {
            this.setSubQuery(subQuery);
        }
    }

    public Expand(ModelRegistry modelRegistry, NavigationProperty path) {
        if (path == null) {
            throw new IllegalArgumentException("path must be non-empty");
        }
        this.modelRegistry = modelRegistry;
        this.validatedPath = path;
    }

    public Expand(ModelRegistry modelRegistry, Query subQuery, NavigationProperty path) {
        if (path == null) {
            throw new IllegalArgumentException("paths must be non-empty");
        }
        this.modelRegistry = modelRegistry;
        this.validatedPath = path;
        this.setSubQuery(subQuery);
    }

    public NavigationProperty getPath() {
        return this.validatedPath;
    }

    public void addToRawPath(String subPath) {
        if (this.rawPath == null) {
            this.rawPath = new ArrayList<String>();
        }
        this.rawPath.add(subPath);
    }

    public List<String> getRawPath() {
        if (this.rawPath == null) {
            String[] items = StringUtils.split(this.validatedPath.getName(), '/');
            this.rawPath = Arrays.asList(items);
        }
        return this.rawPath;
    }

    public boolean hasSubQuery() {
        return this.subQuery != null;
    }

    public Query getSubQuery() {
        if (this.subQuery == null) {
            Query newSubQuery = new Query(this.parentQuery).validate(null, this.validatedPath.getEntityType());
            this.setSubQuery(newSubQuery);
        }
        return this.subQuery;
    }

    public final Expand setSubQuery(Query subQuery) {
        this.subQuery = subQuery;
        this.subQuery.setParentExpand(this);
        return this;
    }

    public Query getParentQuery() {
        return this.parentQuery;
    }

    public void setParentQuery(Query parentQuery) {
        this.parentQuery = parentQuery;
    }

    public void validate(ParserContext context, ResourcePath path) {
        PathElement mainElement = path.getMainElement();
        if (mainElement instanceof PathElementProperty || mainElement instanceof PathElementCustomProperty) {
            throw new IllegalArgumentException("No expand allowed on property paths.");
        }
        EntityType entityType = path.getMainElementType();
        if (entityType == null) {
            throw new IllegalStateException("Unkown ResourcePathElementType found.");
        }
        this.validate(context, entityType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validate(ParserContext context, EntityType entityType) {
        if (this.validatedPath == null) {
            String firstRawPath = this.rawPath.get(0);
            Property property = entityType.getProperty(firstRawPath);
            int rawCount = this.rawPath.size();
            if (property instanceof NavigationPropertyMain) {
                NavigationPropertyMain npm = (NavigationPropertyMain)property;
                if (npm.isAdminOnly() && !this.parentQuery.getPrincipal().isAdmin()) {
                    throw new IllegalArgumentException("Unknown path '" + firstRawPath + "' in expand on entity type " + entityType.entityName);
                }
                this.validatedPath = npm;
                if (rawCount > 1) {
                    Expand subExpand = new Expand(this.modelRegistry, this.subQuery);
                    for (int i = 1; i < rawCount; ++i) {
                        subExpand.addToRawPath(this.rawPath.get(i));
                    }
                    this.rawPath.clear();
                    this.rawPath.add(firstRawPath);
                    this.subQuery = new Query(this.parentQuery);
                    this.subQuery.addExpand(subExpand);
                    this.subQuery.setParentExpand(this);
                }
            } else {
                if (!(property instanceof EntityPropertyMain)) throw new IllegalArgumentException("Unknown path '" + firstRawPath + "' in expand on entity type " + entityType.entityName);
                EntityPropertyMain epm = (EntityPropertyMain)property;
                if (!epm.hasCustomProperties) throw new IllegalArgumentException("Unknown path '" + firstRawPath + "' in expand on entity type " + entityType.entityName);
                NavigationPropertyCustom tempPath = new NavigationPropertyCustom(this.modelRegistry, epm);
                for (int i = 1; i < rawCount; ++i) {
                    tempPath.addToSubPath(this.rawPath.get(i));
                }
                this.validatedPath = tempPath;
            }
        }
        if (this.subQuery == null || this.validatedPath == null) return;
        if (!this.subQuery.hasMetadata()) {
            this.subQuery.setMetadata(this.parentQuery.getMetadata());
        }
        this.subQuery.validate(context, this.validatedPath.getEntityType());
    }

    public int hashCode() {
        return Objects.hash(this.validatedPath, this.subQuery);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Expand other = (Expand)obj;
        return Objects.equals(this.getRawPath(), other.getRawPath()) && Objects.equals(this.subQuery, other.subQuery);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.validatedPath == null) {
            sb.append(StringUtils.join(this.rawPath, "/"));
        } else {
            sb.append(this.validatedPath.getName());
        }
        if (this.subQuery != null && !this.subQuery.isEmpty()) {
            sb.append('(');
            sb.append(this.subQuery.toString(true));
            sb.append(')');
        }
        return sb.toString();
    }
}

