/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.property.type;

import de.fraunhofer.iosb.ilt.frostserver.property.type.PropertyType;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeSimple;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeSimplePrimitive;
import de.fraunhofer.iosb.ilt.frostserver.util.ParserUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeSimpleCustom
extends TypeSimple {
    public static final String STA_GEOJSON_NAME = "Geometry";
    public static final String STA_TM_INSTANT_NAME = "TM_Instant";
    public static final String STA_TM_INSTANT_ALIAS = "TimeInstant";
    public static final PropertyType STA_LOCATION = new TypeSimpleCustom("Geometry", "A Free Location object", TypeSimplePrimitive.EDM_GEOMETRY).setDeserializer(ParserUtils.getLocationDeserializer());
    public static final PropertyType STA_TM_INSTANT = new TypeSimpleCustom("TM_Instant", "A Time Instant", TypeSimplePrimitive.EDM_DATETIMEOFFSET);
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeSimpleCustom.class.getName());
    private static final Map<String, TypeSimpleCustom> TYPES = new HashMap<String, TypeSimpleCustom>();

    public static TypeSimpleCustom getType(String name) {
        return TYPES.get(name);
    }

    public TypeSimpleCustom(String name, String description, TypeSimplePrimitive underlyingType) {
        super(name, description, underlyingType);
    }

    static {
        for (Field field : FieldUtils.getAllFields(TypeSimpleCustom.class)) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                TypeSimpleCustom type = (TypeSimpleCustom)FieldUtils.readStaticField(field, false);
                String name = type.getName();
                TYPES.put(name, type);
                LOGGER.debug("Registered type: {}", (Object)name);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.error("Failed to initialise: {}", (Object)field, (Object)ex);
            }
            catch (IllegalAccessException ex) {
                LOGGER.trace("Failed to initialise: {}", (Object)field, (Object)ex);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        TYPES.put(STA_TM_INSTANT_ALIAS, TYPES.get(STA_TM_INSTANT_NAME));
    }
}

