/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.property.type;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import de.fraunhofer.iosb.ilt.frostserver.model.ComplexValue;
import de.fraunhofer.iosb.ilt.frostserver.model.ComplexValueImpl;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.MapValue;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeInstant;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeInterval;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeValue;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TypeReferencesHelper;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.property.type.PropertyType;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeSimplePrimitive;
import de.fraunhofer.iosb.ilt.frostserver.util.ParserUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeComplex
extends PropertyType {
    public static final String STA_MAP_NAME = "Object";
    public static final String STA_OBJECT_NAME = "ANY";
    public static final String STA_TIMEINTERVAL_NAME = "TM_Period";
    public static final String STA_TIMEINTERVAL_ALIAS = "TimeInterval";
    public static final String STA_TIMEVALUE_NAME = "TM_Object";
    public static final String STA_TIMEVALUE_ALIAS = "TimeValue";
    public static final String STA_TIMEVALUE_ALIAS2 = "TimeObject";
    public static final String NAME_INTERVAL_START = "start";
    public static final String NAME_INTERVAL_END = "end";
    public static final EntityPropertyMain<TimeInstant> EP_START_TIME = new EntityPropertyMain("start", TypeSimplePrimitive.EDM_DATETIMEOFFSET).setNullable(false);
    public static final EntityPropertyMain<TimeInstant> EP_INTERVAL_END_TIME = new EntityPropertyMain("end", TypeSimplePrimitive.EDM_DATETIMEOFFSET).setNullable(false);
    public static final EntityPropertyMain<TimeInstant> EP_VALUE_END_TIME = new EntityPropertyMain("end", TypeSimplePrimitive.EDM_DATETIMEOFFSET).setNullable(true);
    public static final TypeComplex STA_MAP = new TypeComplex("Object", "A free object that can contain anything", true, MapValue::new, TypeReferencesHelper.TYPE_REFERENCE_MAP);
    public static final TypeComplex STA_OBJECT = new TypeComplex("ANY", "A free type, can be anything", true, null, TypeReferencesHelper.TYPE_REFERENCE_OBJECT);
    public static final TypeComplex STA_OBJECT_UNTYPED = new TypeComplex("ANY", "A free type, can be anything", true, null, null, null);
    public static final TypeComplex STA_TIMEINTERVAL = new TypeComplex("TM_Period", "An ISO time interval.", false, TimeInterval::new, TypeReferencesHelper.TYPE_REFERENCE_TIMEINTERVAL).registerProperty(EP_START_TIME).registerProperty(EP_INTERVAL_END_TIME);
    public static final TypeComplex STA_TIMEVALUE = new TypeComplex("TM_Object", "An ISO time instant or time interval.", false, TimeValue::new, TypeReferencesHelper.TYPE_REFERENCE_TIMEVALUE).registerProperty(EP_START_TIME).registerProperty(EP_VALUE_END_TIME);
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeComplex.class.getName());
    private static final Map<String, TypeComplex> TYPES = new HashMap<String, TypeComplex>();
    private final Set<Property> properties = new LinkedHashSet<Property>();
    private final Map<String, Property> propertiesByName = new LinkedHashMap<String, Property>();
    private final boolean openType;
    private Instantiator instantiator;

    public static TypeComplex getType(String name) {
        return TYPES.get(name);
    }

    public TypeComplex(String name, String description, boolean openType) {
        super(name, description, null, null);
        this.openType = openType;
    }

    public TypeComplex(String name, String description, boolean openType, Instantiator instantiator, TypeReference tr) {
        super(name, description, ParserUtils.getDefaultDeserializer(tr), null);
        this.openType = openType;
        this.instantiator = instantiator;
    }

    public TypeComplex(String name, String description, boolean openType, Instantiator instantiator, JsonDeserializer jd, JsonSerializer js) {
        super(name, description, jd, js);
        this.openType = openType;
        this.instantiator = instantiator;
    }

    public boolean isOpenType() {
        return this.openType;
    }

    public Set<Property> getProperties() {
        return this.properties;
    }

    public Property getProperty(String name) {
        return this.propertiesByName.get(name);
    }

    public Map<String, Property> getPropertiesByName() {
        return this.propertiesByName;
    }

    public TypeComplex registerProperty(Property property) {
        this.properties.add(property);
        this.propertiesByName.put(property.getName(), property);
        return this;
    }

    public String toString() {
        return "TypeComplex: " + this.getName();
    }

    @Override
    public JsonSerializer getSerializer() {
        JsonSerializer<Object> serializer = super.getSerializer();
        if (serializer == null) {
            serializer = ParserUtils.getDefaultSerializer();
            this.setSerializer(serializer);
        }
        return serializer;
    }

    @Override
    public JsonDeserializer getDeserializer() {
        JsonDeserializer<ComplexValue> deserializer = super.getDeserializer();
        if (deserializer == null) {
            deserializer = ParserUtils.getComplexTypeDeserializer(this);
            this.setDeserializer(deserializer);
        }
        return deserializer;
    }

    public void setInstantiator(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    public ComplexValue instantiate() {
        if (this.instantiator == null) {
            this.instantiator = ComplexValueImpl.createFor(this);
        }
        return this.instantiator.instantiate();
    }

    static {
        for (Field field : FieldUtils.getAllFields(TypeComplex.class)) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                TypeComplex type = (TypeComplex)FieldUtils.readStaticField(field, false);
                String name = type.getName();
                TYPES.put(name, type);
                LOGGER.debug("Registered type: {}", (Object)name);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.error("Failed to initialise: {}", (Object)field, (Object)ex);
            }
            catch (IllegalAccessException ex) {
                LOGGER.trace("Failed to initialise: {}", (Object)field, (Object)ex);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        TYPES.put(STA_TIMEINTERVAL_ALIAS, TYPES.get(STA_TIMEINTERVAL_NAME));
        TYPES.put(STA_TIMEVALUE_ALIAS, TYPES.get(STA_TIMEVALUE_NAME));
        TYPES.put(STA_TIMEVALUE_ALIAS2, TYPES.get(STA_TIMEVALUE_NAME));
    }

    public static interface Instantiator {
        public ComplexValue instantiate();
    }
}

