/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.property.type;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import de.fraunhofer.iosb.ilt.frostserver.model.core.annotations.Annotatable;
import de.fraunhofer.iosb.ilt.frostserver.model.core.annotations.Annotation;
import de.fraunhofer.iosb.ilt.frostserver.util.ParserUtils;
import java.util.ArrayList;
import java.util.List;

public class PropertyType
implements Annotatable {
    private final String name;
    private final String description;
    private JsonDeserializer deserializer;
    private JsonSerializer serializer;
    private final List<Annotation> annotations = new ArrayList<Annotation>();

    public PropertyType(String name, String description, JsonDeserializer deserializer, JsonSerializer serializer) {
        this.name = name;
        this.description = description;
        this.deserializer = deserializer;
        this.serializer = serializer;
    }

    public PropertyType(String name, String description, JsonDeserializer deserializer) {
        this(name, description, deserializer, ParserUtils.getDefaultSerializer());
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public JsonDeserializer getDeserializer() {
        return this.deserializer;
    }

    public PropertyType setDeserializer(JsonDeserializer deserializer) {
        this.deserializer = deserializer;
        return this;
    }

    public JsonSerializer getSerializer() {
        return this.serializer;
    }

    public PropertyType setSerializer(JsonSerializer serializer) {
        this.serializer = serializer;
        return this;
    }

    public Object parseFromUrl(String input) {
        throw new IllegalArgumentException("Don't know how to parse for " + this.name);
    }

    public boolean isCollection() {
        return false;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public PropertyType addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
        return this;
    }

    public PropertyType addAnnotations(List<Annotation> annotationsToAdd) {
        this.annotations.addAll(annotationsToAdd);
        return this;
    }
}

