/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.property;

import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.property.type.PropertyType;
import java.util.Objects;

public class PropertyReference<P>
implements Property<P> {
    private final String name;
    private final Property<P> referencedProperty;

    public PropertyReference(String name, Property referencedProperty) {
        this.name = name;
        this.referencedProperty = referencedProperty;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Property getReferencedProperty() {
        return this.referencedProperty;
    }

    @Override
    public String getJsonName() {
        return this.getName();
    }

    @Override
    public PropertyType getType() {
        return this.referencedProperty.getType();
    }

    @Override
    public boolean isRequired() {
        return this.referencedProperty.isRequired();
    }

    @Override
    public boolean isNullable() {
        return this.referencedProperty.isNullable();
    }

    @Override
    public boolean isReadOnly() {
        return this.referencedProperty.isReadOnly();
    }

    @Override
    public P getFrom(Entity entity) {
        return this.referencedProperty.getFrom(entity);
    }

    @Override
    public void setOn(Entity entity, P value) {
        this.referencedProperty.setOn(entity, value);
    }

    @Override
    public boolean isSetOn(Entity entity) {
        return this.referencedProperty.isSetOn(entity);
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + Objects.hashCode(this.name);
        return 17 * hash + Objects.hashCode(this.referencedProperty);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyReference other = (PropertyReference)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return Objects.equals(this.referencedProperty, other.referencedProperty);
    }

    public String toString() {
        return this.getName() + "->" + this.referencedProperty;
    }
}

