/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.property;

import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.property.type.PropertyType;
import java.util.Comparator;

public interface Property<P>
extends Comparable<Property<?>> {
    public static final Comparator<Property> COMPARATOR = Comparator.comparingInt(p -> p.getPriority()).thenComparing(Property::getName);

    public String getName();

    public String getJsonName();

    public PropertyType getType();

    public boolean isRequired();

    public boolean isNullable();

    public boolean isReadOnly();

    public P getFrom(Entity var1);

    public void setOn(Entity var1, P var2);

    public boolean isSetOn(Entity var1);

    default public int getPriority() {
        return 0;
    }

    @Override
    default public int compareTo(Property o) {
        return COMPARATOR.compare(this, o);
    }
}

