/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.property;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.model.core.NavigableElement;
import de.fraunhofer.iosb.ilt.frostserver.model.core.annotations.Annotatable;
import de.fraunhofer.iosb.ilt.frostserver.model.core.annotations.Annotation;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.path.UrlHelper;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.PropertyAbstract;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeComplex;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeEntity;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class NavigationPropertyMain<P extends NavigableElement>
extends PropertyAbstract<P>
implements Annotatable,
NavigationProperty<P> {
    private EntityType entityType;
    private final boolean entitySet;
    private NavigationPropertyMain<?> inverse;
    private final List<Annotation> annotations = new ArrayList<Annotation>();
    private final int priority;

    private NavigationPropertyMain(String propertyName, boolean isSet, boolean required, boolean nullable, int priority) {
        super(propertyName, TypeComplex.STA_OBJECT, required, nullable, false);
        this.entitySet = isSet;
        this.required = required;
        this.nullable = nullable;
        this.priority = priority;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
        if (this.entitySet) {
            this.setType(new TypeEntitySet(entityType));
        } else {
            this.setType(new TypeEntity(entityType));
        }
    }

    @Override
    public NavigationPropertyMain getInverse() {
        return this.inverse;
    }

    public final void setInverse(NavigationPropertyMain inverse) {
        this.inverse = inverse;
    }

    public final void setInverses(NavigationPropertyMain inverse) {
        this.inverse = inverse;
        inverse.setInverse(this);
    }

    @Override
    public EntityType getEntityType() {
        return this.entityType;
    }

    @Override
    public boolean validFor(EntityType entityType) {
        return entityType.getProperty(this.getName()) instanceof NavigationProperty;
    }

    @Override
    public boolean isEntitySet() {
        return this.entitySet;
    }

    @Override
    public boolean isAdminOnly() {
        return this.entityType.isAdminOnly();
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    @Override
    public P getFrom(Entity entity) {
        return (P)((NavigableElement)entity.getProperty(this));
    }

    @Override
    public void setOn(Entity entity, P value) {
        entity.setProperty(this, value);
    }

    @Override
    public boolean isSetOn(Entity entity) {
        return entity.isSetProperty(this);
    }

    @Override
    public String getNavigationLink(Entity parent) {
        String selfLink = parent.getSelfLink();
        if (selfLink == null) {
            return null;
        }
        Object link = selfLink + "/" + this.getName();
        Query query = parent.getQuery();
        if (query != null && !query.getSettings().useAbsoluteNavigationLinks()) {
            ResourcePath path = query.getPath();
            String curPath = path.getServiceRootUrl() + "/" + path.getVersion().urlPart + path.getPath();
            link = UrlHelper.getRelativePath((String)link, curPath);
        }
        return link;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public NavigationPropertyMain<P> addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
        return this;
    }

    public NavigationPropertyMain<P> addAnnotations(List<Annotation> annotationsToAdd) {
        this.annotations.addAll(annotationsToAdd);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NavigationPropertyMain other = (NavigationPropertyMain)obj;
        return Objects.equals(this.getName(), other.getName());
    }

    public int hashCode() {
        return Objects.hashCode(this.getName());
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public static class NavigationPropertyEntitySet
    extends NavigationPropertyMain<EntitySet> {
        public NavigationPropertyEntitySet(String propertyName) {
            this(propertyName, null, 0);
        }

        public NavigationPropertyEntitySet(String propertyName, int priority) {
            this(propertyName, null, priority);
        }

        public NavigationPropertyEntitySet(String propertyName, NavigationPropertyMain inverse) {
            this(propertyName, inverse, 0);
        }

        public NavigationPropertyEntitySet(String propertyName, NavigationPropertyMain inverse, int priority) {
            super(propertyName, true, false, true, priority);
            if (inverse != null) {
                this.setInverses(inverse);
            }
        }
    }

    public static class NavigationPropertyEntity
    extends NavigationPropertyMain<Entity> {
        public NavigationPropertyEntity(String propertyName, boolean required) {
            this(propertyName, null, required, 0);
        }

        public NavigationPropertyEntity(String propertyName, boolean required, int priority) {
            this(propertyName, null, required, priority);
        }

        public NavigationPropertyEntity(String propertyName, NavigationPropertyMain inverse, boolean required) {
            this(propertyName, inverse, required, 0);
        }

        public NavigationPropertyEntity(String propertyName, NavigationPropertyMain inverse, boolean required, int priority) {
            super(propertyName, false, required, !required, priority);
            if (inverse != null) {
                this.setInverses(inverse);
            }
        }
    }
}

