/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.property;

import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.annotations.Annotatable;
import de.fraunhofer.iosb.ilt.frostserver.model.core.annotations.Annotation;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.PropertyAbstract;
import de.fraunhofer.iosb.ilt.frostserver.property.type.PropertyType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class EntityPropertyMain<P>
extends PropertyAbstract<P>
implements Annotatable,
EntityProperty<P> {
    public final boolean hasCustomProperties;
    public final boolean serialiseNull;
    private final Collection<String> aliases;
    private final List<Annotation> annotations = new ArrayList<Annotation>();

    public EntityPropertyMain(String name, PropertyType type) {
        this(name, type, false, true, false, false);
    }

    public EntityPropertyMain(String name, PropertyType type, boolean required, boolean nullable) {
        this(name, type, required, nullable, false, false);
    }

    public EntityPropertyMain(String name, PropertyType type, boolean required, boolean nullable, boolean hasCustomProperties, boolean serialiseNull) {
        super(name, type, required, nullable, false);
        this.nullable = nullable;
        this.aliases = new ArrayList<String>();
        this.aliases.add(name);
        this.hasCustomProperties = hasCustomProperties;
        this.serialiseNull = serialiseNull;
    }

    public Collection<String> getAliases() {
        return this.aliases;
    }

    public EntityPropertyMain<P> setAliases(String ... aliases) {
        if (this.aliases.size() != 1) {
            throw new IllegalStateException("Aliases already set for " + this.getName());
        }
        this.aliases.addAll(Arrays.asList(aliases));
        return this;
    }

    public EntityPropertyMain<P> setRequired(boolean required) {
        this.required = required;
        return this;
    }

    public EntityPropertyMain<P> setNullable(boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public EntityPropertyMain<P> setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Override
    public P getFrom(Entity entity) {
        return entity.getProperty(this);
    }

    @Override
    public boolean isSetOn(Entity entity) {
        return entity.isSetProperty(this);
    }

    @Override
    public void setOn(Entity entity, P value) {
        entity.setProperty(this, value);
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public EntityPropertyMain<P> addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
        return this;
    }

    public EntityPropertyMain<P> addAnnotations(List<Annotation> annotationsToAdd) {
        this.annotations.addAll(annotationsToAdd);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityPropertyMain other = (EntityPropertyMain)obj;
        return Objects.equals(this.getName(), other.getName());
    }

    public int hashCode() {
        return Objects.hashCode(this.getName());
    }
}

