/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator;

import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorSubclass;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.JooqPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories.HookPreInsert;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator.HookValidator;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator.ValidationCheck;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.ForbiddenException;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.UnauthorizedException;
import de.fraunhofer.iosb.ilt.frostserver.util.user.PrincipalExtended;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorCUD
implements HookValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidatorCUD.class);
    private static final String OPERATION_NOT_ALLOWED = "Operation not allowed.";
    @ConfigurableField(editor=EditorSubclass.class, label="Early Insert Check", description="The check to validate if the user can insert. Runs before required relations are validated.")
    @EditorSubclass.EdOptsSubclass(iface=ValidationCheck.class, merge=true, nameField="@class", shortenClassNames=true)
    private ValidationCheck checkInsertPreRel;
    @ConfigurableField(editor=EditorSubclass.class, label="Insert Check", description="The check to validate if the user can insert. Runs after required relations are validated.")
    @EditorSubclass.EdOptsSubclass(iface=ValidationCheck.class, merge=true, nameField="@class", shortenClassNames=true)
    private ValidationCheck checkInsert;
    @ConfigurableField(editor=EditorSubclass.class, label="Update Check", description="The check to validate if the user can insert.")
    @EditorSubclass.EdOptsSubclass(iface=ValidationCheck.class, merge=true, nameField="@class", shortenClassNames=true)
    private ValidationCheck checkUpdate;
    @ConfigurableField(editor=EditorSubclass.class, label="Delete Check", description="The check to validate if the user can insert.")
    @EditorSubclass.EdOptsSubclass(iface=ValidationCheck.class, merge=true, nameField="@class", shortenClassNames=true)
    private ValidationCheck checkDelete;

    @Override
    public void registerHooks(StaMainTable mainTable, JooqPersistenceManager ppm) {
        LOGGER.info("    Registering hooks for {}", (Object)mainTable.getName());
        EntityType entityType = mainTable.getEntityType();
        if (this.getCheckInsertPreRel() != null) {
            LOGGER.info("    - insert pre relations: {}", (Object)this.getCheckInsertPreRel());
            mainTable.registerHookPreInsert(-10.0, (phase, pm, entity, insertFields) -> {
                if (PrincipalExtended.getLocalPrincipal().isAdmin()) {
                    return true;
                }
                if (phase == HookPreInsert.Phase.PRE_RELATIONS && !this.checkInsertPreRel.check(pm, entity)) {
                    this.throwUnautorizedOrForbidden(OPERATION_NOT_ALLOWED);
                }
                return true;
            });
        }
        if (this.getCheckInsert() != null) {
            LOGGER.info("    - insert: {}", (Object)this.getCheckInsert());
            mainTable.registerHookPreInsert(-10.0, (phase, pm, entity, insertFields) -> {
                if (PrincipalExtended.getLocalPrincipal().isAdmin()) {
                    return true;
                }
                if (phase == HookPreInsert.Phase.POST_RELATIONS && !this.checkInsert.check(pm, entity)) {
                    this.throwUnautorizedOrForbidden(OPERATION_NOT_ALLOWED);
                }
                return true;
            });
        }
        if (this.getCheckUpdate() != null) {
            LOGGER.info("    - update: {}", (Object)this.getCheckUpdate());
            mainTable.registerHookPreUpdate(-10.0, (pm, entity, id, updateMode) -> {
                if (PrincipalExtended.getLocalPrincipal().isAdmin()) {
                    return;
                }
                if (!this.checkUpdate.check(pm, entity)) {
                    this.throwUnautorizedOrForbidden(OPERATION_NOT_ALLOWED);
                }
            });
        }
        if (this.getCheckDelete() != null) {
            LOGGER.info("    - delete: {}", (Object)this.getCheckDelete());
            mainTable.registerHookPreDelete(-10.0, (pm, id) -> {
                if (PrincipalExtended.getLocalPrincipal().isAdmin()) {
                    return;
                }
                Entity entity = pm.get(entityType, id);
                if (!this.checkDelete.check(pm, entity)) {
                    this.throwUnautorizedOrForbidden(OPERATION_NOT_ALLOWED);
                }
            });
        }
    }

    public ValidationCheck getCheckInsertPreRel() {
        return this.checkInsertPreRel;
    }

    public ValidatorCUD setCheckInsertPreRel(ValidationCheck checkInsertPreRel) {
        this.checkInsertPreRel = checkInsertPreRel;
        return this;
    }

    public ValidationCheck getCheckInsert() {
        return this.checkInsert;
    }

    public ValidatorCUD setCheckInsert(ValidationCheck checkInsert) {
        this.checkInsert = checkInsert;
        return this;
    }

    public ValidationCheck getCheckUpdate() {
        return this.checkUpdate;
    }

    public ValidatorCUD setCheckUpdate(ValidationCheck checkUpdate) {
        this.checkUpdate = checkUpdate;
        return this;
    }

    public ValidationCheck getCheckDelete() {
        return this.checkDelete;
    }

    public ValidatorCUD setCheckDelete(ValidationCheck checkDelete) {
        this.checkDelete = checkDelete;
        return this;
    }

    private void throwUnautorizedOrForbidden(String cause) {
        if (PrincipalExtended.ANONYMOUS_PRINCIPAL.equals(PrincipalExtended.getLocalPrincipal())) {
            throw new UnauthorizedException(cause);
        }
        throw new ForbiddenException(cause);
    }
}

