/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator;

import de.fraunhofer.iosb.ilt.configurable.AnnotatedConfigurable;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableClass;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorClass;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorList;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorSubclass;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.JooqPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator.SecurityTableWrapper;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator.UserCondition;
import java.util.List;
import org.jooq.Table;

@ConfigurableClass
public class SecurityWrapperMulti
implements SecurityTableWrapper {
    @ConfigurableField(editor=EditorList.class, label="Wrappers", description="The wrappers and conditions in which to apply them.")
    @EditorList.EdOptsList(editor=EditorClass.class)
    @EditorClass.EdOptsClass(clazz=IfConditionThenWrapper.class)
    private List<IfConditionThenWrapper> wrappers;

    @Override
    public Table wrap(StaMainTable table, JooqPersistenceManager pm) {
        for (IfConditionThenWrapper ifThen : this.wrappers) {
            if (!ifThen.getCondition().isValid(pm)) continue;
            return ifThen.getWrapper().wrap(table, pm);
        }
        return table;
    }

    public List<IfConditionThenWrapper> getWrappers() {
        return this.wrappers;
    }

    public SecurityWrapperMulti setWrappers(List<IfConditionThenWrapper> wrappers) {
        this.wrappers = wrappers;
        return this;
    }

    @ConfigurableClass
    public static class IfConditionThenWrapper
    implements AnnotatedConfigurable<Void, Void> {
        @ConfigurableField(editor=EditorSubclass.class, label="If", description="The condition in which to apply the Wrapper")
        @EditorSubclass.EdOptsSubclass(iface=UserCondition.class, merge=true, nameField="@class", shortenClassNames=true)
        private UserCondition condition;
        @ConfigurableField(editor=EditorSubclass.class, label="Then", description="The wrapper to use of the condition is valid")
        @EditorSubclass.EdOptsSubclass(iface=SecurityTableWrapper.class, merge=true, nameField="@class", shortenClassNames=true)
        private SecurityTableWrapper wrapper;

        public UserCondition getCondition() {
            return this.condition;
        }

        public IfConditionThenWrapper setCondition(UserCondition condition) {
            this.condition = condition;
            return this;
        }

        public SecurityTableWrapper getWrapper() {
            return this.wrapper;
        }

        public IfConditionThenWrapper setWrapper(SecurityTableWrapper wrapper) {
            this.wrapper = wrapper;
            return this;
        }
    }
}

