/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.fraunhofer.iosb.ilt.configurable.AnnotatedConfigurable;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableClass;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorBoolean;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorClass;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorEnum;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorList;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.JooqPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator.SecurityTableWrapper;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import de.fraunhofer.iosb.ilt.frostserver.util.user.PrincipalExtended;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jooq.Record;
import org.jooq.SQL;
import org.jooq.SelectConditionStep;
import org.jooq.SelectJoinStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;

@ConfigurableClass
public class SecurityWrapperJoin
implements SecurityTableWrapper {
    @ConfigurableField(editor=EditorList.class, label="Joins", description="The list of joins to apply. The main table is aliassed to 't'.")
    @EditorList.EdOptsList(editor=EditorClass.class)
    @EditorClass.EdOptsClass(clazz=TableJoin.class)
    private List<TableJoin> joins;
    @ConfigurableField(editor=EditorString.class, optional=true, label="Where", description="A final where for the query. The main table is aliassed to 't'.")
    @EditorString.EdOptsString
    private String where;
    @ConfigurableField(editor=EditorBoolean.class, optional=true, label="Username", description="Flag indicating there is a parameter ? in the SQL that should be replaced with the principal.")
    @EditorBoolean.EdOptsBool
    private boolean usernameParameter;
    @ConfigurableField(editor=EditorBoolean.class, optional=true, label="Groups", description="Flag indicating there is a parameter ? in the SQL that should be replaces with the group-set.")
    @EditorBoolean.EdOptsBool
    private boolean groupSetParameter;
    private int paramCount = -1;

    @Override
    public Table wrap(StaMainTable table, JooqPersistenceManager pm) {
        SelectConditionStep finalExists;
        PrincipalExtended principal = PrincipalExtended.getLocalPrincipal();
        StaTable tableIn = table.as("t");
        SelectJoinStep exists = DSL.select(DSL.one()).from((TableLike<?>)tableIn);
        block4: for (TableJoin join : this.joins) {
            SQL joinPart;
            if (join.usernameParameter) {
                joinPart = DSL.sql(join.joinOnSql, principal.getName());
            } else if (join.groupSetParameter) {
                String[] groups = (String[])principal.getRoles().toArray(String[]::new);
                joinPart = DSL.sql(join.joinOnSql, new Object[]{groups});
            } else {
                joinPart = DSL.sql(join.joinOnSql);
            }
            switch (join.joinType) {
                case LEFT: {
                    exists = exists.leftJoin(join.getTargetTable()).on(joinPart);
                    continue block4;
                }
                case RIGHT: {
                    exists = exists.rightJoin(join.getTargetTable()).on(joinPart);
                    continue block4;
                }
            }
            exists = exists.innerJoin(join.getTargetTable()).on(joinPart);
        }
        if (!StringHelper.isNullOrEmpty(this.where)) {
            if (this.paramCount < 0) {
                this.paramCount = StringUtils.countMatches((CharSequence)this.where, '?');
            }
            if (this.paramCount > 0) {
                Object[] params = new Object[this.paramCount];
                if (this.usernameParameter) {
                    Arrays.fill(params, principal.getName());
                } else if (this.groupSetParameter) {
                    String[] groups = (String[])principal.getRoles().toArray(String[]::new);
                    Arrays.fill(params, groups);
                }
                SelectConditionStep finalExists2 = exists.where(table.joinSelf((StaMainTable)tableIn)).and(this.where, params);
                return table.whereExists(finalExists2).asTable("tOut");
            }
            finalExists = exists.where(table.joinSelf((StaMainTable)tableIn)).and(this.where);
            return table.whereExists(finalExists).asTable("tOut");
        }
        finalExists = exists.where(table.joinSelf((StaMainTable)tableIn));
        return table.whereExists(finalExists).asTable("tOut");
    }

    public List<TableJoin> getJoins() {
        return this.joins;
    }

    public SecurityWrapperJoin setJoins(List<TableJoin> joins) {
        this.joins = joins;
        return this;
    }

    public String getWhere() {
        return this.where;
    }

    public SecurityWrapperJoin setWhere(String where) {
        this.where = where;
        return this;
    }

    public boolean isUsernameParameter() {
        return this.usernameParameter;
    }

    public SecurityWrapperJoin setUsernameParameter(boolean usernameParameter) {
        this.usernameParameter = usernameParameter;
        return this;
    }

    public boolean isGroupSetParameter() {
        return this.groupSetParameter;
    }

    public SecurityWrapperJoin setGroupSetParameter(boolean groupSetParameter) {
        this.groupSetParameter = groupSetParameter;
        return this;
    }

    @ConfigurableClass
    public static class TableJoin
    implements AnnotatedConfigurable<Void, Void> {
        @ConfigurableField(editor=EditorString.class, label="Target Table", description="The name of the target table to join.")
        @EditorString.EdOptsString
        public String targetTable;
        @ConfigurableField(editor=EditorString.class, label="Target Table Alias", description="The alias the target table gets when joining. Use this in the Join SQL.")
        @EditorString.EdOptsString
        public String targetAlias;
        @ConfigurableField(editor=EditorString.class, label="Join SQL", description="The full SQL join.")
        @EditorString.EdOptsString
        public String joinOnSql;
        @ConfigurableField(editor=EditorBoolean.class, optional=true, label="Username", description="Flag indicating there is a parameter :username in the SQL.")
        @EditorBoolean.EdOptsBool
        public boolean usernameParameter;
        @ConfigurableField(editor=EditorBoolean.class, optional=true, label="Groups", description="Flag indicating there is a parameter :usergroups in the SQL.")
        @EditorBoolean.EdOptsBool
        public boolean groupSetParameter;
        @ConfigurableField(editor=EditorEnum.class, label="Join Type", description="The type of join to use.")
        @EditorEnum.EdOptsEnum(sourceType=JoinType.class, dflt="INNER")
        public JoinType joinType = JoinType.INNER;
        @JsonIgnore
        public Table<Record> aliassedTable;

        public Table<Record> getTargetTable() {
            if (this.aliassedTable == null) {
                this.aliassedTable = this.targetAlias == null ? DSL.table(DSL.name(this.targetTable)) : DSL.table(DSL.name(this.targetTable)).as(this.targetAlias);
            }
            return this.aliassedTable;
        }

        public static enum JoinType {
            INNER,
            LEFT,
            RIGHT;

        }
    }
}

