/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator;

import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorEnum;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorList;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.JooqPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator.UserCondition;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator.ValidationCheck;
import de.fraunhofer.iosb.ilt.frostserver.util.user.PrincipalExtended;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class CheckUserHasRoles
implements ValidationCheck,
UserCondition {
    @ConfigurableField(editor=EditorEnum.class, label="Check Type", description="Should the user be in ANY of the listed groups, or in ALL of the groups.")
    @EditorEnum.EdOptsEnum(sourceType=Type.class, dflt="ANY")
    private Type checkType;
    @ConfigurableField(editor=EditorList.class, label="Groups", description="The groups to check the user's groups against.")
    @EditorList.EdOptsList(editor=EditorString.class)
    @EditorString.EdOptsString
    private List<String> roles;

    @Override
    public boolean check(JooqPersistenceManager pm, Entity context) {
        return this.isValid(pm);
    }

    @Override
    public boolean isValid(JooqPersistenceManager pm) {
        Set<String> userRoles = PrincipalExtended.getLocalPrincipal().getRoles();
        if (this.getCheckType() == Type.ANY) {
            for (String checkRole : this.getRoles()) {
                if (!userRoles.contains(checkRole)) continue;
                return true;
            }
            return false;
        }
        return userRoles.containsAll(this.getRoles());
    }

    public Type getCheckType() {
        return this.checkType;
    }

    public CheckUserHasRoles setCheckType(Type vheckType) {
        this.checkType = vheckType;
        return this;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public CheckUserHasRoles setRoles(String ... roles) {
        this.roles = Arrays.asList(roles);
        return this;
    }

    public String toString() {
        return "CheckUserHasRoles: " + this.checkType + " " + Arrays.toString(this.roles.toArray());
    }

    public static enum Type {
        ANY,
        ALL;

    }
}

