/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator;

import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.QueryParser;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.JooqPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator.UserCondition;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator.ValidationCheck;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.query.QueryDefaults;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.DynamicContext;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.user.PrincipalExtended;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckStandaloneQuery
implements ValidationCheck,
UserCondition {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckStandaloneQuery.class);
    @ConfigurableField(editor=EditorString.class, label="EntityType", description="The EntityType to query.")
    @EditorString.EdOptsString
    private String entityTypeName;
    @ConfigurableField(editor=EditorString.class, label="Query", description="The Query runs without direct context.")
    @EditorString.EdOptsString
    private String query;
    private ResourcePath path;
    private EntityType entityType;
    private DynamicContext context;
    private Query parsedQuery;

    @Override
    public boolean check(JooqPersistenceManager pm, Entity contextEntity) {
        return this.isValid(pm);
    }

    private void init(JooqPersistenceManager pm) {
        this.entityType = pm.getCoreSettings().getModelRegistry().getEntityTypeForName(this.entityTypeName, true);
        CoreSettings coreSettings = pm.getCoreSettings();
        this.path = new ResourcePath("", Version.V_1_1, "/" + this.entityType.plural).addPathElement(new PathElementEntitySet(this.entityType));
        this.context = new DynamicContext();
        QueryDefaults queryDefaults = coreSettings.getQueryDefaults();
        ModelRegistry modelRegistry = coreSettings.getModelRegistry();
        this.parsedQuery = QueryParser.parseQuery(this.getQuery(), queryDefaults, modelRegistry, this.path, PrincipalExtended.INTERNAL_ADMIN_PRINCIPAL, this.context).validate(null, this.entityType);
        LOGGER.info("Initialised check on {}", (Object)this.entityType);
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getEntityTypeName() {
        return this.entityTypeName;
    }

    public void setEntityTypeName(String entityTypeName) {
        this.entityTypeName = entityTypeName;
    }

    public String toString() {
        return "CheckQuery: " + this.entityType + ": " + this.query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(JooqPersistenceManager pm) {
        if (this.parsedQuery == null) {
            this.init(pm);
        }
        PrincipalExtended userPrincipal = PrincipalExtended.getLocalPrincipal();
        try {
            this.context.setUser(userPrincipal);
            PrincipalExtended.setLocalPrincipal(PrincipalExtended.INTERNAL_ADMIN_PRINCIPAL);
            EntitySet result = pm.get(this.path, this.parsedQuery, EntitySet.class);
            PrincipalExtended.setLocalPrincipal(userPrincipal);
            boolean valid = result != null && !result.isEmpty();
            LOGGER.debug("  Check on {}: {}", (Object)this.entityType, (Object)valid);
            boolean bl = valid;
            return bl;
        }
        finally {
            PrincipalExtended.setLocalPrincipal(userPrincipal);
            this.context.clear();
        }
    }
}

