/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator;

import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorEnum;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorList;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.JooqPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator.CheckMulti;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator.CheckNavLinkEmpty;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator.ValidationCheck;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckNavLinksEmpty
implements ValidationCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckNavLinksEmpty.class);
    @ConfigurableField(editor=EditorList.class, label="Target NavLinks", description="The navLinks that must be (not) set.")
    @EditorList.EdOptsList(editor=EditorString.class)
    @EditorString.EdOptsString
    private List<String> targetNavLinks;
    @ConfigurableField(editor=EditorEnum.class, label="Req. State", description="The required state: empty or filled (non-empty)")
    @EditorEnum.EdOptsEnum(sourceType=CheckNavLinkEmpty.EmptyState.class, dflt="MUST_BE_EMPTY")
    private CheckNavLinkEmpty.EmptyState requiredState = CheckNavLinkEmpty.EmptyState.MUST_BE_EMPTY;
    @ConfigurableField(editor=EditorEnum.class, label="Combine Type", description="How to combine checks. Executed as fail-fast.")
    @EditorEnum.EdOptsEnum(sourceType=CheckMulti.Type.class, dflt="AND")
    private CheckMulti.Type combineType;
    private EntityType entityType;
    private List<NavigationPropertyMain> targetNps;

    @Override
    public boolean check(JooqPersistenceManager pm, Entity contextEntity) {
        boolean filledRequired;
        if (this.targetNps == null) {
            this.init(contextEntity);
        }
        boolean emptyRequired = this.requiredState == CheckNavLinkEmpty.EmptyState.MUST_BE_EMPTY;
        boolean bl = filledRequired = this.requiredState == CheckNavLinkEmpty.EmptyState.MUST_BE_FILLED;
        if (this.combineType == CheckMulti.Type.AND) {
            for (NavigationPropertyMain targetNp : this.targetNps) {
                boolean valid = this.checkNavLink(targetNp, contextEntity, emptyRequired, filledRequired);
                if (valid) continue;
                return false;
            }
            return true;
        }
        for (NavigationPropertyMain targetNp : this.targetNps) {
            boolean valid = this.checkNavLink(targetNp, contextEntity, emptyRequired, filledRequired);
            if (!valid) continue;
            return true;
        }
        return false;
    }

    private boolean checkNavLink(NavigationPropertyMain targetNp, Entity contextEntity, boolean emptyRequired, boolean filledRequired) {
        boolean valid;
        if (targetNp instanceof NavigationPropertyMain.NavigationPropertyEntity) {
            NavigationPropertyMain.NavigationPropertyEntity targetNpEntity = (NavigationPropertyMain.NavigationPropertyEntity)targetNp;
            Entity targetEntity = contextEntity.getProperty(targetNpEntity);
            boolean empty = targetEntity == null;
            valid = emptyRequired && empty || filledRequired && !empty;
            LOGGER.debug("  Check on {}.{}: {}", this.entityType, targetNp, valid);
        } else if (targetNp instanceof NavigationPropertyMain.NavigationPropertyEntitySet) {
            NavigationPropertyMain.NavigationPropertyEntitySet targetNpEntitySet = (NavigationPropertyMain.NavigationPropertyEntitySet)targetNp;
            EntitySet targetEntities = contextEntity.getProperty(targetNpEntitySet);
            boolean empty = targetEntities == null || targetEntities.isEmpty();
            valid = emptyRequired && empty || filledRequired && !empty;
            LOGGER.debug("  Check on {}.{}: {}", this.entityType, targetNp, valid);
        } else {
            valid = false;
        }
        return valid;
    }

    private synchronized void init(Entity contextEntity) {
        if (this.targetNps != null) {
            return;
        }
        this.entityType = contextEntity.getEntityType();
        this.targetNps = new ArrayList<NavigationPropertyMain>();
        for (String targetNavLink : this.targetNavLinks) {
            NavigationPropertyMain targetNp = this.entityType.getNavigationProperty(targetNavLink);
            this.targetNps.add(targetNp);
        }
        LOGGER.info("Initialised check on {}.{}", (Object)this.entityType, (Object)this.targetNps);
    }

    public List<String> getTargetNavLinks() {
        return this.targetNavLinks;
    }

    public void setTargetNavLinks(List<String> targetNavLinks) {
        this.targetNavLinks = targetNavLinks;
    }

    public CheckMulti.Type getCombineType() {
        return this.combineType;
    }

    public void setCombineType(CheckMulti.Type combineType) {
        this.combineType = combineType;
    }

    public CheckNavLinkEmpty.EmptyState getRequiredState() {
        return this.requiredState;
    }

    public void setRequiredState(CheckNavLinkEmpty.EmptyState requiredState) {
        this.requiredState = requiredState;
    }

    public String toString() {
        return "CheckNavLinkEmpty: " + this.targetNavLinks;
    }
}

