/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator;

import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorBoolean;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.model.core.PkValue;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.QueryParser;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.JooqPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator.ValidationCheck;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.query.QueryDefaults;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.DynamicContext;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.user.PrincipalExtended;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckNavLinkQuery
implements ValidationCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckNavLinkQuery.class);
    @ConfigurableField(editor=EditorString.class, label="Target NavLink", description="The navLink the query targets.")
    @EditorString.EdOptsString
    private String targetNavLink;
    @ConfigurableField(editor=EditorString.class, label="Query", description="The Query to use to find if the user can take the action.")
    @EditorString.EdOptsString
    private String query;
    @ConfigurableField(editor=EditorBoolean.class, label="Empty Allowed", description="Is the Navigation property allowed to be empty?")
    @EditorBoolean.EdOptsBool(dflt=true)
    private boolean emptyAllowed = true;
    private EntityType entityType;
    private EntityType targetType;
    private NavigationPropertyMain targetNp;
    private DynamicContext context;
    private Query parsedQuery;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean check(JooqPersistenceManager pm, Entity contextEntity) {
        block12: {
            if (this.parsedQuery == null) {
                this.init(contextEntity, pm);
            }
            PrincipalExtended localPrincipal = PrincipalExtended.getLocalPrincipal();
            try {
                Object targetEntity;
                this.context.setEntity(contextEntity);
                this.context.setUser(localPrincipal);
                NavigationPropertyMain navigationPropertyMain = this.targetNp;
                if (navigationPropertyMain instanceof NavigationPropertyMain.NavigationPropertyEntity) {
                    NavigationPropertyMain.NavigationPropertyEntity targetNpEntity = (NavigationPropertyMain.NavigationPropertyEntity)navigationPropertyMain;
                    targetEntity = contextEntity.getProperty(targetNpEntity);
                    if (targetEntity == null) {
                        LOGGER.debug("  Check on {}.{} (empty): {}", this.entityType, this.targetNp, this.isEmptyAllowed());
                        boolean bl = this.isEmptyAllowed();
                        return bl;
                    }
                    PkValue targetId = targetEntity.getPrimaryKeyValues();
                    PrincipalExtended.setLocalPrincipal(PrincipalExtended.INTERNAL_ADMIN_PRINCIPAL);
                    Entity result = pm.get(this.targetType, targetId, this.parsedQuery);
                    PrincipalExtended.setLocalPrincipal(localPrincipal);
                    boolean valid = result != null;
                    LOGGER.debug("  Check on {}.{}({}): {}", this.entityType, this.targetNp, targetId, valid);
                    boolean bl = valid;
                    return bl;
                }
                targetEntity = this.targetNp;
                if (!(targetEntity instanceof NavigationPropertyMain.NavigationPropertyEntitySet)) break block12;
                NavigationPropertyMain.NavigationPropertyEntitySet targetNpEntitySet = (NavigationPropertyMain.NavigationPropertyEntitySet)targetEntity;
                EntitySet targetEntities = contextEntity.getProperty(targetNpEntitySet);
                if (targetEntities == null || targetEntities.isEmpty()) {
                    LOGGER.debug("  Check on {}.{} (empty): {}", this.entityType, this.targetNp, this.isEmptyAllowed());
                    boolean bl = this.isEmptyAllowed();
                    return bl;
                }
                for (Entity te : targetEntities) {
                    if (!te.primaryKeyFullySet()) continue;
                    PkValue targetId = te.getPrimaryKeyValues();
                    PrincipalExtended.setLocalPrincipal(PrincipalExtended.INTERNAL_ADMIN_PRINCIPAL);
                    Entity result = pm.get(this.targetType, targetId, this.parsedQuery);
                    PrincipalExtended.setLocalPrincipal(localPrincipal);
                    if (result != null) continue;
                    LOGGER.debug("  Check on {}.{}({}): false", this.entityType, this.targetNp, targetId);
                    boolean bl = false;
                    return bl;
                }
                LOGGER.debug("  Checks ({}) on {}.{}: true", targetEntities.size(), this.entityType, this.targetNp);
                boolean bl = true;
                return bl;
            }
            finally {
                PrincipalExtended.setLocalPrincipal(localPrincipal);
                this.context.clear();
            }
        }
        return false;
    }

    private void init(Entity contextEntity, JooqPersistenceManager pm) {
        try {
            this.entityType = contextEntity.getEntityType();
            this.targetNp = this.entityType.getNavigationProperty(this.getTargetNavLink());
            this.targetType = this.targetNp.getEntityType();
            CoreSettings coreSettings = pm.getCoreSettings();
            ResourcePath path = new ResourcePath("", Version.V_1_1, "/" + this.targetType.plural).addPathElement(new PathElementEntitySet(this.targetType));
            this.context = new DynamicContext();
            QueryDefaults queryDefaults = coreSettings.getQueryDefaults();
            ModelRegistry modelRegistry = coreSettings.getModelRegistry();
            this.parsedQuery = QueryParser.parseQuery(this.getQuery(), queryDefaults, modelRegistry, path, PrincipalExtended.INTERNAL_ADMIN_PRINCIPAL, this.context).validate(null, this.targetType);
            LOGGER.info("Initialised check on {}.{}", (Object)this.entityType, (Object)this.targetNp);
        }
        catch (RuntimeException ex) {
            LOGGER.error("Failed to initialise check.", ex);
            throw new IllegalStateException("Failed to initialise Check Query.");
        }
    }

    public String getTargetNavLink() {
        return this.targetNavLink;
    }

    public void setTargetNavLink(String targetNavLink) {
        this.targetNavLink = targetNavLink;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public boolean isEmptyAllowed() {
        return this.emptyAllowed;
    }

    public CheckNavLinkQuery setEmptyAllowed(boolean emptyAllowed) {
        this.emptyAllowed = emptyAllowed;
        return this;
    }

    public String toString() {
        return "CheckNavLinkQuery " + this.targetNavLink + ": " + this.query;
    }
}

