/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator;

import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorEnum;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.JooqPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator.ValidationCheck;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckNavLinkEmpty
implements ValidationCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckNavLinkEmpty.class);
    @ConfigurableField(editor=EditorString.class, label="Target NavLink", description="The navLink that must be (not) set.")
    @EditorString.EdOptsString
    private String targetNavLink;
    @ConfigurableField(editor=EditorEnum.class, label="Req. State", description="The required state: empty or filled (non-empty)")
    @EditorEnum.EdOptsEnum(sourceType=EmptyState.class, dflt="MUST_BE_EMPTY")
    private EmptyState requiredState = EmptyState.MUST_BE_EMPTY;
    private EntityType entityType;
    private EntityType targetType;
    private NavigationPropertyMain targetNp;

    @Override
    public boolean check(JooqPersistenceManager pm, Entity contextEntity) {
        Object targetEntity;
        if (this.targetType == null) {
            this.init(contextEntity);
        }
        boolean emptyRequired = this.requiredState == EmptyState.MUST_BE_EMPTY;
        boolean filledRequired = this.requiredState == EmptyState.MUST_BE_FILLED;
        NavigationPropertyMain navigationPropertyMain = this.targetNp;
        if (navigationPropertyMain instanceof NavigationPropertyMain.NavigationPropertyEntity) {
            NavigationPropertyMain.NavigationPropertyEntity targetNpEntity = (NavigationPropertyMain.NavigationPropertyEntity)navigationPropertyMain;
            targetEntity = contextEntity.getProperty(targetNpEntity);
            boolean empty = targetEntity == null;
            boolean valid = emptyRequired && empty || filledRequired && !empty;
            LOGGER.debug("  Check on {}.{}: {}", this.entityType, this.targetNp, valid);
            return valid;
        }
        targetEntity = this.targetNp;
        if (targetEntity instanceof NavigationPropertyMain.NavigationPropertyEntitySet) {
            NavigationPropertyMain.NavigationPropertyEntitySet targetNpEntitySet = (NavigationPropertyMain.NavigationPropertyEntitySet)targetEntity;
            EntitySet targetEntities = contextEntity.getProperty(targetNpEntitySet);
            boolean empty = targetEntities == null || targetEntities.isEmpty();
            boolean valid = emptyRequired && empty || filledRequired && !empty;
            LOGGER.debug("  Check on {}.{}: {}", this.entityType, this.targetNp, valid);
            return valid;
        }
        return false;
    }

    private void init(Entity contextEntity) {
        this.entityType = contextEntity.getEntityType();
        this.targetNp = this.entityType.getNavigationProperty(this.getTargetNavLink());
        this.targetType = this.targetNp.getEntityType();
        LOGGER.info("Initialised check on {}.{}", (Object)this.entityType, (Object)this.targetNp);
    }

    public String getTargetNavLink() {
        return this.targetNavLink;
    }

    public void setTargetNavLink(String targetNavLink) {
        this.targetNavLink = targetNavLink;
    }

    public EmptyState getRequiredState() {
        return this.requiredState;
    }

    public void setRequiredState(EmptyState requiredState) {
        this.requiredState = requiredState;
    }

    public String toString() {
        return "CheckNavLinkEmpty: " + this.targetNavLink;
    }

    public static enum EmptyState {
        MUST_BE_EMPTY("Must be Empty"),
        MUST_BE_FILLED("Must be Filled (non Empty)");

        public final String label;

        private EmptyState(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

