/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator;

import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorEnum;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorList;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorSubclass;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.JooqPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator.ValidationCheck;
import java.util.Arrays;
import java.util.List;

public class CheckMulti
implements ValidationCheck {
    @ConfigurableField(editor=EditorEnum.class, label="Combine Type", description="How to combine checks. Executed as fail-fast.")
    @EditorEnum.EdOptsEnum(sourceType=Type.class, dflt="AND")
    private Type combineType;
    @ConfigurableField(editor=EditorList.class, label="Sub Checks", description="The sub-checks to execute.")
    @EditorList.EdOptsList(editor=EditorSubclass.class)
    @EditorSubclass.EdOptsSubclass(iface=ValidationCheck.class, merge=true, nameField="@class", shortenClassNames=true)
    private List<ValidationCheck> subChecks;

    @Override
    public boolean check(JooqPersistenceManager pm, Entity context) {
        if (this.getCombineType() == Type.AND) {
            for (ValidationCheck check : this.getSubChecks()) {
                if (check.check(pm, context)) continue;
                return false;
            }
            return true;
        }
        for (ValidationCheck check : this.getSubChecks()) {
            if (!check.check(pm, context)) continue;
            return true;
        }
        return false;
    }

    public Type getCombineType() {
        return this.combineType;
    }

    public CheckMulti setCombineType(Type combineType) {
        this.combineType = combineType;
        return this;
    }

    public List<ValidationCheck> getSubChecks() {
        return this.subChecks;
    }

    public CheckMulti setSubChecks(List<ValidationCheck> subChecks) {
        this.subChecks = subChecks;
        return this;
    }

    public String toString() {
        return "CheckMulti: " + this.combineType + " " + Arrays.toString(this.subChecks.toArray());
    }

    public static enum Type {
        AND,
        OR;

    }
}

