/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator;

import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.QueryParser;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.JooqPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator.ValidationCheck;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.query.QueryDefaults;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.DynamicContext;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.user.PrincipalExtended;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckEntityQuery
implements ValidationCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckEntityQuery.class);
    @ConfigurableField(editor=EditorString.class, label="Query", description="The Query runs against the entity being edited.")
    @EditorString.EdOptsString
    private String query;
    private EntityType entityType;
    private DynamicContext context;
    private Query parsedQuery;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean check(JooqPersistenceManager pm, Entity contextEntity) {
        if (this.parsedQuery == null) {
            this.init(contextEntity, pm);
        }
        PrincipalExtended localPrincipal = PrincipalExtended.getLocalPrincipal();
        try {
            this.context.setEntity(contextEntity);
            this.context.setUser(localPrincipal);
            PrincipalExtended.setLocalPrincipal(PrincipalExtended.INTERNAL_ADMIN_PRINCIPAL);
            Entity result = pm.get(this.entityType, contextEntity.getPrimaryKeyValues(), this.parsedQuery);
            PrincipalExtended.setLocalPrincipal(localPrincipal);
            boolean valid = result != null;
            LOGGER.debug("  Check on {}: {}", (Object)this.entityType, (Object)valid);
            boolean bl = valid;
            return bl;
        }
        finally {
            PrincipalExtended.setLocalPrincipal(localPrincipal);
            this.context.clear();
        }
    }

    private void init(Entity contextEntity, JooqPersistenceManager pm) {
        this.entityType = contextEntity.getEntityType();
        CoreSettings coreSettings = pm.getCoreSettings();
        ResourcePath path = new ResourcePath("", Version.V_1_1, "/" + this.entityType.plural).addPathElement(new PathElementEntitySet(this.entityType));
        this.context = new DynamicContext();
        QueryDefaults queryDefaults = coreSettings.getQueryDefaults();
        ModelRegistry modelRegistry = coreSettings.getModelRegistry();
        this.parsedQuery = QueryParser.parseQuery(this.getQuery(), queryDefaults, modelRegistry, path, PrincipalExtended.INTERNAL_ADMIN_PRINCIPAL, this.context).validate(null, this.entityType);
        LOGGER.info("Initialised check on {}", (Object)this.entityType);
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String toString() {
        return "CheckQuery: " + this.entityType + ": " + this.query;
    }
}

