/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.fieldmapper;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.JooqPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.bindings.JsonBinding;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.bindings.JsonValue;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories.EntityFactories;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.DataSize;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.PropertyFieldRegistry;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.ResultType;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.Utils;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.fieldmapper.FieldMapperAbstractEp;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Table;

public class FieldMapperResult
extends FieldMapperAbstractEp {
    @ConfigurableField(editor=EditorString.class, label="TypeField", description="The database field to store the type in.")
    @EditorString.EdOptsString
    private String fieldType;
    @ConfigurableField(editor=EditorString.class, label="StringField", description="The database field to use for String values.")
    @EditorString.EdOptsString
    private String fieldString;
    @ConfigurableField(editor=EditorString.class, label="NumberField", description="The database field to use for Number values.")
    @EditorString.EdOptsString
    private String fieldNumber;
    @ConfigurableField(editor=EditorString.class, label="JsonField", description="The database field to use for JSON values.")
    @EditorString.EdOptsString
    private String fieldJson;
    @ConfigurableField(editor=EditorString.class, label="BooleanField", description="The database field to use for Boolean fields.")
    @EditorString.EdOptsString
    private String fieldBoolean;
    @JsonIgnore
    private int fieldTypeIdx;
    @JsonIgnore
    private int fieldStringIdx;
    @JsonIgnore
    private int fieldNumberIdx;
    @JsonIgnore
    private int fieldJsonIdx;
    @JsonIgnore
    private int fieldBooleanIdx;

    @Override
    public void registerField(JooqPersistenceManager ppm, StaMainTable staTable) {
        Name tableName = staTable.getQualifiedName();
        Table<?> dbTable = ppm.getDbTable(tableName);
        this.fieldTypeIdx = FieldMapperResult.getOrRegisterField(this.fieldType, dbTable, staTable);
        this.fieldStringIdx = FieldMapperResult.getOrRegisterField(this.fieldString, dbTable, staTable);
        this.fieldNumberIdx = FieldMapperResult.getOrRegisterField(this.fieldNumber, dbTable, staTable);
        this.fieldJsonIdx = FieldMapperResult.getOrRegisterField(this.fieldJson, dbTable, staTable, JsonBinding.instance());
        this.fieldBooleanIdx = FieldMapperResult.getOrRegisterField(this.fieldBoolean, dbTable, staTable);
    }

    @Override
    public <T extends StaMainTable<T>> void registerMapping(JooqPersistenceManager ppm, T table) {
        PropertyFieldRegistry<StaMainTable> pfReg = table.getPropertyFieldRegistry();
        int idxType = this.fieldTypeIdx;
        int idxString = this.fieldStringIdx;
        int idxNumber = this.fieldNumberIdx;
        int idxJson = this.fieldJsonIdx;
        int idxBoolean = this.fieldBooleanIdx;
        EntityPropertyMain property = this.getParent().getEntityProperty();
        pfReg.addEntry((Property)property, true, new PropertyFieldRegistry.ConverterRecordDeflt<StaMainTable>((t2, tuple, entity, dataSize) -> this.readResultFromDb(entity, property, t2, tuple, dataSize, idxType, idxString, idxNumber, idxBoolean, idxJson), (t2, entity, insertFields) -> this.handleResult(entity, property, t2, insertFields, idxType, idxString, idxNumber, idxBoolean, idxJson), (t2, entity, updateFields, message) -> {
            this.handleResult(entity, property, t2, updateFields, idxType, idxString, idxNumber, idxBoolean, idxJson);
            message.addField(property);
        }), new PropertyFieldRegistry.NFP<StaMainTable>("n", t2 -> t2.field(idxNumber)), new PropertyFieldRegistry.NFP<StaMainTable>("b", t2 -> t2.field(idxBoolean)), new PropertyFieldRegistry.NFP<StaMainTable>("s", t2 -> t2.field(idxString)), new PropertyFieldRegistry.NFP<StaMainTable>("j", t2 -> t2.field(idxJson)), new PropertyFieldRegistry.NFP<StaMainTable>("t", t2 -> t2.field(idxType)));
    }

    private <T extends StaMainTable<T>> void handleResult(Entity entity, Property property, T table, Map<Field, Object> output, int idxReTy, int idxReSt, int idxReNu, int idxReBo, int idxReJs) {
        Object result = entity.getProperty(property);
        if (result instanceof Number) {
            Number number = (Number)result;
            output.put(table.field(idxReTy), ResultType.NUMBER.sqlValue());
            output.put(table.field(idxReSt), result.toString());
            output.put(table.field(idxReNu), number.doubleValue());
            output.put(table.field(idxReBo), null);
            output.put(table.field(idxReJs), null);
        } else if (result instanceof Boolean) {
            output.put(table.field(idxReTy), ResultType.BOOLEAN.sqlValue());
            output.put(table.field(idxReSt), result.toString());
            output.put(table.field(idxReBo), result);
            output.put(table.field(idxReNu), null);
            output.put(table.field(idxReJs), null);
        } else if (result instanceof String) {
            output.put(table.field(idxReTy), ResultType.STRING.sqlValue());
            output.put(table.field(idxReSt), result.toString());
            output.put(table.field(idxReNu), null);
            output.put(table.field(idxReBo), null);
            output.put(table.field(idxReJs), null);
        } else {
            output.put(table.field(idxReTy), ResultType.OBJECT_ARRAY.sqlValue());
            output.put(table.field(idxReJs), EntityFactories.objectToJson(result));
            output.put(table.field(idxReSt), null);
            output.put(table.field(idxReNu), null);
            output.put(table.field(idxReBo), null);
        }
    }

    private <T extends StaMainTable<T>> void readResultFromDb(Entity entity, Property property, T table, Record tuple, DataSize dataSize, int idxReTy, int idxReSt, int idxReNu, int idxReBo, int idxReJs) {
        Short resultTypeOrd = (Short)Utils.getFieldOrNull(tuple, table.field(idxReTy));
        if (resultTypeOrd != null) {
            ResultType resultType = ResultType.fromSqlValue(resultTypeOrd.shortValue());
            switch (resultType) {
                case BOOLEAN: {
                    entity.setProperty(property, Utils.getFieldOrNull(tuple, table.field(idxReBo)));
                    break;
                }
                case NUMBER: {
                    this.handleNumber(entity, property, table, tuple, idxReSt, idxReNu);
                    break;
                }
                case OBJECT_ARRAY: {
                    JsonValue jsonData = Utils.getFieldJsonValue(tuple, table.field(idxReJs));
                    dataSize.increase(jsonData.getStringLength());
                    entity.setProperty(property, jsonData.getValue());
                    break;
                }
                case STRING: {
                    String stringData = (String)Utils.getFieldOrNull(tuple, table.field(idxReSt));
                    dataSize.increase(stringData == null ? 0L : (long)stringData.length());
                    entity.setProperty(property, stringData);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled resultType: " + resultType);
                }
            }
        }
    }

    private <T extends StaMainTable<T>> void handleNumber(Entity entity, Property property, T table, Record tuple, int idxReSt, int idxReNu) {
        try {
            entity.setProperty(property, new BigDecimal((String)Utils.getFieldOrNull(tuple, table.field(idxReSt))));
        }
        catch (NullPointerException | NumberFormatException e) {
            entity.setProperty(property, Utils.getFieldOrNull(tuple, table.field(idxReNu)));
        }
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public FieldMapperResult setFieldType(String fieldType) {
        this.fieldType = fieldType;
        return this;
    }

    public String getFieldString() {
        return this.fieldString;
    }

    public FieldMapperResult setFieldString(String fieldString) {
        this.fieldString = fieldString;
        return this;
    }

    public String getFieldNumber() {
        return this.fieldNumber;
    }

    public FieldMapperResult setFieldNumber(String fieldNumber) {
        this.fieldNumber = fieldNumber;
        return this;
    }

    public String getFieldJson() {
        return this.fieldJson;
    }

    public FieldMapperResult setFieldJson(String fieldJson) {
        this.fieldJson = fieldJson;
        return this;
    }

    public String getFieldBoolean() {
        return this.fieldBoolean;
    }

    public FieldMapperResult setFieldBoolean(String fieldBoolean) {
        this.fieldBoolean = fieldBoolean;
        return this;
    }

    @Override
    public Map<String, String> getFieldTypes() {
        LinkedHashMap<String, String> value = new LinkedHashMap<String, String>();
        value.put(this.fieldType, "TINYINT");
        value.put(this.fieldNumber, "FLOAT8");
        value.put(this.fieldBoolean, "BOOLEAN");
        value.put(this.fieldJson, "JSONB");
        value.put(this.fieldString, "TEXT");
        return value;
    }
}

