/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.fieldmapper;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.JooqPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.PropertyFieldRegistry;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.fieldmapper.FieldMapperAbstractEp;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import java.util.HashMap;
import java.util.Map;
import org.jooq.Name;
import org.jooq.Table;

public class FieldMapperPassword
extends FieldMapperAbstractEp {
    public static final String TAG_PLAIN_TEXT_PASSWORD = "plainTextPassword";
    @ConfigurableField(editor=EditorString.class, label="Field", description="The database field to use.")
    @EditorString.EdOptsString
    private String field;
    @JsonIgnore
    private int fieldIdx;

    @Override
    public void registerField(JooqPersistenceManager ppm, StaMainTable staTable) {
        Name tableName = staTable.getQualifiedName();
        Table<?> dbTable = ppm.getDbTable(tableName);
        this.fieldIdx = FieldMapperPassword.getOrRegisterField(this.field, dbTable, staTable);
    }

    @Override
    public <T extends StaMainTable<T>> void registerMapping(JooqPersistenceManager ppm, T table) {
        boolean plainTextPw = ppm.getCoreSettings().getAuthSettings().getBoolean(TAG_PLAIN_TEXT_PASSWORD, true);
        EntityPropertyMain entityProperty = this.getParent().getEntityProperty();
        PropertyFieldRegistry<StaMainTable> pfReg = table.getPropertyFieldRegistry();
        int idx = this.fieldIdx;
        PropertyFieldRegistry.ExpressionFactory<StaMainTable> factory = t2 -> t2.field(idx);
        pfReg.addEntry((Property)entityProperty, factory, new PropertyFieldRegistry.ConverterPassword<StaMainTable>(plainTextPw, entityProperty, factory));
    }

    public String getField() {
        return this.field;
    }

    public FieldMapperPassword setField(String field) {
        this.field = field;
        return this;
    }

    @Override
    public Map<String, String> getFieldTypes() {
        HashMap<String, String> value = new HashMap<String, String>();
        value.put(this.field, "VARCHAR(255)");
        return value;
    }
}

