/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.fieldmapper;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.DefNavigationProperty;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.JooqPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.relations.RelationManyToMany;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaLinkTableDynamic;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.PropertyFieldRegistry;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.fieldmapper.FieldMapperAbstractNp;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import java.util.Collections;
import java.util.Map;
import org.jooq.Name;
import org.jooq.Table;
import org.jooq.TableField;

public class FieldMapperManyToMany
extends FieldMapperAbstractNp {
    @ConfigurableField(editor=EditorString.class, label="Field", description="The database field to use in 'my' table.")
    @EditorString.EdOptsString
    private String field;
    @ConfigurableField(editor=EditorString.class, label="LinkTable", description="Name of the link table.")
    @EditorString.EdOptsString
    private String linkTable;
    @ConfigurableField(editor=EditorString.class, label="OurLinkField", description="Name of 'my' field in the link table.")
    @EditorString.EdOptsString
    private String linkOurField;
    @ConfigurableField(editor=EditorString.class, label="OtherLinkField", description="Name of the other table's field in the link table.")
    @EditorString.EdOptsString
    private String linkOtherField;
    @ConfigurableField(editor=EditorString.class, label="OtherTable", description="The name of the other table we link to.")
    @EditorString.EdOptsString
    private String otherTable;
    @ConfigurableField(editor=EditorString.class, label="OtherField", description="The field in the other table that is the key in the relation.")
    @EditorString.EdOptsString
    private String otherField;
    @JsonIgnore
    private int fieldIdx;

    @Override
    public void registerField(JooqPersistenceManager ppm, StaMainTable staTable) {
        Name tableName = staTable.getQualifiedName();
        Table<?> dbTable = ppm.getDbTable(tableName);
        this.fieldIdx = FieldMapperManyToMany.getOrRegisterField(this.field, dbTable, staTable);
    }

    @Override
    public <T extends StaMainTable<T>> void registerMapping(JooqPersistenceManager ppm, T staTable) {
        StaMainTable staTableOther = (StaMainTable)ppm.getTableCollection().getTableForName(this.otherTable);
        Table<?> dbTableOther = ppm.getDbTable(this.otherTable);
        int fieldIdxOther = FieldMapperManyToMany.getOrRegisterField(this.otherField, dbTableOther, staTableOther);
        StaLinkTableDynamic staTableLink = ppm.getOrCreateLinkTable(this.linkTable);
        Table<?> dbTableLink = ppm.getDbTable(this.linkTable);
        int fieldIdxLinkOur = FieldMapperManyToMany.getOrRegisterField(this.linkOurField, dbTableLink, staTableLink);
        int fieldIdxLinkOther = FieldMapperManyToMany.getOrRegisterField(this.linkOtherField, dbTableLink, staTableLink);
        DefNavigationProperty parent = this.getParent();
        boolean symmetrical = parent.isSymmetrical();
        NavigationPropertyMain navProp = parent.getNavigationProperty();
        PropertyFieldRegistry<StaMainTable> pfReg = staTable.getPropertyFieldRegistry();
        pfReg.addEntry(navProp, t2 -> t2.field(this.fieldIdx));
        staTable.registerRelation(new RelationManyToMany<T, StaLinkTableDynamic, StaMainTable>(navProp, staTable, staTableLink, staTableOther, symmetrical).setSourceFieldAcc(t2 -> (TableField)t2.field(this.fieldIdx)).setSourceLinkFieldAcc(t2 -> (TableField)t2.field(fieldIdxLinkOur)).setTargetLinkFieldAcc(t2 -> (TableField)t2.field(fieldIdxLinkOther)).setTargetFieldAcc(t2 -> (TableField)t2.field(fieldIdxOther)));
        DefNavigationProperty.Inverse inverse = this.getParent().getInverse();
        if (inverse != null) {
            NavigationPropertyMain navPropInverse = this.getParent().getNavigationPropertyInverse();
            PropertyFieldRegistry<StaMainTable> pfRegOther = staTableOther.getPropertyFieldRegistry();
            pfRegOther.addEntry(navPropInverse, t2 -> t2.field(fieldIdxOther));
            staTableOther.registerRelation(new RelationManyToMany<StaMainTable, StaLinkTableDynamic, T>(navPropInverse, staTableOther, staTableLink, staTable, symmetrical).setSourceFieldAcc(t2 -> (TableField)t2.field(fieldIdxOther)).setSourceLinkFieldAcc(t2 -> (TableField)t2.field(fieldIdxLinkOther)).setTargetLinkFieldAcc(t2 -> (TableField)t2.field(fieldIdxLinkOur)).setTargetFieldAcc(t2 -> (TableField)t2.field(this.fieldIdx)));
        }
    }

    public String getField() {
        return this.field;
    }

    public FieldMapperManyToMany setField(String field) {
        this.field = field;
        return this;
    }

    public String getLinkTable() {
        return this.linkTable;
    }

    public FieldMapperManyToMany setLinkTable(String linkTable) {
        this.linkTable = linkTable;
        return this;
    }

    public String getLinkOurField() {
        return this.linkOurField;
    }

    public FieldMapperManyToMany setLinkOurField(String linkOurField) {
        this.linkOurField = linkOurField;
        return this;
    }

    public String getLinkOtherField() {
        return this.linkOtherField;
    }

    public FieldMapperManyToMany setLinkOtherField(String linkOtherField) {
        this.linkOtherField = linkOtherField;
        return this;
    }

    public String getOtherTable() {
        return this.otherTable;
    }

    public FieldMapperManyToMany setOtherTable(String otherTable) {
        this.otherTable = otherTable;
        return this;
    }

    public String getOtherField() {
        return this.otherField;
    }

    public FieldMapperManyToMany setOtherField(String otherField) {
        this.otherField = otherField;
        return this;
    }

    @Override
    public Map<String, String> getFieldTypes() {
        return Collections.emptyMap();
    }
}

