/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.fieldmapper;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.JooqPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaTableDynamic;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.PropertyFieldRegistry;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.fieldmapper.FieldMapperAbstractEp;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import java.util.HashMap;
import java.util.Map;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldMapperId
extends FieldMapperAbstractEp {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldMapperId.class.getName());
    @ConfigurableField(editor=EditorString.class, label="Field", description="The database field to use.")
    @EditorString.EdOptsString
    private String field;
    @JsonIgnore
    private int fieldIdx;

    @Override
    public void registerField(JooqPersistenceManager ppm, StaMainTable staTable) {
        if (!(staTable instanceof StaTableDynamic)) {
            throw new IllegalArgumentException("Id fields can only be registered on StaTableDynamic, not on " + staTable.getClass().getName());
        }
        StaTableDynamic staTableDynamic = (StaTableDynamic)staTable;
        Name tableName = staTableDynamic.getQualifiedName();
        Table<?> dbTable = ppm.getDbTable(tableName);
        Field<?> dbField = dbTable.field(this.field);
        if (dbField == null) {
            LOGGER.error("Could not find field {} on table {}.", (Object)this.field, (Object)tableName);
            return;
        }
        DataType dataType = dbField.getDataType();
        LOGGER.info("  Registering {} -> {}.{}", staTableDynamic.getName(), dbTable.getName(), this.field);
        staTableDynamic.registerField(this.field, dataType);
    }

    @Override
    public <T extends StaMainTable<T>> void registerMapping(JooqPersistenceManager ppm, T table) {
        EntityPropertyMain entityProperty = this.getParent().getEntityProperty();
        PropertyFieldRegistry<StaMainTable> pfReg = table.getPropertyFieldRegistry();
        int idx = this.fieldIdx;
        pfReg.addEntrySimple(entityProperty, t2 -> t2.field(idx));
    }

    public String getField() {
        return this.field;
    }

    public FieldMapperId setField(String field) {
        this.field = field;
        return this;
    }

    @Override
    public Map<String, String> getFieldTypes() {
        HashMap<String, String> value = new HashMap<String, String>();
        value.put(this.field, "ID");
        return value;
    }
}

