/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.fieldmapper;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.JooqPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.bindings.PostGisGeometryBinding;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories.EntityFactories;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.PropertyFieldRegistry;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.Utils;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.fieldmapper.FieldMapperAbstractEp;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jooq.Name;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public class FieldMapperGeometry
extends FieldMapperAbstractEp {
    @ConfigurableField(editor=EditorString.class, label="SourceField", description="The database field to for source data.")
    @EditorString.EdOptsString
    private String fieldSource;
    @ConfigurableField(editor=EditorString.class, label="GeoField", description="The database field to use for parsed geometry.")
    @EditorString.EdOptsString
    private String fieldGeom;
    @JsonIgnore
    private int fieldSourceIdx = -1;
    @JsonIgnore
    private int fieldGeomIdx;

    @Override
    public void registerField(JooqPersistenceManager ppm, StaMainTable staTable) {
        Name tableName = staTable.getQualifiedName();
        Table<?> dbTable = ppm.getDbTable(tableName);
        this.fieldGeomIdx = FieldMapperGeometry.getOrRegisterField(this.fieldGeom, dbTable, staTable, PostGisGeometryBinding.instance());
        if (!StringHelper.isNullOrEmpty(this.fieldSource)) {
            this.fieldSourceIdx = FieldMapperGeometry.getOrRegisterField(this.fieldSource, dbTable, staTable);
        }
    }

    @Override
    public <T extends StaMainTable<T>> void registerMapping(JooqPersistenceManager ppm, T table) {
        EntityPropertyMain property = this.getParent().getEntityProperty();
        PropertyFieldRegistry<StaMainTable> pfReg = table.getPropertyFieldRegistry();
        int idxLocation = this.fieldSourceIdx;
        int idxGeom = this.fieldGeomIdx;
        PropertyFieldRegistry.NFP<StaMainTable> sourcePfr = idxLocation >= 0 ? new PropertyFieldRegistry.NFP<StaMainTable>("j", t2 -> t2.field(idxLocation)) : new PropertyFieldRegistry.NFP<StaMainTable>("j", t2 -> DSL.field("ST_AsGeoJSON(?)", String.class, t2.field(idxGeom, SQLDataType.CLOB)).as(this.fieldGeom));
        pfReg.addEntry((Property)property, true, new PropertyFieldRegistry.ConverterRecordDeflt<StaMainTable>((t2, tuple, entity, dataSize) -> {
            String locationString = idxLocation >= 0 ? tuple.get(t2.field(idxLocation, SQLDataType.CLOB)) : (String)tuple.get(DSL.field("ST_AsGeoJSON(?)", String.class, t2.field(idxGeom, SQLDataType.CLOB)).as(this.fieldGeom));
            dataSize.increase(locationString == null ? 0L : (long)locationString.length());
            entity.setProperty(property, Utils.jsonToTreeOrString(locationString));
        }, (t2, entity, insertFields) -> {
            Object feature = entity.getProperty(property);
            EntityFactories.insertGeometry(insertFields, t2.field(idxLocation, SQLDataType.CLOB), t2.field(idxGeom), null, feature);
        }, (t2, entity, updateFields, message) -> {
            Object feature = entity.getProperty(property);
            EntityFactories.insertGeometry(updateFields, t2.field(idxLocation, SQLDataType.CLOB), t2.field(idxGeom), null, feature);
            message.addField(property);
        }), sourcePfr);
        pfReg.addEntryNoSelect(property, "g", t2 -> t2.field(idxGeom));
    }

    public String getFieldSource() {
        return this.fieldSource;
    }

    public FieldMapperGeometry setFieldSource(String fieldSource) {
        this.fieldSource = fieldSource;
        return this;
    }

    public String getFieldGeom() {
        return this.fieldGeom;
    }

    public FieldMapperGeometry setFieldGeom(String fieldGeom) {
        this.fieldGeom = fieldGeom;
        return this;
    }

    @Override
    public Map<String, String> getFieldTypes() {
        LinkedHashMap<String, String> value = new LinkedHashMap<String, String>();
        if (!StringHelper.isNullOrEmpty(this.fieldSource)) {
            value.put(this.fieldSource, "TEXT");
        }
        if (!StringHelper.isNullOrEmpty(this.fieldGeom)) {
            value.put(this.fieldGeom, "geometry(Geometry,4326)");
        }
        return value;
    }
}

