/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils;

import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.EntitySetJooqCurser;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.JooqPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.ResultBuilder;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.DataSize;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.PropertyFieldRegistry;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.TableRef;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.Utils;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.query.Expand;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jooq.Condition;
import org.jooq.Cursor;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;

public class QueryState<T extends StaMainTable<T>> {
    public static final String ALIAS_ROOT = "_ROOT";
    private final JooqPersistenceManager persistenceManager;
    private Set<PropertyFieldRegistry.PropertyFields<T>> selectedProperties;
    private Set<Field> sqlSelectFields;
    private final T mainTable;
    private final List<Field> sqlMainPkFields;
    private Table sqlFrom;
    private Condition sqlWhere = DSL.noCondition();
    private Condition sqlSkipWhere;
    private Utils.SortSelectFields sqlSortFields;
    private boolean distinctRequired = false;
    private boolean isFilter = false;
    private int aliasNr = 0;
    private QueryState parent;
    private Map<NavigationPropertyMain.NavigationPropertyEntity, QueryState> childStates = new HashMap<NavigationPropertyMain.NavigationPropertyEntity, QueryState>();
    private String staAlias;
    private final TableRef tableRef;

    public QueryState(T table, QueryState parent, String staAlias) {
        this(parent.getPersistenceManager(), table, null);
        this.parent = parent;
        this.staAlias = staAlias;
    }

    public QueryState(JooqPersistenceManager pm, T table, Set<PropertyFieldRegistry.PropertyFields<T>> sqlSelectFields) {
        this.persistenceManager = pm;
        this.selectedProperties = sqlSelectFields;
        this.sqlFrom = table;
        this.mainTable = table;
        this.sqlMainPkFields = table.getPkFields();
        this.tableRef = new TableRef((StaMainTable<?>)table);
        this.staAlias = ALIAS_ROOT;
    }

    public JooqPersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    public T getMainTable() {
        return this.mainTable;
    }

    public TableRef getTableRef() {
        return this.tableRef;
    }

    public Entity entityFromRecord(Record tuple, DataSize dataSize, Query staQuery) {
        Entity mainEntity = this.mainTable.entityFromQuery(tuple, this, dataSize).setQuery(staQuery);
        if (staQuery != null) {
            for (Expand expand : staQuery.getExpand()) {
                NavigationProperty expandPath = expand.getPath();
                if (!(expandPath instanceof NavigationPropertyMain.NavigationPropertyEntity)) continue;
                NavigationPropertyMain.NavigationPropertyEntity navPropEntity = (NavigationPropertyMain.NavigationPropertyEntity)expandPath;
                QueryState childState = this.getChildState(navPropEntity);
                Entity subEntity = childState.entityFromRecord(tuple, dataSize, expand.getSubQuery());
                mainEntity.setProperty(navPropEntity, subEntity);
            }
        }
        return mainEntity;
    }

    public EntitySet createSetFromRecords(Cursor<Record> tuples, ResultBuilder resultBuilder) {
        return new EntitySetJooqCurser(this.mainTable.getEntityType(), tuples, this, resultBuilder);
    }

    public QueryState findStateForAlias(String alias) {
        if (this.staAlias.equalsIgnoreCase(alias)) {
            return this;
        }
        if (this.parent == null) {
            return this;
        }
        return this.parent.findStateForAlias(alias);
    }

    public String getNextAlias() {
        if (this.parent == null) {
            return "e" + ++this.aliasNr;
        }
        return this.parent.getNextAlias();
    }

    public void addChildState(NavigationPropertyMain.NavigationPropertyEntity property, QueryState state) {
        this.childStates.put(property, state);
    }

    public QueryState getChildState(NavigationPropertyMain.NavigationPropertyEntity property) {
        return this.childStates.get(property);
    }

    public boolean isSqlSortFieldsSet() {
        if (this.sqlSortFields == null) {
            return false;
        }
        return !this.sqlSortFields.getSqlSortFields().isEmpty();
    }

    public Utils.SortSelectFields getSqlSortFields() {
        if (this.sqlSortFields == null) {
            this.sqlSortFields = new Utils.SortSelectFields();
        }
        return this.sqlSortFields;
    }

    public Set<Field> getSqlSelectFields() {
        if (this.sqlSelectFields == null) {
            this.sqlSelectFields = QueryState.propertiesToFields(this.mainTable, this.selectedProperties);
            for (QueryState childState : this.childStates.values()) {
                this.sqlSelectFields.addAll(childState.getSqlSelectFields());
            }
        }
        return this.sqlSelectFields;
    }

    public Set<PropertyFieldRegistry.PropertyFields<T>> getSelectedProperties() {
        return this.selectedProperties;
    }

    public void setSelectedProperties(Set<PropertyFieldRegistry.PropertyFields<T>> sqlSelectFields) {
        this.selectedProperties = sqlSelectFields;
        this.sqlSelectFields = null;
    }

    public List<Field> getSqlMainIdFields() {
        return this.sqlMainPkFields;
    }

    public Table<Record> getSqlFrom() {
        return this.sqlFrom;
    }

    public void setSqlFrom(Table sqlFrom) {
        this.sqlFrom = sqlFrom;
    }

    public Condition getFullSqlWhere() {
        if (this.sqlSkipWhere == null) {
            return this.sqlWhere;
        }
        return this.sqlWhere.and(this.sqlSkipWhere);
    }

    public Condition getSqlWhere() {
        return this.sqlWhere;
    }

    public void setSqlWhere(Condition sqlWhere) {
        this.sqlWhere = sqlWhere;
    }

    public Condition getSqlSkipWhere() {
        return this.sqlSkipWhere == null ? DSL.noCondition() : this.sqlSkipWhere;
    }

    public void setSqlSkipWhere(Condition sqlSkipWhere) {
        this.sqlSkipWhere = sqlSkipWhere;
    }

    public void setSqlSortFields(Utils.SortSelectFields sqlSortFields) {
        this.sqlSortFields = sqlSortFields;
    }

    public boolean isDistinctRequired() {
        return this.distinctRequired;
    }

    public void setDistinctRequired(boolean distinctRequired) {
        this.distinctRequired = distinctRequired;
    }

    public boolean isFilter() {
        return this.isFilter;
    }

    public void setFilter(boolean isFilter) {
        this.isFilter = isFilter;
    }

    public static <U extends StaMainTable<U>> Set<Field> propertiesToFields(StaMainTable<U> table, Set<PropertyFieldRegistry.PropertyFields<U>> properties) {
        HashSet<Field> fields2 = new HashSet<Field>();
        for (PropertyFieldRegistry.PropertyFields<U> sp : properties) {
            for (PropertyFieldRegistry.ExpressionFactory<StaMainTable<U>> expressionFactory : sp.fields.values()) {
                fields2.add(expressionFactory.get(table));
            }
        }
        return fields2;
    }
}

