/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils;

import de.fraunhofer.iosb.ilt.frostserver.util.exception.UpgradeFailedException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.changelog.ChangeSetStatus;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.resource.SearchPathResourceAccessor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiquibaseHelper {
    public static final String CHANGE_SET_NAME = "changeSetName";
    private static final Logger LOGGER = LoggerFactory.getLogger(LiquibaseHelper.class.getName());

    private LiquibaseHelper() {
    }

    public static String checkForUpgrades(Connection connection, String liquibaseChangelogFilename, Map<String, Object> params) {
        StringWriter out = new StringWriter();
        try {
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(new JdbcConnection(connection));
            LiquibaseHelper.runLiquibaseCheck(liquibaseChangelogFilename, params, database, out);
        }
        catch (DatabaseException ex) {
            LiquibaseHelper.outputError((Exception)ex, out, "Failed to initialise database");
        }
        return out.toString();
    }

    public static boolean doUpgrades(Connection connection, String liquibaseChangelogFilename, Map<String, Object> params, Writer out) throws UpgradeFailedException, IOException {
        try {
            LiquibaseHelper.runLiquibaseUpdate(liquibaseChangelogFilename, params, connection, out);
        }
        catch (DatabaseException ex) {
            LiquibaseHelper.outputError((Exception)ex, out, "Failed to initialise database");
            return false;
        }
        return true;
    }

    private static void runLiquibaseCheck(String liquibaseChangelogFilename, Map<String, Object> params, Database database, StringWriter out) {
        String searchPath = Objects.toString(params.get("searchPath"), null);
        try (SearchPathResourceAccessor resourceAccessor = new SearchPathResourceAccessor(searchPath, new ResourceAccessor[0]);){
            resourceAccessor.addResourceAccessor(new ClassLoaderResourceAccessor());
            LiquibaseHelper.runLiquibaseCheck(liquibaseChangelogFilename, resourceAccessor, database, params, out);
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to close SearchPathResourceAccessor.", ex);
        }
    }

    private static void runLiquibaseCheck(String liquibaseChangelogFilename, SearchPathResourceAccessor resourceAccessor, Database database, Map<String, Object> params, StringWriter out) {
        String changeSetName = Objects.toString(params.get(CHANGE_SET_NAME), "Unnamed Changeset");
        try (Liquibase liquibase = new Liquibase(liquibaseChangelogFilename, (ResourceAccessor)resourceAccessor, database);){
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                liquibase.setChangeLogParameter(entry.getKey(), entry.getValue());
            }
            List<ChangeSetStatus> changeSetStatuses = liquibase.getChangeSetStatuses(new Contexts(), new LabelExpression(liquibaseChangelogFilename));
            int toRunCount = 0;
            for (ChangeSetStatus status : changeSetStatuses) {
                if (!status.getWillRun()) continue;
                ++toRunCount;
                String[] actions = StringUtils.stripAll(StringUtils.split(status.getDescription(), ';'));
                out.append(status.getChangeSet().getId()).append('\n');
                for (String action : actions) {
                    out.append('\t').append(action).append('\n');
                }
                out.append('\n');
            }
            if (toRunCount == 0) {
                out.append("Up to date, no changes to apply: " + changeSetName + ".\n");
            }
        }
        catch (LiquibaseException ex) {
            LiquibaseHelper.outputError((Exception)ex, out, "Failed to upgrade database: " + changeSetName + ".");
        }
        catch (Exception ex) {
            LOGGER.warn("Exception happened when closing liquibase.", ex);
        }
    }

    private static void runLiquibaseUpdate(String liquibaseChangelogFilename, Map<String, Object> params, Connection connection, Writer out) throws UpgradeFailedException, IOException, DatabaseException {
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(new JdbcConnection(connection));
        String liquibaseSearchPath = Objects.toString(params.get("searchPath"), null);
        try (SearchPathResourceAccessor resourceAccessor = new SearchPathResourceAccessor(liquibaseSearchPath, new ResourceAccessor[0]);){
            resourceAccessor.addResourceAccessor(new ClassLoaderResourceAccessor());
            LiquibaseHelper.runLiquibaseUpdate(liquibaseChangelogFilename, resourceAccessor, database, params, out);
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to close SearchPathResourceAccessor.", ex);
        }
    }

    private static void runLiquibaseUpdate(String liquibaseChangelogFilename, SearchPathResourceAccessor resourceAccessor, Database database, Map<String, Object> params, Writer out) throws UpgradeFailedException, IOException {
        String changeSetName = Objects.toString(params.get(CHANGE_SET_NAME), "Unnamed Changeset");
        try (Liquibase liquibase = new Liquibase(liquibaseChangelogFilename, (ResourceAccessor)resourceAccessor, database);){
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                liquibase.setChangeLogParameter(entry.getKey(), entry.getValue());
            }
            liquibase.update(new Contexts(), new LabelExpression(liquibaseChangelogFilename));
            out.append("Update Completed: " + changeSetName + ".");
        }
        catch (LiquibaseException ex) {
            LiquibaseHelper.outputError((Exception)ex, out, "Failed to upgrade database: " + changeSetName + ".");
            throw new UpgradeFailedException(ex);
        }
        catch (Exception ex) {
            LOGGER.warn("Exception happened when closing liquibase.", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getSearchPath(Connection connection) {
        try (PreparedStatement call = connection.prepareStatement("show search_path");){
            call.execute();
            try (ResultSet resultSet = call.getResultSet();){
                if (!resultSet.next()) return "";
                String searchPath = resultSet.getString(1);
                LOGGER.debug("Found search_path: {}", (Object)searchPath);
                String string = searchPath;
                return string;
            }
        }
        catch (SQLException ex) {
            LOGGER.error("Failed to fetch search_path: ", ex);
        }
        return "";
    }

    public static void setSearchPath(Connection connection, String wantedSearchPath) {
        String searchPath = LiquibaseHelper.getSearchPath(connection);
        if (wantedSearchPath.equals(searchPath)) {
            return;
        }
        LOGGER.info("Liquibase changed the search_path from '{}' to '{}'. Changing it back.", (Object)wantedSearchPath, (Object)searchPath);
        try (PreparedStatement call = connection.prepareStatement("select set_config('search_path', ?, false)");){
            call.setString(1, wantedSearchPath);
            call.execute();
            connection.commit();
        }
        catch (SQLException ex) {
            LOGGER.error("Failed to set search_path: ", ex);
        }
    }

    private static void outputError(Exception exception, StringWriter out, String message) {
        try {
            LiquibaseHelper.outputError(exception, (Writer)out, message);
        }
        catch (IOException exc) {
            LOGGER.error("Error writing output.", exc);
        }
    }

    private static void outputError(Exception exception, Writer out, String message) throws IOException {
        LOGGER.error(message, (Object)exception.getMessage());
        out.append(message + ":\n");
        out.append(exception.getLocalizedMessage());
        out.append("\n");
    }
}

