/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.DefModel;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.JooqPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories.EntityFactories;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaLinkTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaTableAbstract;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator.CheckUserHasRoles;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator.HookValidator;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator.SecurityTableWrapper;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator.ValidatorCUD;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableCollection {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableCollection.class);
    private ModelRegistry modelRegistry;
    private boolean initialised = false;
    private List<DefModel> modelDefinitions;
    private Map<String, SecurityTableWrapper> securityWrappers;
    private Map<String, List<HookValidator>> securityValidators;
    private final Map<EntityType, StaMainTable<?>> tablesByType = new LinkedHashMap();
    private final Map<Class<?>, StaTable<?>> tablesByClass = new LinkedHashMap();
    private final Map<String, StaTable<?>> tablesByName = new LinkedHashMap();

    public TableCollection setModelRegistry(ModelRegistry modelRegistry) {
        this.modelRegistry = modelRegistry;
        return this;
    }

    public StaMainTable<?> getTableForType(EntityType type) {
        return this.tablesByType.get(type);
    }

    public <T extends StaTable<T>> T getTableForClass(Class<T> clazz) {
        return (T)this.tablesByClass.get(clazz);
    }

    public StaTable<?> getTableForName(String name) {
        return this.tablesByName.get(name);
    }

    public Collection<StaMainTable<?>> getAllTables() {
        return this.tablesByType.values();
    }

    public void registerTable(EntityType type, StaTableAbstract<?> table) {
        this.tablesByType.put(type, table);
        this.tablesByClass.put(table.getClass(), table);
        this.tablesByName.put(table.getName(), table);
        table.init(this.modelRegistry, this);
    }

    public void registerTable(StaLinkTable<?> table) {
        this.tablesByClass.put(table.getClass(), table);
        this.tablesByName.put(table.getName(), table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(JooqPersistenceManager ppm) {
        if (this.initialised) {
            return false;
        }
        TableCollection tableCollection = this;
        synchronized (tableCollection) {
            if (!this.initialised) {
                this.initialised = true;
                EntityFactories entityFactories = ppm.getEntityFactories();
                for (StaMainTable<?> table : this.getAllTables()) {
                    LOGGER.info("  Table: {}.", (Object)table.getName());
                    table.initProperties(entityFactories);
                    table.initRelations();
                    this.initSecurityWrapper(table);
                    this.initSecurityValidators(table, ppm);
                }
                return true;
            }
            return false;
        }
    }

    public Map<EntityType, StaMainTable<?>> getTablesByType() {
        return this.tablesByType;
    }

    public List<DefModel> getModelDefinitions() {
        if (this.modelDefinitions == null) {
            this.modelDefinitions = new ArrayList<DefModel>();
        }
        return this.modelDefinitions;
    }

    public void clearModelDefinitions() {
        this.modelDefinitions = Collections.emptyList();
    }

    public void initSecurityWrapper(StaMainTable table) {
        if (this.securityWrappers == null) {
            return;
        }
        SecurityTableWrapper stw = this.securityWrappers.get(table.getName());
        if (stw == null) {
            return;
        }
        table.setSecurityWrapper(stw);
    }

    public void addSecurityWrapper(String tableName, SecurityTableWrapper w) {
        if (this.securityWrappers == null) {
            this.securityWrappers = new HashMap<String, SecurityTableWrapper>();
        }
        this.securityWrappers.put(tableName, w);
    }

    public void initSecurityValidators(StaMainTable table, JooqPersistenceManager ppm) {
        if (this.securityValidators == null) {
            return;
        }
        List<HookValidator> hvList = this.securityValidators.get(table.getName());
        if (hvList == null) {
            LOGGER.info("    Adding default security hooks for {}", (Object)table.getName());
            ValidatorCUD hv = new ValidatorCUD().setCheckInsertPreRel(new CheckUserHasRoles().setCheckType(CheckUserHasRoles.Type.ANY).setRoles("admin", "create")).setCheckUpdate(new CheckUserHasRoles().setCheckType(CheckUserHasRoles.Type.ANY).setRoles("admin", "update")).setCheckDelete(new CheckUserHasRoles().setCheckType(CheckUserHasRoles.Type.ANY).setRoles("admin", "delete"));
            hv.registerHooks(table, ppm);
            return;
        }
        for (HookValidator hv : hvList) {
            hv.registerHooks(table, ppm);
        }
    }

    public void addSecurityValidator(String tableName, HookValidator hv) {
        if (this.securityValidators == null) {
            this.securityValidators = new HashMap<String, List<HookValidator>>();
        }
        this.securityValidators.computeIfAbsent(tableName, tn -> new ArrayList()).add(hv);
    }
}

