/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.PrimaryKey;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.JooqPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories.EntityFactories;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaTableAbstract;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator.SecurityTableWrapper;
import de.fraunhofer.iosb.ilt.frostserver.util.user.PrincipalExtended;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Binding;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Table;
import org.jooq.impl.DSL;

public final class StaTableDynamic
extends StaTableAbstract<StaTableDynamic> {
    private final Name tableName;
    private final transient EntityType entityType;
    private int[] pkFieldIdx;
    private List<Field> pkFields;

    public StaTableDynamic(Name tableName, EntityType entityType, DataType<?> idType) {
        super(idType, tableName, null, null);
        this.tableName = tableName;
        this.entityType = entityType;
        this.pkFieldIdx = new int[entityType.getPrimaryKey().size()];
    }

    private StaTableDynamic(Name alias, StaTableDynamic aliased, int[] idFieldIdx) {
        this(alias, aliased, (Table)aliased, idFieldIdx);
    }

    private StaTableDynamic(Name alias, StaTableDynamic aliased, Table updatedSql, int[] idFieldIdx) {
        super(aliased.getIdType(), alias, aliased, updatedSql);
        this.tableName = aliased.getTableName();
        this.pkFieldIdx = idFieldIdx;
        this.entityType = aliased.getEntityType();
    }

    public Name getTableName() {
        return this.tableName;
    }

    @Override
    public final int registerField(Name name, DataType type, Binding binding) {
        int fieldId = super.registerField(name, type, binding);
        PrimaryKey primaryKey = this.entityType.getPrimaryKey();
        for (int idx = 0; idx < primaryKey.size(); ++idx) {
            if (!primaryKey.getKeyProperty(idx).getName().equals(name.toString())) continue;
            this.pkFieldIdx[idx] = fieldId;
        }
        return fieldId;
    }

    @Override
    public StaTableDynamic as(Name as) {
        return (StaTableDynamic)new StaTableDynamic(as, this, this.pkFieldIdx).initCustomFields();
    }

    public StaTableDynamic asSecure(String name, JooqPersistenceManager pm) {
        SecurityTableWrapper securityWrapper = this.getSecurityWrapper();
        if (securityWrapper == null || PrincipalExtended.getLocalPrincipal().isAdmin()) {
            return (StaTableDynamic)this.as(name);
        }
        Table wrappedTable = securityWrapper.wrap(this, pm);
        return (StaTableDynamic)new StaTableDynamic(DSL.name(name), this, wrappedTable, this.pkFieldIdx).initCustomFields();
    }

    @Override
    public List<Field> getPkFields() {
        if (this.pkFields == null) {
            this.pkFields = new ArrayList<Field>();
            for (int fieldId : this.pkFieldIdx) {
                this.pkFields.add(this.field(fieldId));
            }
        }
        return this.pkFields;
    }

    @Override
    public void initRelations() {
    }

    @Override
    public void initProperties(EntityFactories entityFactories) {
    }

    @Override
    public EntityType getEntityType() {
        return this.entityType;
    }

    @Override
    public StaTableDynamic getThis() {
        return this;
    }
}

