/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables;

import de.fraunhofer.iosb.ilt.frostserver.model.DefaultEntity;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityChangedMessage;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySetImpl;
import de.fraunhofer.iosb.ilt.frostserver.model.core.PkValue;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntity;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.JooqPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.bindings.JsonBinding;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.bindings.JsonValue;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories.EntityFactories;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories.HookPostDelete;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories.HookPostInsert;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories.HookPostUpdate;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories.HookPreDelete;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories.HookPreInsert;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories.HookPreUpdate;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper.JsonFieldFactory;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.relations.Relation;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.CustomField;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.TableCollection;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.DataSize;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.PropertyFieldRegistry;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.QueryState;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.SortingWrapper;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.TableRef;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator.SecurityTableWrapper;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyCustomSelect;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.service.UpdateMode;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncompleteEntityException;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.NoSuchEntityException;
import de.fraunhofer.iosb.ilt.frostserver.util.user.PrincipalExtended;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jooq.Binding;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.exception.TooManyRowsException;
import org.jooq.impl.DSL;
import org.jooq.impl.TableImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StaTableAbstract<T extends StaMainTable<T>>
extends TableImpl<Record>
implements StaMainTable<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaTableAbstract.class.getName());
    private static final String DO_NOT_KNOW_HOW_TO_JOIN = "Do not know how to join ";
    public static final String TYPE_JSONB = "\"pg_catalog\".\"jsonb\"";
    public static final String TYPE_GEOMETRY = "\"public\".\"geometry\"";
    private transient TableCollection tables;
    private transient ModelRegistry modelRegistry;
    private transient Map<String, Relation<T>> relations;
    private List<CustomField> customFields;
    protected transient PropertyFieldRegistry<T> pfReg;
    private final DataType<?> idType;
    private SecurityTableWrapper securityWrapper;
    private final transient SortedSet<SortingWrapper<Double, HookPreInsert>> hooksPreInsert;
    private final transient SortedSet<SortingWrapper<Double, HookPostInsert>> hooksPostInsert;
    private final transient SortedSet<SortingWrapper<Double, HookPreUpdate>> hooksPreUpdate;
    private final transient SortedSet<SortingWrapper<Double, HookPostUpdate>> hooksPostUpdate;
    private final transient SortedSet<SortingWrapper<Double, HookPreDelete>> hooksPreDelete;
    private final transient SortedSet<SortingWrapper<Double, HookPostDelete>> hooksPostDelete;

    protected StaTableAbstract(DataType<?> idType, Name alias, StaTableAbstract<T> aliasedBase, Table updatedSql) {
        super(alias, null, updatedSql);
        this.idType = idType;
        if (aliasedBase == null) {
            this.pfReg = new PropertyFieldRegistry<StaMainTable>((StaMainTable)this.getThis());
            this.relations = new HashMap<String, Relation<T>>();
            this.hooksPreInsert = new TreeSet<SortingWrapper<Double, HookPreInsert>>();
            this.hooksPostInsert = new TreeSet<SortingWrapper<Double, HookPostInsert>>();
            this.hooksPreUpdate = new TreeSet<SortingWrapper<Double, HookPreUpdate>>();
            this.hooksPostUpdate = new TreeSet<SortingWrapper<Double, HookPostUpdate>>();
            this.hooksPreDelete = new TreeSet<SortingWrapper<Double, HookPreDelete>>();
            this.hooksPostDelete = new TreeSet<SortingWrapper<Double, HookPostDelete>>();
            this.customFields = new ArrayList<CustomField>();
        } else {
            this.init(aliasedBase.getModelRegistry(), aliasedBase.getTables());
            this.pfReg = new PropertyFieldRegistry<StaMainTable>((StaMainTable)this.getThis(), aliasedBase.getPropertyFieldRegistry());
            this.relations = aliasedBase.relations;
            this.hooksPreInsert = aliasedBase.hooksPreInsert;
            this.hooksPostInsert = aliasedBase.hooksPostInsert;
            this.hooksPreUpdate = aliasedBase.hooksPreUpdate;
            this.hooksPostUpdate = aliasedBase.hooksPostUpdate;
            this.hooksPreDelete = aliasedBase.hooksPreDelete;
            this.hooksPostDelete = aliasedBase.hooksPostDelete;
            this.customFields = aliasedBase.customFields;
        }
    }

    public DataType<?> getIdType() {
        return this.idType;
    }

    @Override
    public int registerField(Name name, DataType type, Binding binding) {
        this.customFields.add(new CustomField(name, type, binding));
        TableField newField = this.createField(name, type, "", binding);
        return this.fieldsRow().indexOf(newField);
    }

    protected T initCustomFields() {
        for (CustomField customField : this.customFields) {
            this.createField(customField.name, customField.type, "", customField.binding);
        }
        return (T)((StaMainTable)this.getThis());
    }

    @Override
    public void registerRelation(Relation<T> relation) {
        this.relations.put(relation.getName(), relation);
    }

    @Override
    public void registerHookPreInsert(double priority, HookPreInsert hook) {
        this.hooksPreInsert.add(new SortingWrapper<Double, HookPreInsert>(priority, hook));
    }

    @Override
    public void registerHookPostInsert(double priority, HookPostInsert hook) {
        this.hooksPostInsert.add(new SortingWrapper<Double, HookPostInsert>(priority, hook));
    }

    @Override
    public void registerHookPreUpdate(double priority, HookPreUpdate hook) {
        this.hooksPreUpdate.add(new SortingWrapper<Double, HookPreUpdate>(priority, hook));
    }

    @Override
    public void registerHookPostUpdate(double priority, HookPostUpdate hook) {
        this.hooksPostUpdate.add(new SortingWrapper<Double, HookPostUpdate>(priority, hook));
    }

    @Override
    public void registerHookPreDelete(double priority, HookPreDelete hook) {
        this.hooksPreDelete.add(new SortingWrapper<Double, HookPreDelete>(priority, hook));
    }

    @Override
    public void registerHookPostDelete(double priority, HookPostDelete hook) {
        this.hooksPostDelete.add(new SortingWrapper<Double, HookPostDelete>(priority, hook));
    }

    @Override
    public SecurityTableWrapper getSecurityWrapper() {
        return this.securityWrapper;
    }

    @Override
    public void setSecurityWrapper(SecurityTableWrapper securityWrapper) {
        if (securityWrapper == null) {
            return;
        }
        if (this.securityWrapper != null) {
            LOGGER.error("Overwriting security wrapper for table {}, old type: {}", (Object)this.getName(), (Object)this.securityWrapper.getClass().getName());
        }
        LOGGER.info("Applying security wrapper to table {} of type {}", (Object)this.getName(), (Object)securityWrapper.getClass().getName());
        this.securityWrapper = securityWrapper;
    }

    @Override
    public Relation<T> findRelation(String name) {
        Relation<T> relation = this.relations.get(name);
        if (relation == null) {
            throw new IllegalStateException(DO_NOT_KNOW_HOW_TO_JOIN + name + " on " + this.getName() + " " + this.getEntityType() + " " + this.getClass().getName());
        }
        return relation;
    }

    @Override
    public TableRef createJoin(String name, QueryState<?> queryState, TableRef sourceRef) {
        return this.findRelation(name).join((StaMainTable)this.getThis(), queryState, sourceRef);
    }

    @Override
    public <U extends StaMainTable<U>> void createSemiJoin(String name, U targetTable, QueryState queryState) {
        this.findRelation(name).semiJoinTo((StaMainTable)this.getThis(), targetTable, queryState);
    }

    @Override
    public PropertyFieldRegistry<T> getPropertyFieldRegistry() {
        if (this.pfReg == null) {
            this.pfReg = new PropertyFieldRegistry<StaMainTable>((StaMainTable)this.getThis());
        }
        return this.pfReg;
    }

    @Override
    public Entity entityFromQuery(Record tuple, QueryState<T> state, DataSize dataSize) {
        DefaultEntity newEntity = new DefaultEntity(this.getEntityType());
        for (PropertyFieldRegistry.PropertyFields<T> sp : state.getSelectedProperties()) {
            sp.converter.convert(state.getMainTable(), tuple, newEntity, dataSize);
        }
        return newEntity;
    }

    @Override
    public Entity insertIntoDatabase(JooqPersistenceManager pm, Entity entity, UpdateMode updateMode, DataSize dataSize) throws NoSuchEntityException, IncompleteEntityException {
        StaMainTable thisTable = (StaMainTable)this.getThis();
        EntityFactories entityFactories = pm.getEntityFactories();
        EntityType entityType = entity.getEntityType();
        HashMap<Field, Object> insertFields = new HashMap<Field, Object>();
        for (SortingWrapper sortingWrapper : this.hooksPreInsert) {
            if (((HookPreInsert)sortingWrapper.getObject()).preInsertIntoDatabase(HookPreInsert.Phase.PRE_RELATIONS, pm, entity, insertFields)) continue;
            return null;
        }
        for (NavigationPropertyMain navigationPropertyMain : entityType.getNavigationEntities()) {
            if (!entity.isSetProperty(navigationPropertyMain)) continue;
            Entity ne = (Entity)entity.getProperty(navigationPropertyMain);
            entityFactories.entityExistsOrCreate(pm, ne, updateMode);
            PropertyFieldRegistry.PropertyFields<T> registry = this.pfReg.getSelectFieldsForProperty(navigationPropertyMain);
            registry.converter.convert(thisTable, entity, insertFields);
        }
        for (SortingWrapper sortingWrapper : this.hooksPreInsert) {
            if (((HookPreInsert)sortingWrapper.getObject()).preInsertIntoDatabase(HookPreInsert.Phase.POST_RELATIONS, pm, entity, insertFields)) continue;
            return null;
        }
        entityFactories.insertUserDefinedId(pm, insertFields, this.getPkFields(), entity);
        Set<EntityPropertyMain> entityProperties = entityType.getEntityProperties();
        List<EntityPropertyMain> list = entityType.getPrimaryKey().getKeyProperties();
        for (EntityPropertyMain ep : entityProperties) {
            if (list.contains(ep) || !entity.isSetProperty(ep)) continue;
            this.pfReg.getSelectFieldsForProperty((Property)ep).converter.convert(thisTable, entity, insertFields);
        }
        DSLContext dslContext = pm.getDslContext();
        Set propertyFields = this.getPropertyFieldRegistry().getSelectFields(new HashSet());
        Set<Field> selectFields = QueryState.propertiesToFields(thisTable, propertyFields);
        Object result = dslContext.insertInto(thisTable).set(insertFields).returningResult(selectFields).fetchAny();
        LOGGER.debug("Inserted {} with id = {}.", (Object)entityType, result);
        if (result == null) {
            return null;
        }
        HashSet pks = new HashSet();
        thisTable.getPkFields().stream().map(arg_0 -> result.get(arg_0)).forEachOrdered(pks::add);
        entity.setPrimaryKeyValues(new PkValue(pks.toArray()));
        for (NavigationPropertyMain<EntitySet> navigationPropertyMain : entityType.getNavigationSets()) {
            if (!entity.isSetProperty(navigationPropertyMain)) continue;
            LOGGER.debug("  Linking {}", (Object)navigationPropertyMain);
            this.updateNavigationPropertySet(entity, entity.getProperty(navigationPropertyMain), pm, updateMode);
        }
        for (SortingWrapper sortingWrapper : this.hooksPostInsert) {
            if (((HookPostInsert)sortingWrapper.getObject()).postInsertIntoDatabase(pm, entity, insertFields)) continue;
            return null;
        }
        DefaultEntity newEntity = new DefaultEntity(this.getEntityType(), entity.getPrimaryKeyValues());
        for (PropertyFieldRegistry.PropertyFields sp : propertyFields) {
            sp.converter.convert(thisTable, (Record)result, newEntity, dataSize);
        }
        return newEntity;
    }

    protected void updateNavigationPropertySet(Entity entity, EntitySet linkedSet, JooqPersistenceManager pm, UpdateMode updateMode) throws IncompleteEntityException, NoSuchEntityException {
        EntityFactories ef;
        NavigationPropertyMain.NavigationPropertyEntitySet navProp = linkedSet.getNavigationProperty();
        Relation<T> relation = this.findRelation(navProp.getName());
        if (relation == null) {
            LOGGER.error("Unknown relation: {}", (Object)navProp.getName());
            throw new IllegalStateException("Unknown relation: " + navProp.getName());
        }
        if (updateMode.deepUpdate) {
            ef = pm.getEntityFactories();
            boolean admin = PrincipalExtended.getLocalPrincipal().isAdmin();
            for (Entity child : linkedSet) {
                if (!ef.entityExists(pm, child, admin)) continue;
                PathElementEntity childPe = new PathElementEntity(child.getPrimaryKeyValues(), child.getEntityType(), null);
                pm.update(childPe, child, updateMode);
            }
        }
        if (updateMode.createAndLinkNew) {
            ef = pm.getEntityFactories();
            for (Entity child : linkedSet) {
                NavigationProperty backLink = navProp.getInverse();
                if (!((NavigationPropertyMain)backLink).isEntitySet()) {
                    child.setProperty(backLink, entity);
                }
                ef.entityExistsOrCreate(pm, child, updateMode);
            }
        }
        if (updateMode.removeMissing) {
            relation.link(pm, entity, linkedSet, (NavigationPropertyMain)navProp);
        } else {
            for (Entity child : linkedSet) {
                EntityFactories ef2 = pm.getEntityFactories();
                if (!ef2.entityExists(pm, child, false)) {
                    throw new NoSuchEntityException("Can not link " + child.getEntityType() + " with no id.");
                }
                relation.link(pm, entity, child, (NavigationPropertyMain)navProp);
            }
        }
    }

    @Override
    public EntityChangedMessage updateInDatabase(JooqPersistenceManager pm, Entity entity, PkValue entityId, UpdateMode updateMode, DataSize dataSize) throws NoSuchEntityException, IncompleteEntityException {
        StaMainTable thisTable = (StaMainTable)this.getThis();
        EntityFactories entityFactories = pm.getEntityFactories();
        EntityType entityType = entity.getEntityType();
        HashMap<Field, Object> updateFields = new HashMap<Field, Object>();
        EntityChangedMessage message = new EntityChangedMessage();
        for (SortingWrapper sortingWrapper : this.hooksPreUpdate) {
            ((HookPreUpdate)sortingWrapper.getObject()).preUpdateInDatabase(pm, entity, entityId, updateMode);
        }
        for (NavigationPropertyMain navigationPropertyMain : entityType.getNavigationEntities()) {
            if (!entity.isSetProperty(navigationPropertyMain)) continue;
            Entity ne = (Entity)entity.getProperty(navigationPropertyMain);
            if (!entityFactories.entityExists(pm, ne, PrincipalExtended.getLocalPrincipal().isAdmin())) {
                throw new NoSuchEntityException("Linked " + ne.getEntityType() + " not found.");
            }
            PropertyFieldRegistry.PropertyFields<T> registry = this.pfReg.getSelectFieldsForProperty(navigationPropertyMain);
            registry.converter.convert(thisTable, entity, updateFields, message);
        }
        Set<EntityPropertyMain> entityProperties = entityType.getEntityProperties();
        List<EntityPropertyMain> list = entityType.getPrimaryKey().getKeyProperties();
        for (EntityPropertyMain ep : entityProperties) {
            if (list.contains(ep) || !entity.isSetProperty(ep)) continue;
            this.pfReg.getSelectFieldsForProperty((Property)ep).converter.convert(thisTable, entity, updateFields, message);
        }
        List<Field> pkFields = this.getPkFields();
        Condition where = pkFields.get(0).eq(entityId.get(0));
        int size = entityId.size();
        for (int i = 1; i < size; ++i) {
            where = where.and(pkFields.get(i).eq(entityId.get(i)));
        }
        DSLContext dslContext = pm.getDslContext();
        Set propertyFields = this.getPropertyFieldRegistry().getSelectFields(new HashSet());
        Set<Field> selectFields = QueryState.propertiesToFields(thisTable, propertyFields);
        Record result = null;
        if (!updateFields.isEmpty()) {
            try {
                result = (Record)dslContext.update(thisTable).set(updateFields).where(where).returningResult(selectFields).fetchOne();
            }
            catch (TooManyRowsException e) {
                LOGGER.error("Updating {} {} caused too many rows to change (more than one)!", (Object)entityType, (Object)entityId);
                throw new IllegalStateException("Update changed multiple rows.", e);
            }
        }
        for (NavigationPropertyMain<EntitySet> navigationPropertyMain : entityType.getNavigationSets()) {
            if (!entity.isSetProperty(navigationPropertyMain)) continue;
            this.updateNavigationPropertySet(entity, entity.getProperty(navigationPropertyMain), pm, updateMode);
        }
        for (SortingWrapper sortingWrapper : this.hooksPostUpdate) {
            ((HookPostUpdate)sortingWrapper.getObject()).postUpdateInDatabase(pm, entity, entityId, updateMode);
        }
        DefaultEntity newEntity = new DefaultEntity(entityType, entity.getPrimaryKeyValues());
        message.setEntity(newEntity);
        if (result != null) {
            for (PropertyFieldRegistry.PropertyFields sp : propertyFields) {
                sp.converter.convert(thisTable, result, newEntity, dataSize);
            }
        }
        return message;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void delete(JooqPersistenceManager pm, PkValue entityId) throws NoSuchEntityException {
        void var4_6;
        for (SortingWrapper sortingWrapper : this.hooksPreDelete) {
            ((HookPreDelete)sortingWrapper.getObject()).preDelete(pm, entityId);
        }
        List<Field> pkFields = this.getPkFields();
        Condition condition = pkFields.get(0).eq(entityId.get(0));
        int size = entityId.size();
        for (int i = 1; i < size; ++i) {
            Condition condition2 = var4_6.and(pkFields.get(i).eq(entityId.get(i)));
        }
        StaMainTable thisTable = (StaMainTable)this.getThis();
        long count = pm.getDslContext().delete(thisTable).where((Condition)var4_6).execute();
        if (count == 0L) {
            throw new NoSuchEntityException("Entity of type " + this.getEntityType() + " with id " + entityId + " not found.");
        }
        for (SortingWrapper sortingWrapper : this.hooksPostDelete) {
            ((HookPostDelete)sortingWrapper.getObject()).postDelete(pm, entityId);
        }
        LOGGER.debug("Deleted {} Entities of type {}", (Object)count, (Object)this.getEntityType());
    }

    @Override
    public EntitySet newSet() {
        return new EntitySetImpl(this.getEntityType());
    }

    @Override
    public abstract T as(Name var1);

    @Override
    public final T as(String alias) {
        return (T)this.as(DSL.name(alias));
    }

    public ModelRegistry getModelRegistry() {
        return this.modelRegistry;
    }

    public final TableCollection getTables() {
        return this.tables;
    }

    public final void init(ModelRegistry modelRegistry, TableCollection tables) {
        this.modelRegistry = modelRegistry;
        this.tables = tables;
    }

    @Override
    public PropertyFieldRegistry.PropertyFields<T> handleEntityPropertyCustomSelect(EntityPropertyCustomSelect epCustomSelect) {
        String epName = epCustomSelect.getMainEntityPropertyName();
        EntityPropertyMain mainEntityProperty = this.getEntityType().getEntityProperty(epName);
        if (mainEntityProperty.hasCustomProperties) {
            PropertyFieldRegistry.PropertyFields<T> mainPropertyFields = this.pfReg.getSelectFieldsForProperty(mainEntityProperty);
            if (mainPropertyFields.jsonType) {
                PropertyFieldRegistry.ExpressionFactory<StaMainTable> factory = mainPropertyFields.fields.get("j");
                if (factory == null) {
                    factory = mainPropertyFields.fields.values().iterator().next();
                }
                Field mainField = factory.get((StaMainTable)this.getThis());
                JsonFieldFactory.JsonFieldWrapper jsonFactory = StaTableAbstract.jsonFieldFromPath(mainField, epCustomSelect);
                return this.propertyFieldForJsonField(jsonFactory, epCustomSelect);
            }
            PropertyFieldRegistry.ExpressionFactory<StaMainTable> factory = mainPropertyFields.fields.get(epCustomSelect.getSubPath().get(0));
            if (factory == null) {
                throw new IllegalArgumentException("No path: " + epCustomSelect);
            }
            Field field = factory.get((StaMainTable)this.getThis());
            return this.propertyFieldForCustom(field, epCustomSelect);
        }
        return null;
    }

    public static JsonFieldFactory.JsonFieldWrapper jsonFieldFromPath(Field mainField, EntityPropertyCustomSelect epCustomSelect) {
        JsonFieldFactory.JsonFieldWrapper jsonFactory = new JsonFieldFactory.JsonFieldWrapper(mainField);
        for (String pathItem : epCustomSelect.getSubPath()) {
            jsonFactory.addToPath(pathItem);
        }
        return jsonFactory;
    }

    protected PropertyFieldRegistry.PropertyFields<T> propertyFieldForJsonField(JsonFieldFactory.JsonFieldWrapper jsonFactory, EntityPropertyCustomSelect epCustomSelect) {
        Field<Object> deepField = jsonFactory.materialise().getJsonExpression();
        PropertyFieldRegistry.PropertyFields<StaMainTable> pfs = new PropertyFieldRegistry.PropertyFields<StaMainTable>(epCustomSelect, new PropertyFieldRegistry.ConverterRecordDeflt<StaMainTable>((tbl, tuple, entity, dataSize) -> {
            JsonValue jsonValue = JsonBinding.getConverterInstance().from(tuple.get(deepField));
            dataSize.increase(jsonValue.getStringLength());
            Object value = jsonValue.getValue();
            epCustomSelect.setOn(entity, value);
        }, null, null));
        pfs.addField("1", t2 -> deepField);
        return pfs;
    }

    protected PropertyFieldRegistry.PropertyFields<T> propertyFieldForCustom(Field field, EntityPropertyCustomSelect epCustomSelect) {
        PropertyFieldRegistry.PropertyFields<StaMainTable> pfs = new PropertyFieldRegistry.PropertyFields<StaMainTable>(epCustomSelect, new PropertyFieldRegistry.ConverterRecordDeflt<StaMainTable>((tbl, tuple, entity, dataSize) -> epCustomSelect.setOn(entity, tuple.get(field)), null, null));
        pfs.addField("1", t2 -> field);
        return pfs;
    }
}

