/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.relations;

import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.JooqPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.QueryBuilder;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories.EntityFactories;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.relations.FieldAccessor;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.relations.Relation;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.QueryState;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.TableRef;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncompleteEntityException;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.NoSuchEntityException;
import java.util.HashMap;
import org.apache.commons.lang3.NotImplementedException;
import org.jooq.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationOneToMany<S extends StaMainTable<S>, T extends StaMainTable<T>>
implements Relation<S> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelationOneToMany.class.getName());
    private final NavigationPropertyMain navProp;
    private final String name;
    private FieldAccessor<S> sourceFieldAccessor;
    private final T target;
    private FieldAccessor<T> targetFieldAccessor;
    private final boolean distinctRequired;

    public RelationOneToMany(NavigationPropertyMain navProp, S source, T target) {
        this(navProp, source, target, navProp.isEntitySet());
    }

    public RelationOneToMany(NavigationPropertyMain navProp, S source, T target, boolean distinctRequired) {
        if (source == null) {
            LOGGER.error("NULL source");
        }
        this.navProp = navProp;
        this.target = target;
        this.name = navProp.getName();
        this.distinctRequired = distinctRequired;
        if (source.getPkFields().size() != 1 || target.getPkFields().size() != 1) {
            throw new NotImplementedException("Multi-valued primary keys are not implemented yet.");
        }
    }

    public RelationOneToMany<S, T> setSourceFieldAccessor(FieldAccessor<S> sourceFieldAccessor) {
        this.sourceFieldAccessor = sourceFieldAccessor;
        return this;
    }

    public RelationOneToMany<S, T> setTargetFieldAccessor(FieldAccessor<T> targetFieldAccessor) {
        this.targetFieldAccessor = targetFieldAccessor;
        return this;
    }

    @Override
    public TableRef join(S joinSource, QueryState<?> queryState, TableRef sourceRef) {
        Field sourceField = this.sourceFieldAccessor.getField(joinSource);
        StaMainTable targetAliased = this.target.asSecure(queryState.getNextAlias(), queryState.getPersistenceManager());
        Field targetField = this.targetFieldAccessor.getField(targetAliased);
        queryState.setSqlFrom(queryState.getSqlFrom().leftJoin(targetAliased).on(targetField.eq(sourceField)));
        if (this.distinctRequired) {
            queryState.setDistinctRequired(this.distinctRequired);
        }
        HashMap<Field, Field> joinEquals = new HashMap<Field, Field>();
        joinEquals.put(targetField, sourceField);
        return QueryBuilder.createJoinedRef(sourceRef, this.navProp, targetAliased).setJoinEquals(joinEquals);
    }

    @Override
    public void semiJoinTo(S joinSource, StaMainTable joinTarget, QueryState<?> queryState) {
        Field sourceField = this.sourceFieldAccessor.getField(joinSource);
        Field targetField = this.targetFieldAccessor.getField(joinTarget);
        queryState.setSqlWhere(queryState.getSqlWhere().and(targetField.eq(sourceField)));
    }

    @Override
    public void link(JooqPersistenceManager pm, Entity source, EntitySet targets, NavigationPropertyMain navProp) throws NoSuchEntityException, IncompleteEntityException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void link(JooqPersistenceManager pm, Entity source, Entity target, NavigationPropertyMain navProp) throws IncompleteEntityException, NoSuchEntityException {
        if (!this.distinctRequired) {
            throw new IllegalStateException("Trying to update a one-to-many relation from the wrong side.");
        }
        EntityFactories entityFactories = pm.getEntityFactories();
        if (!entityFactories.entityExists(pm, target, true)) {
            throw new NoSuchEntityException("Linked Entity with no id.");
        }
        this.link(pm, source.getPrimaryKeyValues().get(0), target.getPrimaryKeyValues().get(0));
    }

    protected void link(JooqPersistenceManager pm, Object sourceId, Object targetId) {
        if (!this.distinctRequired) {
            throw new IllegalStateException("Trying to update a one-to-many relation from the wrong side.");
        }
        int count = pm.getDslContext().update(this.target).set(this.targetFieldAccessor.getField(this.target), sourceId).where(this.target.getPkFields().get(0).eq(targetId)).execute();
        if (count != 1) {
            LOGGER.error("Executing query did not result in an update!");
        }
    }

    @Override
    public void unLink(JooqPersistenceManager pm, Entity source, Entity target, NavigationPropertyMain navProp) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getName() {
        return this.name;
    }
}

