/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.relations;

import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.JooqPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.QueryBuilder;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.relations.FieldAccessor;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.relations.RelationManyToMany;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.QueryState;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.TableRef;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.query.OrderBy;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectConditionStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationManyToManyOrdered<S extends StaMainTable<S>, L extends StaTable<L>, T extends StaMainTable<T>>
extends RelationManyToMany<S, L, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelationManyToManyOrdered.class.getName());
    private FieldAccessor<L> orderFieldAcc;
    private boolean alwaysDistinct = false;
    private boolean orderOnSource = true;

    public RelationManyToManyOrdered(NavigationPropertyMain navProp, S source, L linkTable, T target, boolean orderOnSource) {
        super(navProp, source, linkTable, target);
        this.orderOnSource = orderOnSource;
    }

    public RelationManyToManyOrdered<S, L, T> setOrderFieldAcc(FieldAccessor<L> orderFieldAcc) {
        this.orderFieldAcc = orderFieldAcc;
        return this;
    }

    public RelationManyToManyOrdered<S, L, T> setAlwaysDistinct(boolean alwaysDistinct) {
        this.alwaysDistinct = alwaysDistinct;
        return this;
    }

    @Override
    public TableRef join(S source, QueryState<?> queryState, TableRef sourceRef) {
        StaMainTable targetAliased = this.getTarget().asSecure(queryState.getNextAlias(), queryState.getPersistenceManager());
        Table linkTableAliased = this.getLinkTable().as(queryState.getNextAlias());
        Field sourceField = this.getSourceFieldAcc().getField(source);
        Field sourceLinkField = this.getSourceLinkFieldAcc().getField(linkTableAliased);
        Field targetLinkField = this.getTargetLinkFieldAcc().getField(linkTableAliased);
        Field targetField = this.getTargetFieldAcc().getField(targetAliased);
        queryState.setSqlFrom(queryState.getSqlFrom().leftJoin(linkTableAliased).on(sourceLinkField.eq(sourceField)));
        queryState.setSqlFrom(queryState.getSqlFrom().leftJoin(targetAliased).on(targetField.eq(targetLinkField)));
        if (this.alwaysDistinct || queryState.isFilter()) {
            queryState.setDistinctRequired(true);
        } else {
            Field orderField = this.orderFieldAcc.getField(linkTableAliased);
            queryState.getSqlSortFields().add(orderField, OrderBy.OrderType.ASCENDING);
        }
        return QueryBuilder.createJoinedRef(sourceRef, this.getNavProp(), targetAliased);
    }

    @Override
    protected void link(JooqPersistenceManager pm, Object sourceId, Object targetId) {
        DSLContext dslContext = pm.getDslContext();
        Object linkTable = this.getLinkTable();
        Field sourceLinkField = this.getSourceLinkFieldAcc().getField(linkTable);
        Field targetLinkField = this.getTargetLinkFieldAcc().getField(linkTable);
        Field orderField = this.orderFieldAcc.getField(linkTable);
        SelectConditionStep orderValue = this.orderOnSource ? dslContext.selectCount().from((TableLike<?>)linkTable).where(sourceLinkField.equal(sourceId)) : dslContext.selectCount().from((TableLike<?>)linkTable).where(sourceLinkField.equal(targetId));
        dslContext.insertInto(linkTable).set(sourceLinkField, sourceId).set(targetLinkField, targetId).set(orderField, orderValue).execute();
    }

    @Override
    public void unLink(JooqPersistenceManager pm, Entity source, Entity target, NavigationPropertyMain navProp) {
        Object linkTable = this.getLinkTable();
        Field sourceLinkField = this.getSourceLinkFieldAcc().getField(linkTable);
        Field targetLinkField = this.getTargetLinkFieldAcc().getField(linkTable);
        Field orderField = this.orderFieldAcc.getField(linkTable);
        Condition sourceCondition = sourceLinkField.eq(source.getPrimaryKeyValues().get(0));
        Condition targetCondition = targetLinkField.eq(target.getPrimaryKeyValues().get(0));
        DSLContext dslContext = pm.getDslContext();
        int deletedOrderIdx = dslContext.deleteFrom(linkTable).where(sourceCondition.and(targetCondition)).limit(1).returning(orderField).execute();
        int updated = this.orderOnSource ? dslContext.update(linkTable).set(orderField, orderField.sub(1)).where(sourceCondition).and(orderField.gt(deletedOrderIdx)).execute() : dslContext.update(linkTable).set(orderField, orderField.sub(1)).where(targetCondition).and(orderField.gt(deletedOrderIdx)).execute();
        LOGGER.trace("Updated {} order entries", (Object)updated);
    }
}

