/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.relations;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.model.core.PkValue;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.JooqPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.QueryBuilder;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.relations.FieldAccessor;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.relations.Relation;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.QueryState;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.TableRef;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncompleteEntityException;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.NoSuchEntityException;
import org.apache.commons.lang3.NotImplementedException;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationManyToMany<S extends StaMainTable<S>, L extends StaTable<L>, T extends StaMainTable<T>>
implements Relation<S> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelationManyToMany.class.getName());
    private final NavigationPropertyMain navProp;
    private final EntityType targetType;
    private final String name;
    private FieldAccessor<S> sourceFieldAcc;
    private final L linkTable;
    private FieldAccessor<L> sourceLinkFieldAcc;
    private FieldAccessor<L> targetLinkFieldAcc;
    private final T target;
    private FieldAccessor<T> targetFieldAcc;
    private boolean symmetrical;

    public RelationManyToMany(NavigationPropertyMain navProp, S source, L linkTable, T target) {
        this(navProp, source, linkTable, target, false);
    }

    public RelationManyToMany(NavigationPropertyMain navProp, S source, L linkTable, T target, boolean symmetrical) {
        if (source == null) {
            LOGGER.error("NULL source");
        }
        this.navProp = navProp;
        this.linkTable = linkTable;
        this.target = target;
        this.targetType = navProp.getEntityType();
        this.name = navProp.getName();
        this.symmetrical = symmetrical;
        if (source.getPkFields().size() != 1 || target.getPkFields().size() != 1) {
            throw new NotImplementedException("Multi-valued primary keys are not implemented yet.");
        }
    }

    public FieldAccessor<S> getSourceFieldAcc() {
        return this.sourceFieldAcc;
    }

    public RelationManyToMany<S, L, T> setSourceFieldAcc(FieldAccessor<S> sourceFieldAcc) {
        this.sourceFieldAcc = sourceFieldAcc;
        return this;
    }

    public L getLinkTable() {
        return this.linkTable;
    }

    public FieldAccessor<L> getSourceLinkFieldAcc() {
        return this.sourceLinkFieldAcc;
    }

    public RelationManyToMany<S, L, T> setSourceLinkFieldAcc(FieldAccessor<L> sourceLinkFieldAcc) {
        this.sourceLinkFieldAcc = sourceLinkFieldAcc;
        return this;
    }

    public FieldAccessor<L> getTargetLinkFieldAcc() {
        return this.targetLinkFieldAcc;
    }

    public RelationManyToMany<S, L, T> setTargetLinkFieldAcc(FieldAccessor<L> targetLinkFieldAcc) {
        this.targetLinkFieldAcc = targetLinkFieldAcc;
        return this;
    }

    public FieldAccessor<T> getTargetFieldAcc() {
        return this.targetFieldAcc;
    }

    public RelationManyToMany<S, L, T> setTargetFieldAcc(FieldAccessor<T> targetFieldAcc) {
        this.targetFieldAcc = targetFieldAcc;
        return this;
    }

    public T getTarget() {
        return this.target;
    }

    public NavigationPropertyMain getNavProp() {
        return this.navProp;
    }

    public EntityType getTargetType() {
        return this.targetType;
    }

    @Override
    public TableRef join(S source, QueryState<?> queryState, TableRef sourceRef) {
        Table linkTableAliased = this.linkTable.as(queryState.getNextAlias());
        StaMainTable targetAliased = this.target.asSecure(queryState.getNextAlias(), queryState.getPersistenceManager());
        Field sourceField = this.sourceFieldAcc.getField(source);
        Field sourceLinkField = this.sourceLinkFieldAcc.getField(linkTableAliased);
        Field targetLinkField = this.targetLinkFieldAcc.getField(linkTableAliased);
        Field targetField = this.targetFieldAcc.getField(targetAliased);
        queryState.setSqlFrom(queryState.getSqlFrom().leftJoin(linkTableAliased).on(sourceLinkField.eq(sourceField)));
        queryState.setSqlFrom(queryState.getSqlFrom().leftJoin(targetAliased).on(targetField.eq(targetLinkField)));
        queryState.setDistinctRequired(true);
        return QueryBuilder.createJoinedRef(sourceRef, this.navProp, targetAliased);
    }

    @Override
    public void semiJoinTo(S joinSource, StaMainTable joinTarget, QueryState<?> queryState) {
        if (joinTarget.getEntityType() != this.target.getEntityType()) {
            throw new IllegalArgumentException("SemiJoin target entity type incorrect. Expected " + this.target.getEntityType() + ", got " + joinTarget.getEntityType());
        }
        Table linkTableAliased = this.linkTable.as(queryState.getNextAlias());
        Field sourceField = this.sourceFieldAcc.getField(joinSource);
        Field sourceLinkField = this.sourceLinkFieldAcc.getField(linkTableAliased);
        Field targetLinkField = this.targetLinkFieldAcc.getField(linkTableAliased);
        Field targetField = this.targetFieldAcc.getField(joinTarget);
        queryState.setSqlFrom(queryState.getSqlFrom().leftJoin(linkTableAliased).on(sourceLinkField.eq(sourceField)));
        queryState.setSqlWhere(queryState.getSqlWhere().and(targetField.eq(targetLinkField)));
    }

    @Override
    public void link(JooqPersistenceManager pm, Entity source, EntitySet targets, NavigationPropertyMain navProp) throws NoSuchEntityException, IncompleteEntityException {
        PkValue primaryKeyValues = source.getPrimaryKeyValues();
        Object sourceId = primaryKeyValues.get(0);
        int count = pm.getDslContext().deleteFrom(this.linkTable).where(this.sourceLinkFieldAcc.getField(this.linkTable).eq(sourceId)).execute();
        LOGGER.debug("Removed {} relations from {}", (Object)count, (Object)this.linkTable.getName());
        for (Entity targetEntity : targets) {
            this.link(pm, sourceId, targetEntity.getPrimaryKeyValues().get(0));
        }
    }

    @Override
    public void link(JooqPersistenceManager pm, Entity source, Entity target, NavigationPropertyMain navProp) throws NoSuchEntityException, IncompleteEntityException {
        this.link(pm, source.getPrimaryKeyValues().get(0), target.getPrimaryKeyValues().get(0));
    }

    protected void link(JooqPersistenceManager pm, Object sourceId, Object targetId) {
        pm.getDslContext().insertInto(this.linkTable).set(this.sourceLinkFieldAcc.getField(this.linkTable), sourceId).set(this.targetLinkFieldAcc.getField(this.linkTable), targetId).onConflictDoNothing().execute();
        if (this.symmetrical && !sourceId.equals(targetId)) {
            pm.getDslContext().insertInto(this.linkTable).set(this.sourceLinkFieldAcc.getField(this.linkTable), targetId).set(this.targetLinkFieldAcc.getField(this.linkTable), sourceId).onConflictDoNothing().execute();
        }
    }

    @Override
    public void unLink(JooqPersistenceManager pm, Entity source, Entity target, NavigationPropertyMain navProp) {
        Object sourceId = source.getPrimaryKeyValues().get(0);
        Object targetId = target.getPrimaryKeyValues().get(0);
        Condition sourceCondition = this.sourceLinkFieldAcc.getField(this.linkTable).eq(sourceId);
        Condition targetCondition = this.targetLinkFieldAcc.getField(this.linkTable).eq(targetId);
        pm.getDslContext().deleteFrom(this.linkTable).where(sourceCondition.and(targetCondition)).limit(1).execute();
        if (this.symmetrical) {
            Condition sourceConditionInv = this.sourceLinkFieldAcc.getField(this.linkTable).eq(targetId);
            Condition targetConditionInv = this.targetLinkFieldAcc.getField(this.linkTable).eq(sourceId);
            pm.getDslContext().deleteFrom(this.linkTable).where(sourceConditionInv.and(targetConditionInv)).limit(1).execute();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }
}

