/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper;

import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.bindings.MomentBinding;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper.FieldWrapper;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper.SimpleFieldWrapper;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper.StaDateTimeWrapper;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper.StaDurationWrapper;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper.TimeFieldWrapper;
import java.util.Map;
import net.time4j.Moment;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.QueryPart;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaTimeIntervalWrapper
implements TimeFieldWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaTimeIntervalWrapper.class.getName());
    public static final String KEY_TIME_INTERVAL_START = "start";
    public static final String KEY_TIME_INTERVAL_END = "end";
    private static final String INCOMPATIBLE_OP = "Incompatible operator: Interval '";
    private static final boolean UTC = true;
    private final Field<Moment> start;
    private final Field<Moment> end;

    public StaTimeIntervalWrapper(Map<String, Field> expressions) {
        this.start = expressions.get(KEY_TIME_INTERVAL_START);
        this.end = expressions.get(KEY_TIME_INTERVAL_END);
    }

    public StaTimeIntervalWrapper(Field<Moment> start, Field<Moment> end) {
        this.start = start;
        this.end = end;
    }

    public StaTimeIntervalWrapper(Moment start, Moment end) {
        this.start = DSL.inline((Object)start, MomentBinding.dataType());
        this.end = DSL.inline((Object)end, MomentBinding.dataType());
    }

    public Field<Moment> getStart() {
        return this.start;
    }

    public Field<Moment> getEnd() {
        return this.end;
    }

    @Override
    public Field getDefaultField() {
        return this.getStart();
    }

    @Override
    public <T> Field<T> getFieldAsType(Class<T> expectedClazz, boolean canCast) {
        Class fieldType = this.start.getType();
        if (expectedClazz.isAssignableFrom(fieldType)) {
            return this.start;
        }
        if (canCast && expectedClazz == String.class) {
            return this.start.cast(String.class);
        }
        LOGGER.debug("Not a {}: {} ({} -- {})", expectedClazz.getName(), this.start, this.start.getClass().getName(), fieldType.getName());
        return null;
    }

    @Override
    public Field<Moment> getDateTime() {
        return this.getStart();
    }

    @Override
    public boolean isUtc() {
        return true;
    }

    private FieldWrapper specificOp(String op, StaDurationWrapper other) {
        switch (op) {
            case "+": 
            case "-": {
                String template = "(? " + op + " (?)::interval)";
                return new StaTimeIntervalWrapper(DSL.field(template, MomentBinding.dataType(), new QueryPart[]{this.start, other.getDuration()}), DSL.field(template, MomentBinding.dataType(), new QueryPart[]{this.end, other.getDuration()}));
            }
        }
        throw new UnsupportedOperationException(INCOMPATIBLE_OP + op + "' " + other.getClass().getName());
    }

    private FieldWrapper specificOp(String op, StaDateTimeWrapper other) {
        if ("-".equals(op)) {
            return new StaDurationWrapper(this.start, other.getDateTime());
        }
        throw new UnsupportedOperationException(INCOMPATIBLE_OP + op + "' " + other.getClass().getName());
    }

    private FieldWrapper specificOp(String op, StaTimeIntervalWrapper other) {
        if ("-".equals(op)) {
            return new StaDurationWrapper(this.start, other.start);
        }
        throw new UnsupportedOperationException(INCOMPATIBLE_OP + op + "' " + other.getClass().getName());
    }

    @Override
    public FieldWrapper simpleOp(String op, FieldWrapper other) {
        if (other instanceof StaDurationWrapper) {
            StaDurationWrapper staDurationWrapper = (StaDurationWrapper)other;
            return this.specificOp(op, staDurationWrapper);
        }
        if (other instanceof StaDateTimeWrapper) {
            StaDateTimeWrapper staDateTimeWrapper = (StaDateTimeWrapper)other;
            return this.specificOp(op, staDateTimeWrapper);
        }
        if (other instanceof StaTimeIntervalWrapper) {
            StaTimeIntervalWrapper staTimeIntervalWrapper = (StaTimeIntervalWrapper)other;
            return this.specificOp(op, staTimeIntervalWrapper);
        }
        throw new UnsupportedOperationException("Can not add, sub, mul or div with Duration and " + other.getClass().getName());
    }

    private Condition specificOpBool(String op, StaDateTimeWrapper other) {
        Field<Moment> s1 = this.start;
        Field<Moment> e1 = this.end;
        Field<Moment> t2 = other.getDateTime();
        switch (op) {
            case "=": {
                return s1.equal(t2).and(e1.equal(t2));
            }
            case "!=": {
                return s1.notEqual(t2).and(e1.notEqual(t2));
            }
            case ">": {
                return s1.greaterThan(t2);
            }
            case ">=": {
                return s1.greaterOrEqual(t2);
            }
            case "<": {
                return e1.lessOrEqual(t2).and(s1.lessThan(t2));
            }
            case "<=": {
                return e1.lessOrEqual(t2);
            }
            case "a": {
                return s1.greaterThan(t2);
            }
            case "b": {
                return e1.lessOrEqual(t2).and(s1.lessThan(t2));
            }
            case "c": {
                return s1.lessOrEqual(t2).and(e1.greaterThan(t2));
            }
            case "m": {
                return s1.equal(t2).or(e1.equal(t2));
            }
            case "o": {
                return s1.equal(t2).or(s1.lessOrEqual(t2).and(e1.greaterThan(t2)));
            }
            case "s": {
                return s1.equal(t2);
            }
            case "f": {
                return e1.equal(t2);
            }
        }
        throw new UnsupportedOperationException("Unknown boolean operation: " + op);
    }

    private Condition specificOpBool(String op, StaTimeIntervalWrapper other) {
        Field<Moment> s1 = this.start;
        Field<Moment> e1 = this.end;
        Field<Moment> s2 = other.getStart();
        Field<Moment> e2 = other.getEnd();
        switch (op) {
            case "=": {
                return s1.equal(s2).and(e1.equal(e2));
            }
            case "!=": {
                return s1.notEqual(s2).and(e1.notEqual(e2));
            }
            case ">": {
                return s1.greaterOrEqual(e2).and(s1.greaterThan(s2));
            }
            case ">=": {
                return s1.greaterOrEqual(s2).and(e1.greaterOrEqual(e2));
            }
            case "<": {
                return e1.lessOrEqual(s2).and(s1.lessThan(s2));
            }
            case "<=": {
                return s1.lessOrEqual(s2).and(e1.lessOrEqual(e2));
            }
            case "a": {
                return s1.greaterOrEqual(e2).and(s1.greaterThan(s2));
            }
            case "b": {
                return e1.lessOrEqual(s2).and(s1.lessThan(s2));
            }
            case "c": {
                return s1.lessOrEqual(s2).and(e1.greaterThan(s2)).and(e1.greaterOrEqual(e2));
            }
            case "m": {
                return s1.equal(e2).or(e1.equal(s2));
            }
            case "o": {
                return s1.greaterOrEqual(e2).or(s2.greaterOrEqual(e1)).not().or(s1.equal(s2));
            }
            case "s": {
                return s1.equal(s2);
            }
            case "f": {
                return e1.equal(e2);
            }
        }
        throw new UnsupportedOperationException("Unknown boolean operation: " + op);
    }

    @Override
    public FieldWrapper simpleOpBool(String op, FieldWrapper other) {
        if (other instanceof StaDateTimeWrapper) {
            StaDateTimeWrapper staDateTimeWrapper = (StaDateTimeWrapper)other;
            return new SimpleFieldWrapper(this.specificOpBool(op, staDateTimeWrapper));
        }
        if (other instanceof StaTimeIntervalWrapper) {
            StaTimeIntervalWrapper staTimeIntervalWrapper = (StaTimeIntervalWrapper)other;
            return new SimpleFieldWrapper(this.specificOpBool(op, staTimeIntervalWrapper));
        }
        throw new UnsupportedOperationException("Can not compare between Duration and " + other.getClass().getName());
    }
}

