/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper;

import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper.FieldListWrapper;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper.FieldWrapper;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper.SimpleFieldWrapper;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper.StaDateTimeWrapper;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper.StaTimeIntervalWrapper;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper.TimeFieldWrapper;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.DurationConstant;
import net.time4j.Moment;
import org.jooq.Field;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaDurationWrapper
implements TimeFieldWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaDurationWrapper.class.getName());
    private final Field<String> duration;

    public StaDurationWrapper(DurationConstant duration) {
        this.duration = DSL.val(duration.asISO8601());
    }

    public StaDurationWrapper(Field<String> duration) {
        this.duration = duration;
    }

    public StaDurationWrapper(Field<Moment> ts1, Field<Moment> ts2) {
        String template = "((?)::timestamp - (?)::timestamp)";
        this.duration = DSL.field(template, String.class, ts1, ts2);
    }

    @Override
    public Field getDefaultField() {
        return this.getDuration();
    }

    @Override
    public <T> Field<T> getFieldAsType(Class<T> expectedClazz, boolean canCast) {
        Class fieldType = this.duration.getType();
        if (expectedClazz.isAssignableFrom(fieldType)) {
            return this.duration;
        }
        if (canCast && expectedClazz == String.class) {
            return this.duration.cast(String.class);
        }
        LOGGER.debug("Not a {}: {} ({} -- {})", expectedClazz.getName(), this.duration, this.duration.getClass().getName(), fieldType.getName());
        return null;
    }

    @Override
    public Field<Moment> getDateTime() {
        throw new UnsupportedOperationException("Can not convert duration to DateTime.");
    }

    @Override
    public boolean isUtc() {
        return true;
    }

    public Field<String> getDuration() {
        return this.duration;
    }

    @Override
    public FieldWrapper after(FieldWrapper other) {
        throw new UnsupportedOperationException("Can not use after with duration.");
    }

    @Override
    public FieldWrapper before(FieldWrapper other) {
        throw new UnsupportedOperationException("Can not use before with duration.");
    }

    @Override
    public FieldWrapper meets(FieldWrapper other) {
        throw new UnsupportedOperationException("Can not use meets with duration.");
    }

    @Override
    public FieldWrapper contains(FieldWrapper other) {
        throw new UnsupportedOperationException("Can not use contais with duration.");
    }

    @Override
    public FieldWrapper overlaps(FieldWrapper other) {
        throw new UnsupportedOperationException("Can not use overlaps with duration.");
    }

    @Override
    public FieldWrapper starts(FieldWrapper other) {
        throw new UnsupportedOperationException("Can not use starts with duration.");
    }

    @Override
    public FieldWrapper finishes(FieldWrapper other) {
        throw new UnsupportedOperationException("Can not use finishes with duration.");
    }

    private FieldWrapper specificOp(String op, StaDurationWrapper other) {
        String template = "((?)::interval " + op + " (?)::interval)";
        Field<Moment> expression = DSL.field(template, Moment.class, this.duration, other.duration);
        return new StaDateTimeWrapper(expression);
    }

    private FieldWrapper specificOp(String op, StaTimeIntervalWrapper other) {
        Field<Moment> dtEnd = other.getEnd();
        Field<Moment> dtStart = other.getStart();
        String template = "((?)::interval " + op + " (?)::timestamp)";
        Field<Moment> newStart = DSL.field(template, Moment.class, this.duration, dtStart);
        Field<Moment> newEnd = DSL.field(template, Moment.class, this.duration, dtEnd);
        return new StaTimeIntervalWrapper(newStart, newEnd);
    }

    private FieldWrapper specificOp(String op, StaDateTimeWrapper other) {
        String template = "((?)::interval " + op + " (?)::timestamp)";
        Field<Moment> expression = DSL.field(template, Moment.class, this.duration, other);
        return new StaDateTimeWrapper(expression);
    }

    private FieldWrapper specificOp(String op, Field<Number> other) {
        switch (op) {
            case "*": 
            case "/": {
                String template = "((?)::interval " + op + " (?))";
                Field<String> expression = DSL.field(template, String.class, this.duration, other);
                return new StaDurationWrapper(expression);
            }
        }
        throw new UnsupportedOperationException("Can not '" + op + "' with Duration and " + other.getClass().getName());
    }

    @Override
    public FieldWrapper simpleOp(String op, FieldWrapper other) {
        if (other instanceof StaDurationWrapper) {
            StaDurationWrapper staDurationWrapper = (StaDurationWrapper)other;
            return this.specificOp(op, staDurationWrapper);
        }
        if (other instanceof StaTimeIntervalWrapper) {
            StaTimeIntervalWrapper staTimeIntervalWrapper = (StaTimeIntervalWrapper)other;
            return this.specificOp(op, staTimeIntervalWrapper);
        }
        if (other instanceof StaDateTimeWrapper) {
            StaDateTimeWrapper staDateTimeWrapper = (StaDateTimeWrapper)other;
            return this.specificOp(op, staDateTimeWrapper);
        }
        if (other instanceof FieldListWrapper) {
            FieldListWrapper fieldListWrapper = (FieldListWrapper)other;
            Field<Number> nrOther = fieldListWrapper.getFieldAsType(Number.class, true);
            return this.specificOp(op, nrOther);
        }
        Field<Number> otherField = other.getFieldAsType(Number.class, true);
        if (otherField != null) {
            return this.specificOp(op, otherField);
        }
        throw new UnsupportedOperationException("Can not add, sub, mul or div with Duration and " + other.getClass().getName());
    }

    @Override
    public FieldWrapper simpleOpBool(String op, FieldWrapper other) {
        if (other instanceof StaDurationWrapper) {
            StaDurationWrapper cd2 = (StaDurationWrapper)other;
            String template = "((?)::interval " + op + " (?)::interval)";
            return new SimpleFieldWrapper(DSL.condition(template, this.duration, cd2.duration));
        }
        throw new UnsupportedOperationException("Can not compare between Duration and " + other.getClass().getName());
    }
}

