/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper;

import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.bindings.MomentBinding;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper.FieldWrapper;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper.SimpleFieldWrapper;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper.StaDurationWrapper;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper.StaTimeIntervalWrapper;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper.TimeFieldWrapper;
import net.time4j.Moment;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.QueryPart;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaDateTimeWrapper
implements TimeFieldWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaDateTimeWrapper.class.getName());
    private boolean utc = true;
    private final Field<Moment> field;

    public StaDateTimeWrapper(Moment ts, boolean utc) {
        this.field = DSL.inline((Object)ts, MomentBinding.dataType());
        this.utc = utc;
    }

    public StaDateTimeWrapper(Field<Moment> mixin) {
        this.field = mixin;
    }

    @Override
    public Field getDefaultField() {
        return this.getDateTime();
    }

    @Override
    public <T> Field<T> getFieldAsType(Class<T> expectedClazz, boolean canCast) {
        Class fieldType = this.field.getType();
        if (expectedClazz.isAssignableFrom(fieldType)) {
            return this.field;
        }
        if (canCast && expectedClazz == String.class) {
            return this.field.cast(String.class);
        }
        LOGGER.debug("Not a {}: {} ({} -- {})", expectedClazz.getName(), this.field, this.field.getClass().getName(), fieldType.getName());
        return null;
    }

    @Override
    public boolean isUtc() {
        return this.utc;
    }

    @Override
    public Field<Moment> getDateTime() {
        return this.field;
    }

    private FieldWrapper specificOp(String op, StaDurationWrapper other) {
        switch (op) {
            case "+": 
            case "-": {
                String template = "(? " + op + " (?)::interval)";
                Field<Moment> expression = DSL.field(template, MomentBinding.dataType(), new QueryPart[]{this.field, other.getDuration()});
                return new StaDateTimeWrapper(expression);
            }
        }
        throw new UnsupportedOperationException("Can not mul or div a DateTime with a " + other.getClass().getName());
    }

    private FieldWrapper specificOp(String op, StaDateTimeWrapper other) {
        if ("-".equals(op)) {
            return new StaDurationWrapper(this.field, other.getDateTime());
        }
        throw new UnsupportedOperationException("Can not add, mul or div two DateTimes.");
    }

    @Override
    public FieldWrapper simpleOp(String op, FieldWrapper other) {
        if (other instanceof StaDurationWrapper) {
            StaDurationWrapper staDurationWrapper = (StaDurationWrapper)other;
            return this.specificOp(op, staDurationWrapper);
        }
        if (other instanceof StaDateTimeWrapper) {
            StaDateTimeWrapper staDateTimeWrapper = (StaDateTimeWrapper)other;
            return this.specificOp(op, staDateTimeWrapper);
        }
        throw new UnsupportedOperationException("Can not add, sub, mul or div a DateTime with a " + other.getClass().getName());
    }

    private Condition specificOpBool(String op, StaDateTimeWrapper other) {
        Field<Moment> t1 = this.field;
        Field<Moment> t2 = other.field;
        switch (op) {
            case "=": {
                return t1.equal(t2);
            }
            case "!=": {
                return t1.notEqual(t2);
            }
            case ">": {
                return t1.greaterThan(t2);
            }
            case ">=": {
                return t1.greaterOrEqual(t2);
            }
            case "<": {
                return t1.lessThan(t2);
            }
            case "<=": {
                return t1.lessOrEqual(t2);
            }
            case "a": {
                return t1.greaterThan(t2);
            }
            case "b": {
                return t1.lessThan(t2);
            }
            case "c": {
                throw new UnsupportedOperationException("First parameter of contains must be an interval.");
            }
            case "m": {
                return t1.equal(t2);
            }
            case "o": {
                return t1.equal(t2);
            }
            case "s": {
                return t1.equal(t2);
            }
            case "f": {
                return t1.equal(t2);
            }
        }
        throw new UnsupportedOperationException("Unknown boolean operation: " + op);
    }

    private Condition specificOpBool(String op, StaTimeIntervalWrapper other) {
        Field<Moment> t1 = this.field;
        Field<Moment> s2 = other.getStart();
        Field<Moment> e2 = other.getEnd();
        switch (op) {
            case "=": {
                return t1.equal(s2).and(t1.equal(e2));
            }
            case "!=": {
                return t1.notEqual(s2).and(t1.notEqual(e2));
            }
            case ">": {
                return t1.greaterOrEqual(e2).and(t1.greaterThan(s2));
            }
            case ">=": {
                return t1.greaterOrEqual(e2);
            }
            case "<": {
                return t1.lessThan(s2);
            }
            case "<=": {
                return t1.lessOrEqual(s2);
            }
            case "a": {
                return t1.greaterOrEqual(e2).and(t1.greaterThan(s2));
            }
            case "b": {
                return t1.lessThan(s2);
            }
            case "c": {
                throw new UnsupportedOperationException("First parameter of contains must be an interval.");
            }
            case "m": {
                return t1.equal(s2).or(t1.equal(e2));
            }
            case "o": {
                return t1.equal(s2).or(s2.lessOrEqual(t1).and(e2.greaterThan(t1)));
            }
            case "s": {
                return t1.equal(s2);
            }
            case "f": {
                return t1.equal(e2);
            }
        }
        throw new UnsupportedOperationException("Unknown boolean operation: " + op);
    }

    @Override
    public FieldWrapper simpleOpBool(String op, FieldWrapper other) {
        if (other instanceof StaDateTimeWrapper) {
            StaDateTimeWrapper staDateTimeWrapper = (StaDateTimeWrapper)other;
            return new SimpleFieldWrapper(this.specificOpBool(op, staDateTimeWrapper));
        }
        if (other instanceof StaTimeIntervalWrapper) {
            StaTimeIntervalWrapper staTimeIntervalWrapper = (StaTimeIntervalWrapper)other;
            return new SimpleFieldWrapper(this.specificOpBool(op, staTimeIntervalWrapper));
        }
        throw new UnsupportedOperationException("Can not compare between Duration and " + other.getClass().getName());
    }
}

