/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper;

import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.bindings.JsonValue;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper.FieldWrapper;
import java.sql.Date;
import java.util.UUID;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFieldWrapper
implements FieldWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleFieldWrapper.class.getName());
    private final Field field;
    private final Condition condition;

    public SimpleFieldWrapper(Field field) {
        this.field = field;
        this.condition = null;
    }

    public SimpleFieldWrapper(Condition condition) {
        this.field = DSL.field(condition);
        this.condition = condition;
    }

    @Override
    public boolean isCondition() {
        return this.condition != null;
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }

    @Override
    public Field getDefaultField() {
        return this.field;
    }

    @Override
    public <T> Field<T> getFieldAsType(Class<T> expectedClazz, boolean canCast) {
        Field defaultField = this.getDefaultField();
        Class fieldType = defaultField.getType();
        if (expectedClazz.isAssignableFrom(fieldType)) {
            return defaultField;
        }
        if (canCast && expectedClazz == String.class && (Number.class.isAssignableFrom(fieldType) || UUID.class.isAssignableFrom(fieldType) || JsonValue.class.isAssignableFrom(fieldType))) {
            return defaultField.cast(String.class);
        }
        if (canCast && expectedClazz == Date.class) {
            return defaultField.cast(Date.class);
        }
        if (canCast && expectedClazz == Integer.class && Number.class.isAssignableFrom(expectedClazz)) {
            return defaultField.cast(expectedClazz);
        }
        LOGGER.trace("Not a {}: {} ({} -- {})", expectedClazz.getName(), defaultField, defaultField.getClass().getName(), fieldType.getName());
        return null;
    }

    public String toString() {
        return this.getClass().getName() + " Field: " + this.field + " Condition: " + this.condition;
    }
}

