/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper;

import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper.FieldListWrapper;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper.FieldWrapper;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper.SimpleFieldWrapper;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper.StringCastHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.impl.DSL;

public class JsonFieldFactory {
    public static final String KEY_JSONB = "j";
    public static final String KEY_NUMBER = "n";
    public static final String KEY_STRING = "s";
    public static final String KEY_BOOLEAN = "b";

    public static class JsonFieldWrapper
    extends FieldListWrapper {
        private final Field<String> wrappedField;
        private final List<String> path = new ArrayList<String>();
        private final Map<String, Field> expressions = this.getExpressions();
        private final Map<String, Field> expressionsForOrder = this.getExpressionsForOrder();
        Field<Object> jsonExpression;

        public JsonFieldWrapper(Field<String> wrappedField) {
            super(new HashMap<String, Field>(), new HashMap<String, Field>());
            this.wrappedField = wrappedField;
        }

        public JsonFieldWrapper(FieldWrapper fieldWrapper) {
            this(fieldWrapper.getDefaultField());
        }

        public JsonFieldWrapper addToPath(String key) {
            this.path.add(key);
            return this;
        }

        public JsonFieldWrapper materialise() {
            if (this.jsonExpression != null) {
                return this;
            }
            StringBuilder templateCore = new StringBuilder();
            boolean firstDone = false;
            for (String key : this.path) {
                if (firstDone) {
                    templateCore.append(",");
                } else {
                    firstDone = true;
                }
                templateCore.append(key);
            }
            String templateCoreString = templateCore.toString();
            String templateJsonb = "?::jsonb#>'{ " + templateCoreString + " }'";
            String templateString = "?::jsonb#>>'{ " + templateCoreString + " }'";
            String templateNumber = "safe_cast_to_numeric(?::jsonb#>'{ " + templateCoreString + " }')";
            String templateBoolean = "safe_cast_to_boolean(?::jsonb#>'{ " + templateCoreString + " }')";
            this.expressions.put(JsonFieldFactory.KEY_STRING, DSL.field(templateString, String.class, this.wrappedField));
            this.expressions.put(JsonFieldFactory.KEY_NUMBER, DSL.field(templateNumber, Double.class, this.wrappedField));
            this.expressions.put(JsonFieldFactory.KEY_BOOLEAN, DSL.field(templateBoolean, Boolean.class, this.wrappedField));
            this.jsonExpression = DSL.field(templateJsonb, Object.class, this.wrappedField);
            this.expressions.put(JsonFieldFactory.KEY_JSONB, this.jsonExpression);
            this.expressionsForOrder.put(JsonFieldFactory.KEY_JSONB, this.jsonExpression);
            return this;
        }

        public Field<Object> getJsonExpression() {
            this.materialise();
            return this.jsonExpression;
        }

        @Override
        public Field getDefaultField() {
            this.materialise();
            return this.getExpression(JsonFieldFactory.KEY_STRING);
        }

        @Override
        public <T> Field<T> getFieldAsType(Class<T> expectedClazz, boolean canCast) {
            this.materialise();
            return super.getFieldAsType(expectedClazz, canCast);
        }

        public Field<Object> otherToJson(FieldWrapper other) {
            this.materialise();
            return this.otherToJson(other.getDefaultField());
        }

        public Field<Object> otherToJson(Field<?> other) {
            this.materialise();
            return DSL.field("to_jsonb(?)", Object.class, other);
        }

        public FieldWrapper eq(FieldWrapper other) {
            this.materialise();
            CompareType type = this.getOtherType(other);
            switch (type) {
                case BOOLEAN: 
                case NUMBER: {
                    return new SimpleFieldWrapper(this.jsonExpression.eq(this.otherToJson(other)));
                }
            }
            return new SimpleFieldWrapper(this.getExpression(JsonFieldFactory.KEY_STRING).eq(StringCastHelper.build(other)));
        }

        public FieldWrapper ne(FieldWrapper other) {
            this.materialise();
            return new SimpleFieldWrapper(this.jsonExpression.ne(this.otherToJson(other)));
        }

        public FieldWrapper lt(FieldWrapper other) {
            this.materialise();
            CompareType type = this.getOtherType(other);
            switch (type) {
                case BOOLEAN: 
                case NUMBER: {
                    return new SimpleFieldWrapper(this.jsonExpression.lessThan(this.otherToJson(other)).and(this.createTypePredicate(type)));
                }
            }
            return new SimpleFieldWrapper(this.getExpression(JsonFieldFactory.KEY_STRING).lessThan(StringCastHelper.build(other)));
        }

        public FieldWrapper loe(FieldWrapper other) {
            this.materialise();
            CompareType type = this.getOtherType(other);
            switch (type) {
                case BOOLEAN: 
                case NUMBER: {
                    return new SimpleFieldWrapper(this.jsonExpression.lessOrEqual(this.otherToJson(other)).and(this.createTypePredicate(type)));
                }
            }
            return new SimpleFieldWrapper(this.getExpression(JsonFieldFactory.KEY_STRING).lessOrEqual(StringCastHelper.build(other)));
        }

        public FieldWrapper gt(FieldWrapper other) {
            this.materialise();
            CompareType type = this.getOtherType(other);
            switch (type) {
                case BOOLEAN: 
                case NUMBER: {
                    return new SimpleFieldWrapper(this.jsonExpression.gt(this.otherToJson(other)).and(this.createTypePredicate(type)));
                }
            }
            return new SimpleFieldWrapper(this.getExpression(JsonFieldFactory.KEY_STRING).gt(StringCastHelper.build(other)));
        }

        public FieldWrapper goe(FieldWrapper other) {
            this.materialise();
            CompareType type = this.getOtherType(other);
            switch (type) {
                case BOOLEAN: 
                case NUMBER: {
                    return new SimpleFieldWrapper(this.jsonExpression.greaterOrEqual(this.otherToJson(other)).and(this.createTypePredicate(type)));
                }
            }
            return new SimpleFieldWrapper(this.getExpression(JsonFieldFactory.KEY_STRING).greaterOrEqual(StringCastHelper.build(other)));
        }

        public FieldWrapper contains(Field item) {
            String template = "? @> to_jsonb(?)";
            Condition result = DSL.condition(template, this.jsonExpression, item);
            return new SimpleFieldWrapper(result);
        }

        private CompareType getOtherType(FieldWrapper other) {
            this.materialise();
            if (other instanceof JsonFieldWrapper) {
                return CompareType.JSON;
            }
            return this.getOtherType(other.getDefaultField());
        }

        private CompareType getOtherType(Field<?> other) {
            this.materialise();
            if (Number.class.isAssignableFrom(other.getType())) {
                return CompareType.NUMBER;
            }
            if (Boolean.class.isAssignableFrom(other.getType())) {
                return CompareType.BOOLEAN;
            }
            return CompareType.STRING;
        }

        private Condition createTypePredicate(CompareType other) {
            this.materialise();
            switch (other) {
                case NUMBER: {
                    return DSL.field("jsonb_typeof(?)", this.jsonExpression).eq("number");
                }
                case BOOLEAN: {
                    return DSL.field("jsonb_typeof(?)", this.jsonExpression).eq("boolean");
                }
            }
            return null;
        }
    }

    private static enum CompareType {
        NUMBER,
        BOOLEAN,
        STRING,
        JSON;

    }
}

