/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.fraunhofer.iosb.ilt.frostserver.json.serialize.GeoJsonSerializer;
import de.fraunhofer.iosb.ilt.frostserver.model.DefaultEntity;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.PkValue;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeInstant;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeInterval;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeValue;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.JooqPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.bindings.JsonValue;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.TableCollection;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.Utils;
import de.fraunhofer.iosb.ilt.frostserver.service.UpdateMode;
import de.fraunhofer.iosb.ilt.frostserver.util.SimpleJsonMapper;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncompleteEntityException;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.NoSuchEntityException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.time4j.Moment;
import net.time4j.range.MomentInterval;
import org.geojson.Crs;
import org.geojson.Feature;
import org.geojson.GeoJsonObject;
import org.geojson.jackson.CrsType;
import org.geolatte.common.dataformats.json.jackson.JsonException;
import org.geolatte.geom.Geometry;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityFactories {
    public static final String CAN_NOT_BE_NULL = " can not be null.";
    public static final String CHANGED_MULTIPLE_ROWS = "Update changed multiple rows.";
    public static final String NO_ID_OR_NOT_FOUND = " with no id or non existing.";
    public static final String CREATED_HL = "Created historicalLocation {}";
    public static final String LINKED_L_TO_HL = "Linked location {} to historicalLocation {}.";
    public static final String UNLINKED_L_FROM_T = "Unlinked {} locations from Thing {}.";
    public static final String LINKED_L_TO_T = "Linked Location {} to Thing {}.";
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityFactories.class);
    private static final Field NULL_FIELD = DSL.field("null", Object.class);
    private static ObjectMapper formatter;
    private final ModelRegistry modelRegistry;
    private final TableCollection tableCollection;

    public EntityFactories(ModelRegistry modelRegistry, TableCollection tableCollection) {
        this.modelRegistry = modelRegistry;
        this.tableCollection = tableCollection;
    }

    public ModelRegistry getModelRegistry() {
        return this.modelRegistry;
    }

    public TableCollection getTableCollection() {
        return this.tableCollection;
    }

    public static Entity entityFromId(EntityType entityType, Record tuple, List<Field> path) {
        int pkSize = entityType.getPrimaryKey().size();
        PkValue pk = new PkValue(pkSize);
        for (int idx = 0; idx < pkSize; ++idx) {
            pk.set(idx, Utils.getFieldOrNull(tuple, path.get(idx)));
        }
        return EntityFactories.entityFromId(entityType, pk);
    }

    public static Entity entityFromId(EntityType entityType, PkValue idValues) {
        if (idValues == null) {
            return null;
        }
        return new DefaultEntity(entityType, idValues);
    }

    public void insertUserDefinedId(JooqPersistenceManager pm, Map<Field, Object> clause, List<Field> idFields, Entity entity) throws IncompleteEntityException {
        if (pm.useClientSuppliedId(entity)) {
            pm.modifyClientSuppliedId(entity);
            PkValue pkValues = entity.getPrimaryKeyValues();
            for (int i = 0; i < idFields.size(); ++i) {
                Field idField = idFields.get(i);
                Object idValue = pkValues.get(i);
                clause.put(idField, idValue);
            }
        }
    }

    public void entityExistsOrCreate(JooqPersistenceManager pm, Entity e, UpdateMode updateMode) throws NoSuchEntityException, IncompleteEntityException {
        if (e == null) {
            throw new NoSuchEntityException("No entity!");
        }
        if (!e.primaryKeyFullySet()) {
            e.validateCreate();
            pm.insert(e, updateMode);
            return;
        }
        if (this.entityExists(pm, e, true)) {
            return;
        }
        try {
            e.validateCreate();
        }
        catch (IncompleteEntityException exc) {
            throw new NoSuchEntityException("No such entity '" + e.getEntityType() + "' with id " + e.getPrimaryKeyValues());
        }
        pm.insert(e, updateMode);
    }

    public boolean entityExists(JooqPersistenceManager pm, EntityType type, PkValue entityId, boolean admin) {
        StaMainTable<?> table = this.tableCollection.getTableForType(type);
        if (!admin) {
            table = table.asSecure("t", pm);
        }
        List<Field> pkFields = table.getPkFields();
        Condition where = pkFields.get(0).eq(entityId.get(0));
        int size = entityId.size();
        for (int i = 1; i < size; ++i) {
            where = where.and(pkFields.get(i).eq(entityId.get(i)));
        }
        DSLContext dslContext = pm.getDslContext();
        Integer count = (Integer)((Record1)dslContext.selectCount().from((TableLike<?>)table).where(where).fetchOne()).component1();
        if (count > 1) {
            LOGGER.error("More than one instance of {} with id {}.", (Object)type, (Object)entityId);
        }
        return count > 0;
    }

    public boolean entityExists(JooqPersistenceManager pm, Entity e, boolean admin) {
        if (e == null || !e.primaryKeyFullySet()) {
            return false;
        }
        return this.entityExists(pm, e.getEntityType(), e.getPrimaryKeyValues(), admin);
    }

    public static void insertTimeValue(Map<Field, Object> clause, Field<Moment> startField, Field<Moment> endField, TimeValue time) {
        if (time == null) {
            clause.put(endField, null);
            clause.put(startField, null);
        } else if (time.isInstant()) {
            TimeInstant timeInstant = time.getInstant();
            EntityFactories.insertTimeInstant(clause, endField, timeInstant);
            EntityFactories.insertTimeInstant(clause, startField, timeInstant);
        } else if (time.isInterval()) {
            TimeInterval timeInterval = time.getInterval();
            EntityFactories.insertTimeInterval(clause, startField, endField, timeInterval);
        }
    }

    public static void insertTimeInstant(Map<Field, Object> clause, Field<Moment> field, TimeInstant time) {
        if (time == null) {
            clause.put(field, null);
        } else {
            clause.put(field, time.getDateTime());
        }
    }

    public static void insertTimeInterval(Map<Field, Object> clause, Field<Moment> startField, Field<Moment> endField, TimeInterval time) {
        if (time == null) {
            clause.put(startField, null);
            clause.put(endField, null);
        } else {
            MomentInterval interval = time.getInterval();
            clause.put(startField, interval.getStartAsMoment());
            clause.put(endField, interval.getEndAsMoment());
        }
    }

    public static void insertGeometry(Map<Field, Object> clause, Field<String> locationPath, Field<? extends Object> geomPath, String encodingType, Object location) {
        if (location == null) {
            return;
        }
        if (!(location instanceof JsonNode)) {
            throw new IllegalArgumentException("Unknown location object type: " + location.getClass());
        }
        JsonNode jn = (JsonNode)location;
        EntityFactories.insertGeometry(clause, locationPath, geomPath, encodingType, jn, true);
    }

    public static void insertGeometry(Map<Field, Object> clause, Field<String> locationPath, Field<? extends Object> geomPath, String encodingType, Object location, boolean flatten) {
        if (location == null) {
            return;
        }
        if (!(location instanceof JsonNode)) {
            throw new IllegalArgumentException("Unknown location object type: " + location.getClass());
        }
        JsonNode jn = (JsonNode)location;
        EntityFactories.insertGeometry(clause, locationPath, geomPath, encodingType, jn, flatten);
    }

    public static void insertGeometry(Map<Field, Object> clause, Field<String> locationPath, Field<? extends Object> geomPath, String encodingType, JsonNode location, boolean flatten) {
        Object locationParsed = Utils.locationFromEncoding(encodingType, location);
        if (locationParsed instanceof GeoJsonObject) {
            GeoJsonObject locationGeoJson = (GeoJsonObject)locationParsed;
            EntityFactories.insertGeoJson(clause, geomPath, locationPath, location, locationGeoJson, flatten);
            return;
        }
        String json = EntityFactories.objectToJson(location);
        clause.put(geomPath, NULL_FIELD);
        if (locationPath != null) {
            clause.put(locationPath, json);
        }
    }

    private static void insertGeoJson(Map<Field, Object> clause, Field<? extends Object> geomPath, Field<String> locationPath, JsonNode locationSource, GeoJsonObject locationParsed, boolean flatten) {
        String geoJson;
        GeoJsonObject geoJsonObject;
        Crs crs;
        GeoJsonObject geoLocation = locationParsed;
        if (locationParsed instanceof Feature) {
            Feature feature = (Feature)locationParsed;
            geoLocation = feature.getGeometry();
        }
        if (geoLocation instanceof GeoJsonObject && (crs = (geoJsonObject = geoLocation).getCrs()) == null) {
            crs = new Crs();
            crs.setType(CrsType.name);
            crs.getProperties().put("name", "EPSG:4326");
            geoJsonObject.setCrs(crs);
        }
        try {
            geoJson = new GeoJsonSerializer().serialize(geoLocation);
        }
        catch (JsonProcessingException ex) {
            LOGGER.error("Failed to store.", ex);
            throw new IllegalArgumentException("encoding specifies geoJson, but location not parsable as such.");
        }
        try {
            Utils.getGeoJsonMapper().fromJson(geoJson, Geometry.class);
        }
        catch (JsonException ex) {
            throw new IllegalArgumentException("Invalid geoJson: " + ex.getMessage());
        }
        String template = flatten ? "ST_Force2D(ST_Transform(ST_GeomFromGeoJSON({0}), 4326))" : "ST_GeomFromGeoJSON({0})";
        clause.put(geomPath, DSL.field(template, Object.class, geoJson));
        if (locationPath != null) {
            clause.put(locationPath, EntityFactories.objectToJson(locationSource));
        }
    }

    public static String objectToJson(JsonValue jsonValue) {
        return EntityFactories.objectToJson(jsonValue.getValue());
    }

    public static String objectToJson(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return EntityFactories.getFormatter().writeValueAsString(object);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not serialise object.", ex);
        }
    }

    public static ObjectMapper getFormatter() {
        if (formatter == null) {
            formatter = SimpleJsonMapper.getSimpleObjectMapper();
        }
        return formatter;
    }
}

