/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.bindings;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Timestamp;
import net.time4j.Moment;
import net.time4j.sql.JDBCAdapter;
import org.jooq.Binding;
import org.jooq.BindingGetResultSetContext;
import org.jooq.BindingGetSQLInputContext;
import org.jooq.BindingGetStatementContext;
import org.jooq.BindingRegisterContext;
import org.jooq.BindingSQLContext;
import org.jooq.BindingSetSQLOutputContext;
import org.jooq.BindingSetStatementContext;
import org.jooq.Converter;
import org.jooq.DataType;
import org.jooq.conf.ParamType;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public class MomentBinding
implements Binding<Timestamp, Moment> {
    private static final MomentBinding INSTANCE = new MomentBinding();
    private static final Converter<Timestamp, Moment> CONVERTER_INSTANCE = new Converter<Timestamp, Moment>(){

        @Override
        public Moment from(Timestamp databaseObject) {
            if (databaseObject == null) {
                return null;
            }
            return (Moment)JDBCAdapter.SQL_TIMESTAMP_WITH_ZONE.translate(databaseObject);
        }

        @Override
        public Timestamp to(Moment userObject) {
            if (userObject == null) {
                return null;
            }
            return (Timestamp)JDBCAdapter.SQL_TIMESTAMP_WITH_ZONE.from(userObject);
        }

        @Override
        public Class<Timestamp> fromType() {
            return Timestamp.class;
        }

        @Override
        public Class<Moment> toType() {
            return Moment.class;
        }
    };
    private static final DataType<Moment> DATA_TYPE = SQLDataType.TIMESTAMP.asConvertedDataType(INSTANCE);

    public static MomentBinding instance() {
        return INSTANCE;
    }

    public static DataType<Moment> dataType() {
        return DATA_TYPE;
    }

    private MomentBinding() {
    }

    @Override
    public Converter<Timestamp, Moment> converter() {
        return CONVERTER_INSTANCE;
    }

    @Override
    public void sql(BindingSQLContext<Moment> ctx) throws SQLException {
        if (ctx.render().paramType() == ParamType.INLINED) {
            ctx.render().visit(DSL.inline(ctx.convert(this.converter()).value()));
        } else {
            ctx.render().sql(ctx.variable());
        }
    }

    @Override
    public void register(BindingRegisterContext<Moment> ctx) throws SQLException {
        ctx.statement().registerOutParameter(ctx.index(), 2014);
    }

    @Override
    public void set(BindingSetStatementContext<Moment> ctx) throws SQLException {
        ctx.statement().setTimestamp(ctx.index(), ctx.convert(this.converter()).value());
    }

    @Override
    public void get(BindingGetResultSetContext<Moment> ctx) throws SQLException {
        ctx.convert(this.converter()).value(ctx.resultSet().getTimestamp(ctx.index()));
    }

    @Override
    public void get(BindingGetStatementContext<Moment> ctx) throws SQLException {
        ctx.convert(this.converter()).value(ctx.statement().getTimestamp(ctx.index()));
    }

    @Override
    public void set(BindingSetSQLOutputContext<Moment> ctx) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void get(BindingGetSQLInputContext<Moment> ctx) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

