/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.PkValue;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElement;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementArrayIndex;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementCustomProperty;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntity;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntityType;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementProperty;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePathVisitor;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.JooqPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.PgExpressionHandler;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.TableCollection;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.QueryState;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.TableRef;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.query.Expand;
import de.fraunhofer.iosb.ilt.frostserver.query.OrderBy;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.Expression;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RegExUtils;
import org.jooq.AggregateFunction;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Delete;
import org.jooq.DeleteConditionStep;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.ResultQuery;
import org.jooq.SelectConditionStep;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectIntoStep;
import org.jooq.SelectJoinStep;
import org.jooq.SelectLimitPercentStep;
import org.jooq.SelectSeekStepN;
import org.jooq.SelectSelectStep;
import org.jooq.SelectWithTiesAfterOffsetStep;
import org.jooq.TableLike;
import org.jooq.conf.ParamType;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryBuilder
implements ResourcePathVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryBuilder.class);
    private static final String GENERATED_SQL = "Generated SQL:\n{}";
    private static final String TABLESAMPLE_REPLACE_REGEX = "$1 tablesample system (1)";
    private static final String TABLE_SEARCH_REGEX = "(\"[A-Za-z0-9_-]+\" as \"[A-Za-z0-9]+\")";
    private static final Pattern TABLE_SEARCH_PATTERN = Pattern.compile("(\"[A-Za-z0-9_-]+\" as \"[A-Za-z0-9]+\")");
    public static final String ALIAS_PREFIX = "e";
    public static final String DEFAULT_PREFIX = "e0";
    private final JooqPersistenceManager pm;
    private final CoreSettings coreSettings;
    private final TableCollection tableCollection;
    private Query staQuery;
    private Set<Property> selectedProperties;
    private TableRef lastPath;
    private NavigationPropertyMain lastNavProp;
    private boolean forPath = false;
    private ResourcePath requestedPath;
    private boolean forTypeAndId = false;
    private EntityType requestedEntityType;
    private PkValue requestedId;
    private boolean forUpdate = false;
    private boolean parsed = false;
    private QueryState<?> queryState;

    public QueryBuilder(JooqPersistenceManager pm, CoreSettings coreSettings, TableCollection tableCollection) {
        this.pm = pm;
        this.coreSettings = coreSettings;
        this.tableCollection = tableCollection;
    }

    public JooqPersistenceManager getPersistenceManager() {
        return this.pm;
    }

    public QueryState<?> getQueryState() {
        return this.queryState;
    }

    public ResultQuery<Record> buildSelect() {
        int count;
        SelectIntoStep<Record> selectStep;
        this.gatherData();
        DSLContext dslContext = this.pm.getDslContext();
        if (this.staQuery != null && this.staQuery.isSelectDistinct()) {
            selectStep = dslContext.selectDistinct(this.queryState.getSqlSelectFields());
        } else if (this.queryState.isDistinctRequired()) {
            if (this.queryState.isSqlSortFieldsSet()) {
                if (this.staQuery == null || !this.staQuery.isPkOrder()) {
                    this.queryState.getSqlSortFields().addAll(this.queryState.getSqlMainIdFields());
                }
                selectStep = dslContext.select(this.queryState.getSqlSelectFields()).distinctOn(this.queryState.getSqlSortFields().getSqlSortSelectFields());
            } else {
                selectStep = dslContext.select(this.queryState.getSqlSelectFields()).distinctOn(this.queryState.getSqlMainIdFields());
            }
        } else {
            selectStep = dslContext.select(this.queryState.getSqlSelectFields());
        }
        SelectConditionStep whereStep = selectStep.from((TableLike<?>)this.queryState.getSqlFrom()).where(this.queryState.getFullSqlWhere());
        List<OrderField> sortFields = this.queryState.getSqlSortFields().getSqlSortFields();
        SelectSeekStepN orderByStep = whereStep.orderBy((OrderField[])sortFields.toArray(OrderField[]::new));
        int skip = 0;
        if (this.staQuery != null) {
            count = this.staQuery.getTopOrDefault() + 1;
            if (this.staQuery.getSkipFilter() == null) {
                skip = this.staQuery.getSkip(0);
            }
        } else {
            count = 1;
        }
        SelectWithTiesAfterOffsetStep<Record> limit = orderByStep.limit((Number)skip, (Number)count);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(GENERATED_SQL, (Object)limit.getSQL(ParamType.INDEXED));
        }
        if (this.forUpdate) {
            return limit.forUpdate();
        }
        return limit;
    }

    public ResultQuery<Record1<Integer>> buildCount() {
        AggregateFunction<Integer> count;
        this.gatherData();
        DSLContext dslContext = this.pm.getDslContext();
        if (this.staQuery != null && this.staQuery.isSelectDistinct()) {
            Set<Field> sqlSelectFields = this.queryState.getSqlSelectFields();
            count = DSL.countDistinct((Field[])sqlSelectFields.toArray(Field[]::new));
        } else if (this.queryState.isDistinctRequired()) {
            sqlMainIdFields = this.queryState.getSqlMainIdFields();
            count = DSL.countDistinct((Field[])sqlMainIdFields.toArray(Field[]::new));
        } else {
            sqlMainIdFields = this.queryState.getSqlMainIdFields();
            count = sqlMainIdFields.size() > 1 ? DSL.count() : DSL.count(sqlMainIdFields.get(0));
        }
        SelectConditionStep<Record1<Integer>> query = dslContext.select(count).from((TableLike<?>)this.queryState.getSqlFrom()).where(this.queryState.getSqlWhere());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(GENERATED_SQL, (Object)query.getSQL(ParamType.INDEXED));
        }
        return query;
    }

    public ResultQuery<Record1<Integer>> buildCount(int limit) {
        SelectSelectStep<Record> subSelect;
        this.gatherData();
        DSLContext dslContext = this.pm.getDslContext();
        if (this.staQuery != null && this.staQuery.isSelectDistinct()) {
            Set<Field> sqlSelectFields = this.queryState.getSqlSelectFields();
            subSelect = DSL.selectDistinct((SelectFieldOrAsterisk[])sqlSelectFields.toArray(Field[]::new));
        } else {
            subSelect = this.queryState.isDistinctRequired() ? DSL.selectDistinct(this.queryState.getSqlMainIdFields()) : DSL.select(this.queryState.getSqlMainIdFields());
        }
        SelectLimitPercentStep selectFromWhere = subSelect.from((TableLike<?>)this.queryState.getSqlFrom()).where(this.queryState.getSqlWhere()).limit(limit);
        SelectJoinStep<Record1<Integer>> query = dslContext.selectCount().from((TableLike<?>)selectFromWhere);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(GENERATED_SQL, (Object)query.getSQL(ParamType.INDEXED));
        }
        return query;
    }

    public CountSampleResult buildEstimateCountSample() {
        ResultQuery<Record1<Integer>> baseQuery = this.buildCount();
        String queryString = baseQuery.getSQL(ParamType.INLINED);
        String extendedQuery = RegExUtils.replaceFirst(queryString, TABLE_SEARCH_PATTERN, TABLESAMPLE_REPLACE_REGEX);
        int replaces = (extendedQuery.length() - queryString.length()) / " tablesample system (1)".length();
        DSLContext dslContext = this.pm.getDslContext();
        ResultQuery<Record> query = dslContext.resultQuery(extendedQuery);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(GENERATED_SQL, (Object)extendedQuery);
        }
        return new CountSampleResult(query, replaces);
    }

    public ResultQuery<Record1<Integer>> buildEstimateCountExplain() {
        SelectSelectStep<Record> select;
        this.gatherData();
        DSLContext dslContext = this.pm.getDslContext();
        if (this.staQuery != null && this.staQuery.isSelectDistinct()) {
            Set<Field> sqlSelectFields = this.queryState.getSqlSelectFields();
            select = dslContext.selectDistinct((SelectFieldOrAsterisk[])sqlSelectFields.toArray(Field[]::new));
        } else {
            select = this.queryState.isDistinctRequired() ? dslContext.selectDistinct(this.queryState.getSqlMainIdFields()) : dslContext.select(this.queryState.getSqlMainIdFields());
        }
        String selectQuery = select.from((TableLike<?>)this.queryState.getSqlFrom()).where(this.queryState.getSqlWhere()).getSQL(ParamType.INLINED);
        Field<Integer> countField = DSL.field("count_estimate({0})", SQLDataType.INTEGER, selectQuery);
        SelectSelectStep<Record1<Integer>> countQuery = dslContext.select(countField);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(GENERATED_SQL, (Object)countQuery.getSQL(ParamType.INDEXED));
        }
        return countQuery;
    }

    public Delete buildDelete(PathElementEntitySet set) {
        this.gatherData();
        DSLContext dslContext = this.pm.getDslContext();
        StaMainTable<?> table = this.tableCollection.getTablesByType().get(set.getEntityType());
        if (table == null) {
            throw new AssertionError("Don't know how to delete" + set.getEntityType().entityName, new IllegalArgumentException("Unknown type for delete"));
        }
        List<Field> sqlMainIdFields = this.queryState.getSqlMainIdFields();
        SelectConditionStep idSelect = DSL.select(sqlMainIdFields).from((TableLike<?>)this.queryState.getSqlFrom()).where(this.queryState.getSqlWhere());
        DeleteConditionStep delete = dslContext.deleteFrom(table).where(DSL.row(table.getPkFields()).in(idSelect));
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(GENERATED_SQL, (Object)delete.getSQL(ParamType.INDEXED));
        }
        return delete;
    }

    public QueryBuilder forTypeAndId(EntityType entityType, PkValue id) {
        if (this.forPath || this.forTypeAndId) {
            throw new IllegalStateException("QueryBuilder already used.");
        }
        this.forTypeAndId = true;
        this.requestedEntityType = entityType;
        this.requestedId = id;
        return this;
    }

    public QueryBuilder forPath(ResourcePath path) {
        if (this.forPath || this.forTypeAndId) {
            throw new IllegalStateException("QueryBuilder already used.");
        }
        this.forPath = true;
        this.requestedPath = path;
        this.requestedEntityType = path.getMainElementType();
        return this;
    }

    public QueryBuilder forUpdate(boolean forUpdate) {
        this.forUpdate = forUpdate;
        return this;
    }

    public QueryBuilder usingQuery(Query query) {
        this.staQuery = query;
        return this;
    }

    private void gatherData() {
        if (!this.parsed) {
            this.parsed = true;
            this.selectedProperties = this.findSelectedProperties(this.staQuery);
            if (this.forPath) {
                this.parsePath();
            }
            if (this.forTypeAndId) {
                this.parseTypeAndId();
            }
            this.queryState.getTableRef().clearJoins();
            this.handleEntityExpands(this.staQuery, this.queryState);
            this.parseFilter(this.staQuery);
            this.parseOrder(this.staQuery);
        }
    }

    private void parsePath() {
        int count = this.requestedPath.size();
        for (int i = count - 1; i >= 0; --i) {
            PathElement element = this.requestedPath.get(i);
            element.visit(this);
        }
    }

    private void parseTypeAndId() {
        this.lastPath = this.queryEntityType(new PathElementEntity(this.requestedEntityType, null), this.requestedId, this.lastPath);
    }

    private Set<Property> findSelectedProperties(Query query) {
        HashSet<Property> foundProperties = new HashSet<Property>();
        if (query == null) {
            return foundProperties;
        }
        for (Property property : query.getSelect()) {
            if (property instanceof NavigationPropertyMain) {
                foundProperties.addAll(this.requestedEntityType.getPrimaryKey().getKeyProperties());
            }
            foundProperties.add(property);
        }
        if (query.isPkOrder() && !query.isSelectDistinct() && !foundProperties.isEmpty()) {
            foundProperties.addAll(this.requestedEntityType.getPrimaryKey().getKeyProperties());
        }
        if (!query.getExpand().isEmpty() && !foundProperties.isEmpty()) {
            foundProperties.addAll(this.requestedEntityType.getPrimaryKey().getKeyProperties());
            for (Expand expand : query.getExpand()) {
                NavigationProperty expandPath = expand.getPath();
                if (expandPath == null) continue;
                foundProperties.add(expandPath);
            }
        }
        return foundProperties;
    }

    private void handleEntityExpands(Query staQuery, QueryState sqlState) {
        if (staQuery == null) {
            return;
        }
        for (Expand expand : staQuery.getExpand()) {
            NavigationProperty expandPath = expand.getPath();
            if (!(expandPath instanceof NavigationPropertyMain.NavigationPropertyEntity)) continue;
            NavigationPropertyMain.NavigationPropertyEntity navPropEntity = (NavigationPropertyMain.NavigationPropertyEntity)expandPath;
            this.handleEntityExpand(sqlState, expand, navPropEntity);
        }
    }

    private void handleEntityExpand(QueryState sqlState, Expand expand, NavigationPropertyMain.NavigationPropertyEntity navPropEntity) {
        Query subQuery = expand.getSubQuery();
        TableRef tableRef = sqlState.getTableRef();
        TableRef joinRef = tableRef.createJoin(navPropEntity.getName(), this.queryState);
        tableRef.addJoin(navPropEntity, joinRef);
        StaMainTable<?> joinedTable = joinRef.getTable();
        QueryState subState = new QueryState(joinedTable, sqlState, sqlState.getNextAlias());
        Set<Property> subProperties = this.findSelectedProperties(subQuery);
        subState.setSelectedProperties(joinedTable.getPropertyFieldRegistry().getFieldsForProperties(subProperties));
        sqlState.addChildState(navPropEntity, subState);
        this.handleEntityExpands(subQuery, subState);
    }

    private void parseOrder(Query query) {
        if (query != null) {
            PgExpressionHandler handler = new PgExpressionHandler(this.coreSettings, this);
            for (OrderBy ob : query.getOrderBy()) {
                handler.addOrderbyToQuery(ob, this.queryState.getSqlSortFields());
            }
        }
    }

    public void parseFilter(Query query) {
        if (query != null) {
            this.queryState.setFilter(true);
            Expression filter = query.getFilter();
            Expression skipFilter = query.getSkipFilter();
            PgExpressionHandler handler = new PgExpressionHandler(this.coreSettings, this);
            if (filter != null) {
                this.queryState.setSqlWhere(handler.addFilterToWhere(filter, this.queryState.getSqlWhere()));
            }
            if (skipFilter != null) {
                this.queryState.setSqlSkipWhere(handler.addFilterToWhere(skipFilter, this.queryState.getSqlSkipWhere()));
            }
        }
    }

    @Override
    public void visit(PathElementEntity element) {
        this.lastPath = this.queryEntityType(element, element.getPkValues(), this.lastPath);
    }

    @Override
    public void visit(PathElementEntitySet element) {
        this.lastPath = this.queryEntityType(element, null, this.lastPath);
    }

    @Override
    public void visit(PathElementProperty element) {
        this.selectedProperties.add(element.getProperty());
    }

    @Override
    public void visit(PathElementCustomProperty element) {
    }

    @Override
    public void visit(PathElementArrayIndex element) {
    }

    private TableRef queryEntityType(PathElementEntityType pe, PkValue targetId, TableRef last) {
        TableRef result;
        EntityType entityType = pe.getEntityType();
        if (last == null) {
            StaMainTable<?> tableForType = this.tableCollection.getTableForType(entityType).asSecure(DEFAULT_PREFIX, this.pm);
            this.queryState = new QueryState(this.pm, tableForType, tableForType.getPropertyFieldRegistry().getFieldsForProperties(this.selectedProperties));
            result = this.queryState.getTableRef();
        } else {
            TableRef existingJoin = last.getJoin(pe.getNavigationProperty());
            if (existingJoin != null) {
                return existingJoin;
            }
            result = entityType.equals(last.getType()) && this.lastNavProp == null ? last : last.createJoin(this.lastNavProp.getInverse().getName(), this.queryState);
        }
        if (targetId != null) {
            List<Field> lastId = result.getTable().getPkFields();
            result.getJoinEqual(lastId);
            Condition where = lastId.get(0).eq(targetId.get(0));
            for (int idx = 1; idx < lastId.size(); ++idx) {
                where = where.and(lastId.get(idx).eq(targetId.get(idx)));
            }
            this.queryState.setSqlWhere(this.queryState.getSqlWhere().and(where));
        }
        this.lastNavProp = pe.getNavigationProperty();
        return result;
    }

    public TableCollection getTableCollection() {
        return this.tableCollection;
    }

    public static TableRef createJoinedRef(TableRef base, NavigationProperty np, StaMainTable<?> table) {
        if (np.getEntityType() != table.getEntityType()) {
            throw new IllegalArgumentException("NavProp does not point to given table: " + np.getEntityType() + " != " + table.getEntityType());
        }
        TableRef newRef = new TableRef(table);
        if (base != null) {
            base.addJoin(np, newRef);
        }
        return newRef;
    }

    public static final class CountSampleResult {
        public final ResultQuery<Record> countQuery;
        public final int sampledTables;

        public CountSampleResult(ResultQuery<Record> countQuery, int sampledTables) {
            this.countQuery = countQuery;
            this.sampledTables = sampledTables;
        }
    }
}

