/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import de.fraunhofer.iosb.ilt.frostserver.json.deserialize.JsonReaderDefault;
import de.fraunhofer.iosb.ilt.frostserver.json.serialize.JsonWriter;
import de.fraunhofer.iosb.ilt.frostserver.model.CollectionsHelper;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityChangedMessage;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.PkValue;
import de.fraunhofer.iosb.ilt.frostserver.model.core.PrimaryKey;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.DefEntityProperty;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.DefEntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.DefModel;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.DefNavigationProperty;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.DefPmHook;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.PmHook;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.PropertyPersistenceMapper;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElement;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntity;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.persistence.AbstractPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.IdGenerationType;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.JooqPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.QueryBuilder;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.ResultBuilder;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories.EntityFactories;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories.HookPostDelete;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories.HookPostInsert;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories.HookPostUpdate;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories.HookPreDelete;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories.HookPreInsert;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories.HookPreUpdate;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories.JooqPmHook;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.relations.Relation;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaLinkTableDynamic;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaTableDynamic;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.TableCollection;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.ConnectionUtils;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.DataSize;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.LiquibaseHelper;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.PropertyFieldRegistry;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.fieldmapper.FieldMapper;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator.HookValidator;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.validator.SecurityTableWrapper;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.service.InitResult;
import de.fraunhofer.iosb.ilt.frostserver.service.UpdateMode;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.PersistenceSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.Settings;
import de.fraunhofer.iosb.ilt.frostserver.util.SecurityModel;
import de.fraunhofer.iosb.ilt.frostserver.util.SecurityWrapper;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncompleteEntityException;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.NoSuchEntityException;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.UpgradeFailedException;
import de.fraunhofer.iosb.ilt.frostserver.util.user.PrincipalExtended;
import java.io.IOException;
import java.io.Writer;
import java.security.Principal;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.time4j.Moment;
import net.time4j.format.expert.Iso8601Format;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Delete;
import org.jooq.Meta;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.ResultQuery;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MariadbPersistenceManager
extends AbstractPersistenceManager
implements JooqPersistenceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MariadbPersistenceManager.class.getName());
    private static final String LIQUIBASE_CHANGELOG_FILENAME = "liquibase/core.xml";
    public static final String DATETIME_MAX_INSTANT = "9999-12-30T23:59:59.999Z";
    public static final String DATETIME_MIN_INSTANT = "0001-01-02T00:00:00.000Z";
    public static final Moment DATETIME_MAX = MariadbPersistenceManager.parseMoment("9999-12-30T23:59:59.999Z");
    public static final Moment DATETIME_MIN = MariadbPersistenceManager.parseMoment("0001-01-02T00:00:00.000Z");
    private static final String SOURCE_NAME_FROST = "FROST-Source";
    private static final String ID_TYPE = "idType-";
    private static final Map<CoreSettings, TableCollection> tableCollections = new HashMap<CoreSettings, TableCollection>();
    private boolean initialised = false;
    private TableCollection tableCollection;
    private EntityFactories entityFactories;
    private CoreSettings settings;
    private PersistenceSettings persistenceSettings;
    private ConnectionUtils.ConnectionWrapper connectionProvider;
    private String connectionName;
    private DSLContext dslContext;
    private String schemaPriority;
    private final Map<Name, Table<?>> tableCache = new HashMap();
    private DataSize dataSize;

    static final Moment parseMoment(String value) {
        try {
            return Iso8601Format.EXTENDED_DATE_TIME_OFFSET.parse(value);
        }
        catch (ParseException ex) {
            LOGGER.error("Failed to parse Moment: {}", (Object)value);
            return null;
        }
    }

    private static TableCollection getTableCollection(CoreSettings settings) {
        return tableCollections.computeIfAbsent(settings, t2 -> new TableCollection().setModelRegistry(t2.getModelRegistry()));
    }

    @Override
    public InitResult init(CoreSettings settings) {
        this.settings = settings;
        this.tableCollection = MariadbPersistenceManager.getTableCollection(settings);
        this.persistenceSettings = settings.getPersistenceSettings();
        this.getTableCollection().setModelRegistry(settings.getModelRegistry());
        Settings customSettings = this.persistenceSettings.getCustomSettings();
        String connectionUrl = customSettings.get("db.url", ConnectionUtils.class);
        this.connectionName = StringHelper.isNullOrEmpty(connectionUrl) ? SOURCE_NAME_FROST : connectionUrl;
        this.connectionProvider = new ConnectionUtils.ConnectionWrapper(customSettings, this.connectionName);
        this.entityFactories = new EntityFactories(settings.getModelRegistry(), this.tableCollection);
        this.dataSize = new DataSize(settings.getDataSizeMax());
        this.schemaPriority = customSettings.get("db.schemaPriority", ConnectionUtils.class);
        return InitResult.INIT_OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (this.initialised) {
            return;
        }
        TableCollection tableCollection = this.tableCollection;
        synchronized (tableCollection) {
            if (!this.initialised) {
                if (this.tableCollection.init(this)) {
                    this.loadMapping();
                    this.validateMappings();
                }
                this.initialised = true;
            }
        }
    }

    @Override
    public CoreSettings getCoreSettings() {
        return this.settings;
    }

    @Override
    public TableCollection getTableCollection() {
        return this.tableCollection;
    }

    @Override
    public EntityFactories getEntityFactories() {
        return this.entityFactories;
    }

    @Override
    public DSLContext getDslContext() {
        if (this.dslContext == null) {
            this.dslContext = DSL.using(this.connectionProvider.get(), SQLDialect.MARIADB);
        }
        return this.dslContext;
    }

    @Override
    public ConnectionUtils.ConnectionWrapper getConnectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public boolean validatePath(ResourcePath path) {
        PathElement element;
        this.init();
        if (element == null) {
            return true;
        }
        ResourcePath tempPath = new ResourcePath();
        int idCount = 0;
        for (element = path.getIdentifiedElement(); element != null; element = element.getParent()) {
            PathElementEntity entityPathElement;
            PkValue pkValues;
            if (element instanceof PathElementEntity && (pkValues = (entityPathElement = element).getPkValues()) != null) {
                ++idCount;
                boolean userIsAdmin = PrincipalExtended.getLocalPrincipal().isAdmin();
                if (!this.entityFactories.entityExists(this, entityPathElement.getEntityType(), pkValues, userIsAdmin)) {
                    return false;
                }
            }
            tempPath.addPathElement(0, element);
        }
        if (idCount < 2) {
            return true;
        }
        QueryBuilder psb = new QueryBuilder(this, this.settings, this.getTableCollection());
        ResultQuery<Record1<Integer>> query = psb.forPath(tempPath).buildCount();
        Integer count = query.fetchOne().component1();
        return count == 1;
    }

    @Override
    public Entity get(EntityType entityType, PkValue pk) {
        return this.get(entityType, pk, false, null);
    }

    @Override
    public Entity get(EntityType entityType, PkValue pk, Query query) {
        return this.get(entityType, pk, false, query);
    }

    private Entity get(EntityType entityType, PkValue pk, boolean forUpdate, Query query) {
        this.init();
        QueryBuilder queryBuilder = new QueryBuilder(this, this.settings, this.getTableCollection());
        ResultQuery<Record> sqlQuery = queryBuilder.forTypeAndId(entityType, pk).usingQuery(query).forUpdate(forUpdate).buildSelect();
        Record result = sqlQuery.fetchAny();
        if (result == null) {
            return null;
        }
        return queryBuilder.getQueryState().entityFromRecord(result, this.dataSize, query);
    }

    @Override
    public Object get(ResourcePath path, Query query) {
        this.init();
        PathElement lastElement = path.getLastElement();
        if (!(lastElement instanceof PathElementEntity) && !(lastElement instanceof PathElementEntitySet)) {
            if (!query.getExpand().isEmpty()) {
                LOGGER.warn("Expand only allowed on Entities or EntitySets. Not on {}!", (Object)lastElement.getClass());
                query.getExpand().clear();
            }
            if (!query.getSelect().isEmpty()) {
                LOGGER.warn("Select only allowed on Entities or EntitySets. Not on {}!", (Object)lastElement.getClass());
                query.getSelect().clear();
            }
        }
        QueryBuilder queryBuilder = new QueryBuilder(this, this.settings, this.getTableCollection()).forPath(path).usingQuery(query);
        ResultBuilder entityCreator = new ResultBuilder(this, path, query, queryBuilder, this.dataSize);
        try {
            lastElement.visit(entityCreator);
        }
        catch (IllegalArgumentException ex) {
            throw new UnsupportedOperationException("Failed to convert result to entity.", ex);
        }
        Object entity = entityCreator.getEntity();
        if (entity instanceof Map) {
            Map map = (Map)entity;
            if (path.isEntityProperty() && map.get(entityCreator.getEntityName()) == null) {
                return null;
            }
            if (path.isValue()) {
                entity = map.get(entityCreator.getEntityName());
            }
        }
        return entity;
    }

    @Override
    public Entity doInsert(Entity entity, UpdateMode updateMode) throws NoSuchEntityException, IncompleteEntityException {
        this.init();
        StaMainTable<?> table = this.getTableCollection().getTableForType(entity.getEntityType());
        return table.insertIntoDatabase(this, entity, updateMode, this.dataSize);
    }

    @Override
    public EntityChangedMessage doUpdate(PathElementEntity pathElement, Entity entity, UpdateMode updateMode) throws NoSuchEntityException, IncompleteEntityException {
        this.init();
        EntityFactories ef = this.getEntityFactories();
        PkValue id = pathElement.getPkValues();
        entity.setPrimaryKeyValues(id);
        boolean userIsAdmin = PrincipalExtended.getLocalPrincipal().isAdmin();
        if (!ef.entityExists(this, entity, userIsAdmin)) {
            throw new NoSuchEntityException("No entity of type " + pathElement.getEntityType() + " with id " + id);
        }
        StaMainTable<?> table = this.getTableCollection().getTableForType(entity.getEntityType());
        return table.updateInDatabase(this, entity, id, updateMode, this.dataSize);
    }

    @Override
    public EntityChangedMessage doUpdate(PathElementEntity pathElement, JsonPatch patch) throws NoSuchEntityException, IncompleteEntityException {
        Entity newEntity;
        JsonNode newNode;
        this.init();
        EntityType entityType = pathElement.getEntityType();
        PkValue id = pathElement.getPkValues();
        Entity original = this.get(entityType, id, true, null);
        if (original == null) {
            throw new IllegalArgumentException("No Entity of type " + entityType.entityName + " with id " + id);
        }
        original.setEntityPropertiesSet(false, false);
        original.setQuery(this.settings.getModelRegistry().getMessageQueryGenerator().getQueryFor(entityType));
        Object originalNode = JsonWriter.getObjectMapper().valueToTree(original);
        LOGGER.trace("Old {}", originalNode);
        try {
            newNode = patch.apply((JsonNode)originalNode);
        }
        catch (JsonPatchException ex) {
            throw new IllegalArgumentException("Failed to apply patch.", ex);
        }
        LOGGER.trace("New {}", (Object)newNode);
        ModelRegistry modelRegistry = this.settings.getModelRegistry();
        try {
            JsonReaderDefault entityParser = new JsonReaderDefault(modelRegistry, PrincipalExtended.getLocalPrincipal());
            newEntity = entityParser.parseEntity(original.getEntityType(), newNode.toString());
            newEntity.setPrimaryKeyValues(id);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to parse JSON after patch.");
            throw new IllegalArgumentException("Exception", ex);
        }
        EntityChangedMessage message = new EntityChangedMessage();
        newEntity.setEntityPropertiesSet(original, message);
        if (message.getEpFields().isEmpty() && message.getNpFields().isEmpty()) {
            LOGGER.warn("Patch did not change anything.");
            throw new IllegalArgumentException("Patch did not change anything.");
        }
        StaMainTable<?> table = this.getTableCollection().getTableForType(entityType);
        table.updateInDatabase(this, newEntity, id, UpdateMode.UPDATE_ODATA_40, this.dataSize);
        message.setEntity(newEntity);
        message.setEventType(EntityChangedMessage.Type.UPDATE);
        return message;
    }

    @Override
    public void deleteRelation(PathElementEntity source, NavigationPropertyMain np, PathElementEntity target) throws IncompleteEntityException, NoSuchEntityException {
        if (!np.isEntitySet() && np.isRequired()) {
            throw new IncompleteEntityException("Deleting a required relation is not allowed. Delete the entity instead.");
        }
        NavigationPropertyMain inverse = np.getInverse();
        if (inverse != null && !inverse.isEntitySet() && inverse.isRequired()) {
            throw new IncompleteEntityException("Deleting a required relation is not allowed. Delete the entity instead.");
        }
        boolean userIsAdmin = PrincipalExtended.getLocalPrincipal().isAdmin();
        StaMainTable<?> sourceTable = this.getTableCollection().getTableForType(source.getEntityType());
        Relation<?> relation = sourceTable.findRelation(np.getName());
        Entity sourceEntity = EntityFactories.entityFromId(source.getEntityType(), source.getPkValues());
        if (!this.entityFactories.entityExists(this, sourceEntity, userIsAdmin)) {
            throw new NoSuchEntityException("Source entity not found: " + source.getEntityType() + "(" + source.getPkValues() + ")");
        }
        Entity targetEntity = EntityFactories.entityFromId(target.getEntityType(), target.getPkValues());
        if (!this.entityFactories.entityExists(this, targetEntity, userIsAdmin)) {
            throw new NoSuchEntityException("Source entity not found: " + target.getEntityType() + "(" + target.getPkValues() + ")");
        }
        relation.unLink(this, sourceEntity, targetEntity, np);
    }

    @Override
    public boolean doDelete(PathElementEntity pathElement) throws NoSuchEntityException {
        this.init();
        EntityType type = pathElement.getEntityType();
        StaMainTable<?> table = this.getTableCollection().getTableForType(type);
        table.delete(this, pathElement.getPkValues());
        return true;
    }

    @Override
    public void doDelete(ResourcePath path, Query query) {
        this.init();
        query.clearSelect();
        query.addSelect((Property)path.getMainElementType().getEntityProperty("id"));
        QueryBuilder psb = new QueryBuilder(this, this.settings, this.getTableCollection()).forPath(path).usingQuery(query);
        Delete sqlDelete = psb.buildDelete((PathElementEntitySet)path.getLastElement());
        long rowCount = sqlDelete.execute();
        LOGGER.debug("Deleted {} rows using query {}", (Object)rowCount, (Object)sqlDelete);
    }

    @Override
    public void setRole(Principal user) {
        if (this.settings.getPersistenceSettings().isTransactionRole()) {
            this.getDslContext().setLocal(DSL.name("ROLE"), DSL.val(user == null ? "anonymous" : user.getName())).execute();
        }
    }

    @Override
    protected boolean doCommit() {
        return this.connectionProvider.commit();
    }

    @Override
    protected boolean doRollback() {
        return this.connectionProvider.rollback();
    }

    @Override
    protected boolean doClose() {
        try {
            this.connectionProvider.close();
            return true;
        }
        catch (SQLException ex) {
            LOGGER.error("Failed to close connection.", ex);
            return false;
        }
    }

    protected boolean validateClientSuppliedId(PkValue entityId) {
        return entityId != null && entityId.isFullySet();
    }

    @Override
    public void modifyClientSuppliedId(Entity entity) {
    }

    @Override
    public boolean useClientSuppliedId(Entity entity) throws IncompleteEntityException {
        PkValue entityId = entity.getPrimaryKeyValues();
        EntityType entityType = entity.getEntityType();
        IdGenerationType typeIdGenerationMode = (IdGenerationType)((Object)entityType.getIdGenerationMode());
        switch (typeIdGenerationMode) {
            case SERVER_GENERATED_ONLY: {
                if (entityId.isFullyUnSet()) {
                    LOGGER.trace("Using server generated id.");
                    return false;
                }
                LOGGER.warn("idGenerationMode is '{}' but @iot.id '{}' is present. Ignoring @iot.id.", (Object)typeIdGenerationMode, (Object)entityId);
                return false;
            }
            case SERVER_AND_CLIENT_GENERATED: {
                if (this.validateClientSuppliedId(entityId)) break;
                LOGGER.debug("No valid @iot.id. Using server generated id.");
                return false;
            }
            case CLIENT_GENERATED_ONLY: {
                if (this.validateClientSuppliedId(entityId)) break;
                LOGGER.error("No @iot.id and idGenerationMode is '{}'", (Object)typeIdGenerationMode);
                throw new IncompleteEntityException("Error: no @iot.id");
            }
            default: {
                LOGGER.error("idGenerationMode '{}' is not implemented.", (Object)typeIdGenerationMode);
                throw new IllegalArgumentException("idGenerationMode '" + typeIdGenerationMode.toString() + "' is not implemented.");
            }
        }
        LOGGER.debug("Using client generated id.");
        return true;
    }

    @Override
    public String checkForUpgrades(String liquibaseChangelogFilename, Map<String, Object> params) {
        LOGGER.info("Checking for upgrades in {}", (Object)liquibaseChangelogFilename);
        try {
            Settings customSettings = this.persistenceSettings.getCustomSettings();
            Connection connection = ConnectionUtils.getConnection(this.connectionName, customSettings);
            return LiquibaseHelper.checkForUpgrades(connection, liquibaseChangelogFilename, params);
        }
        catch (SQLException ex) {
            LOGGER.error("Could not initialise database.", ex);
            return "Failed to initialise database:\n" + ex.getLocalizedMessage() + "\n";
        }
    }

    @Override
    public boolean doUpgrades(String liquibaseChangelogFilename, Map<String, Object> params, Writer out) throws UpgradeFailedException, IOException {
        Connection connection;
        LOGGER.info("Applying upgrades in {}", (Object)liquibaseChangelogFilename);
        Settings customSettings = this.persistenceSettings.getCustomSettings();
        try {
            connection = ConnectionUtils.getConnection(this.connectionName, customSettings);
        }
        catch (SQLException ex) {
            LOGGER.error("Could not initialise database.", ex);
            out.append("Failed to initialise database:\n");
            out.append(ex.getLocalizedMessage());
            out.append("\n");
            return false;
        }
        return LiquibaseHelper.doUpgrades(connection, liquibaseChangelogFilename, params, out);
    }

    @Override
    public void addModelMapping(DefModel modelDefinition) {
        this.tableCollection.getModelDefinitions().add(modelDefinition);
    }

    @Override
    public void addSecurityDefinition(SecurityModel.SecurityEntry entry) {
        String tableName = entry.getTableName();
        List<SecurityWrapper> wrappers = entry.getWrappers();
        for (SecurityWrapper wrapper : wrappers) {
            if (wrapper instanceof SecurityTableWrapper) {
                SecurityTableWrapper stw = (SecurityTableWrapper)wrapper;
                this.tableCollection.addSecurityWrapper(tableName, stw);
                continue;
            }
            if (wrapper instanceof HookValidator) {
                HookValidator hv = (HookValidator)wrapper;
                this.tableCollection.addSecurityValidator(tableName, hv);
                continue;
            }
            LOGGER.error("Unknown SecurityWrapper type: {}", (Object)wrapper);
        }
    }

    private void loadMapping() {
        List<DefModel> modelDefinitions = this.tableCollection.getModelDefinitions();
        if (modelDefinitions.isEmpty()) {
            return;
        }
        LOGGER.info("Loading Database Mappings...");
        this.getDslContext();
        ModelRegistry modelRegistry = this.settings.getModelRegistry();
        LOGGER.info("Reading Database Tables.");
        for (DefModel modelDefinition : modelDefinitions) {
            for (DefEntityType entityTypeDef : modelDefinition.getEntityTypes()) {
                String tableName = entityTypeDef.getTable();
                if (StringHelper.isNullOrEmpty(tableName)) continue;
                LOGGER.info("  Table: {}.", (Object)tableName);
                this.getDbTable(tableName);
                StaMainTable mainTable = this.getOrCreateMainTable(entityTypeDef.getEntityType(modelRegistry), entityTypeDef.getTable());
                this.tableCollection.initSecurityWrapper(mainTable);
                this.tableCollection.initSecurityValidators(mainTable, this);
            }
        }
        for (DefModel modelDefinition : modelDefinitions) {
            this.registerModelFields(modelDefinition);
        }
        for (DefModel modelDefinition : modelDefinitions) {
            this.registerModelMappings(modelDefinition);
        }
        for (DefModel modelDefinition : modelDefinitions) {
            this.registerHooks(modelDefinition);
        }
        this.tableCollection.clearModelDefinitions();
    }

    private void validateMappings() {
        LOGGER.info("Validating Database Mappings...");
        ModelRegistry modelRegistry = this.settings.getModelRegistry();
        for (EntityType entityType : modelRegistry.getEntityTypes(true)) {
            StaMainTable<?> tableForType = this.tableCollection.getTableForType(entityType);
            PropertyFieldRegistry<?> pfReg = tableForType.getPropertyFieldRegistry();
            for (Property property : entityType.getPropertySet()) {
                PropertyFieldRegistry.PropertyFields<?> pf = pfReg.getSelectFieldsForProperty(property);
                if (pf != null && pf.converter != null) continue;
                LOGGER.error("Property {} is not backed by table {}.", (Object)property.getName(), (Object)tableForType.getName());
            }
            IdGenerationType idGenMode = IdGenerationType.findType(this.persistenceSettings.getIdGenerationMode(entityType));
            entityType.setIdGenerationMode((Object)idGenMode);
        }
    }

    private void registerModelFields(DefModel modelDefinition) {
        for (DefEntityType entityTypeDef : modelDefinition.getEntityTypes()) {
            EntityType entityType = entityTypeDef.getEntityType(this.settings.getModelRegistry());
            StaMainTable typeStaTable = this.getOrCreateMainTable(entityType, entityTypeDef.getTable());
            for (DefEntityProperty defEntityProperty : entityTypeDef.getEntityProperties()) {
                this.registerFieldsForEntityProperty(defEntityProperty, typeStaTable);
            }
            for (DefNavigationProperty defNavigationProperty : entityTypeDef.getNavigationProperties()) {
                this.registerFieldsForNavProperty(defNavigationProperty, typeStaTable);
            }
        }
    }

    private void registerFieldsForEntityProperty(DefEntityProperty propertyDef, StaMainTable typeStaTable) {
        for (PropertyPersistenceMapper handler : propertyDef.getHandlers()) {
            this.maybeRegisterField(handler, typeStaTable);
        }
    }

    private void registerFieldsForNavProperty(DefNavigationProperty propertyDef, StaMainTable typeStaTable) {
        for (PropertyPersistenceMapper handler : propertyDef.getHandlers()) {
            this.maybeRegisterField(handler, typeStaTable);
        }
    }

    private void maybeRegisterField(PropertyPersistenceMapper handler, StaMainTable typeStaTable) {
        if (handler instanceof FieldMapper) {
            FieldMapper fieldMapper = (FieldMapper)handler;
            fieldMapper.registerField(this, typeStaTable);
        }
    }

    private void registerModelMappings(DefModel modelDefinition) {
        for (DefEntityType entityTypeDef : modelDefinition.getEntityTypes()) {
            EntityType entityType = entityTypeDef.getEntityType(this.settings.getModelRegistry());
            StaMainTable table = this.getOrCreateMainTable(entityType, entityTypeDef.getTable());
            for (DefEntityProperty defEntityProperty : entityTypeDef.getEntityProperties()) {
                this.registerMappingForEntityProperties(defEntityProperty, table);
            }
            for (DefNavigationProperty defNavigationProperty : entityTypeDef.getNavigationProperties()) {
                this.registerMappingForNavProperties(defNavigationProperty, table);
            }
        }
    }

    private void registerHooks(DefModel modelDefinition) {
        for (DefEntityType entityTypeDef : modelDefinition.getEntityTypes()) {
            EntityType entityType = entityTypeDef.getEntityType(this.settings.getModelRegistry());
            StaMainTable table = this.getOrCreateMainTable(entityType, entityTypeDef.getTable());
            for (DefPmHook hookDef : entityTypeDef.getHooks()) {
                JooqPmHook h2;
                PmHook hook = hookDef.getHook();
                if (hook instanceof HookPreInsert) {
                    h2 = (HookPreInsert)hook;
                    table.registerHookPreInsert(hookDef.getPriority(), (HookPreInsert)h2);
                }
                if (hook instanceof HookPostInsert) {
                    h2 = (HookPostInsert)hook;
                    table.registerHookPostInsert(hookDef.getPriority(), (HookPostInsert)h2);
                }
                if (hook instanceof HookPreUpdate) {
                    h2 = (HookPreUpdate)hook;
                    table.registerHookPreUpdate(hookDef.getPriority(), (HookPreUpdate)h2);
                }
                if (hook instanceof HookPostUpdate) {
                    h2 = (HookPostUpdate)hook;
                    table.registerHookPostUpdate(hookDef.getPriority(), (HookPostUpdate)h2);
                }
                if (hook instanceof HookPreDelete) {
                    h2 = (HookPreDelete)hook;
                    table.registerHookPreDelete(hookDef.getPriority(), (HookPreDelete)h2);
                }
                if (!(hook instanceof HookPostDelete)) continue;
                h2 = (HookPostDelete)hook;
                table.registerHookPostDelete(hookDef.getPriority(), (HookPostDelete)h2);
            }
        }
    }

    private void registerMappingForEntityProperties(DefEntityProperty propertyDef, StaMainTable orCreateTable) {
        for (PropertyPersistenceMapper handler : propertyDef.getHandlers()) {
            this.maybeRegisterMapping(handler, orCreateTable);
        }
    }

    private void registerMappingForNavProperties(DefNavigationProperty propertyDef, StaMainTable orCreateTable) {
        for (PropertyPersistenceMapper handler : propertyDef.getHandlers()) {
            this.maybeRegisterMapping(handler, orCreateTable);
        }
    }

    private void maybeRegisterMapping(PropertyPersistenceMapper handler, StaMainTable orCreateTable) {
        if (handler instanceof FieldMapper) {
            FieldMapper fieldMapper = (FieldMapper)handler;
            fieldMapper.registerMapping(this, orCreateTable);
        }
    }

    @Override
    public Table<?> getDbTable(String tableName) {
        return this.getDbTable(DSL.name(tableName));
    }

    @Override
    public Table<?> getDbTable(Name tableName) {
        return this.tableCache.computeIfAbsent(tableName, t2 -> this.readDbTableFromDb(tableName));
    }

    public Table<?> readDbTableFromDb(Name tableName) {
        Meta meta = this.dslContext.meta();
        List<Table<?>> tables = meta.getTables(tableName);
        if (tables.isEmpty()) {
            LOGGER.error("Table {} not found. Please initialise the database!", (Object)tableName);
            throw new IllegalArgumentException("Table " + tableName + " not found.");
        }
        if (tables.size() != 1) {
            String[] schemas;
            for (String schema : schemas = StringUtils.split(this.schemaPriority, ',')) {
                for (Table<?> table : tables) {
                    Schema tableSchema = table.getSchema();
                    if (tableSchema == null || !schema.trim().equalsIgnoreCase(tableSchema.getName())) continue;
                    LOGGER.warn("Table name {} found {} times, using version from schema {}.", tableName, tables.size(), schema);
                    return table;
                }
            }
            LOGGER.error("Table name {} found {} times, none in schemas '{}'. Use setting {}.{} to specify schema priority.", tableName, tables.size(), this.schemaPriority, "persistence.", "db.schemaPriority");
            throw new IllegalArgumentException("Failed to initialise: Table name " + tableName + " found " + tables.size() + " times.");
        }
        return tables.get(0);
    }

    private StaMainTable getOrCreateMainTable(EntityType entityType, String tableName) {
        if (entityType == null) {
            throw new IllegalArgumentException("Not implemented yet");
        }
        StaTableDynamic table = this.tableCollection.getTableForType(entityType);
        if (table == null) {
            PrimaryKey primaryKey = entityType.getPrimaryKey();
            if (primaryKey.size() > 1) {
                throw new NotImplementedException("Multi-valued primary keys are not implemented yet.");
            }
            LOGGER.info("  Registering StaTable {} ({})", (Object)tableName, (Object)entityType);
            DataType<?> pkDataType = this.getDataTypeFor(primaryKey.getKeyProperty(0).getType().getName());
            StaTableDynamic newTable = new StaTableDynamic(DSL.name(tableName), entityType, pkDataType);
            this.tableCollection.registerTable(entityType, newTable);
            table = newTable;
        }
        return table;
    }

    @Override
    public StaLinkTableDynamic getOrCreateLinkTable(String tableName) {
        StaLinkTableDynamic table = this.tableCollection.getTableForName(tableName);
        if (table == null) {
            LOGGER.info("  Registering StaLinkTable {}", (Object)tableName);
            StaLinkTableDynamic newTable = new StaLinkTableDynamic(DSL.name(tableName));
            this.tableCollection.registerTable(newTable);
            table = newTable;
        }
        if (table instanceof StaLinkTableDynamic) {
            StaLinkTableDynamic staLinkTableDynamic = table;
            return staLinkTableDynamic;
        }
        throw new IllegalStateException("Table " + tableName + " already exists, yet is not of type StaLinkTableDynamic but " + table.getClass().getName());
    }

    @Override
    public DataType<?> getDataTypeFor(String type) {
        switch (type.toUpperCase()) {
            case "EDM.INT64": 
            case "LONG": {
                return SQLDataType.BIGINT;
            }
            case "EDM.STRING": 
            case "STRING": {
                return SQLDataType.VARCHAR;
            }
            case "EDM.GUID": 
            case "UUID": {
                return SQLDataType.UUID;
            }
        }
        throw new IllegalArgumentException("Unknown data type: " + type);
    }

    @Override
    public void generateLiquibaseVariables(Map<String, Object> target, String entity, String type) {
        target.put("id-" + entity, type);
        target.put("idTypeLong", "BIGINT");
        switch (type) {
            case "LONG": {
                target.put(ID_TYPE + entity, "BIGINT");
                break;
            }
            case "STRING": {
                target.put(ID_TYPE + entity, "VARCHAR(36)");
                target.put("defaultValueComputed-" + entity, "uuid_generate_v1mc()");
                break;
            }
            case "UUID": {
                target.put(ID_TYPE + entity, "uuid");
                target.put("defaultValueComputed-" + entity, "uuid_generate_v1mc()");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ID type: " + type);
            }
        }
    }

    @Override
    public String checkForUpgrades() {
        Map<String, Object> props = CollectionsHelper.LinkedHashMapBuilder().addProperty("changeSetName", "MariadbPersistenceManager").build();
        return this.checkForUpgrades(LIQUIBASE_CHANGELOG_FILENAME, props);
    }

    @Override
    public boolean doUpgrades(Writer out) throws UpgradeFailedException, IOException {
        Map<String, Object> props = CollectionsHelper.LinkedHashMapBuilder().addProperty("changeSetName", "MariadbPersistenceManager").build();
        return this.doUpgrades(LIQUIBASE_CHANGELOG_FILENAME, props, out);
    }
}

