/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum IdGenerationType {
    SERVER_GENERATED_ONLY,
    SERVER_AND_CLIENT_GENERATED,
    CLIENT_GENERATED_ONLY;

    private static final Logger LOGGER;
    private static final Map<String, IdGenerationType> aliases;

    public static IdGenerationType findType(String input) {
        IdGenerationType mode = aliases.get(input.toLowerCase());
        if (mode == null) {
            LOGGER.error("Unknown IdGenerationType: {}, using {}", (Object)input, (Object)SERVER_GENERATED_ONLY);
            return SERVER_GENERATED_ONLY;
        }
        return mode;
    }

    static {
        LOGGER = LoggerFactory.getLogger(IdGenerationType.class);
        aliases = new HashMap<String, IdGenerationType>();
        for (IdGenerationType type : IdGenerationType.values()) {
            aliases.put(type.name(), type);
            aliases.put(type.name().replace("_", "").toLowerCase(), type);
        }
    }
}

