/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence;

import de.fraunhofer.iosb.ilt.frostserver.persistence.PersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.PersistenceSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.LiquibaseUser;
import de.fraunhofer.iosb.ilt.frostserver.util.LiquibaseUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceManagerFactory {
    private static final String ERROR_MSG = "Could not generate PersistenceManager instance: ";
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistenceManagerFactory.class);
    private static final Map<CoreSettings, PersistenceManagerFactory> INSTANCES = new HashMap<CoreSettings, PersistenceManagerFactory>();
    private boolean maybeUpdateDatabase = true;
    private final Class<PersistenceManager> persistenceManagerClass;
    private final CoreSettings settings;

    public static synchronized PersistenceManagerFactory init(CoreSettings coreSettings) {
        PersistenceManagerFactory instance = INSTANCES.computeIfAbsent(coreSettings, t2 -> {
            PersistenceManagerFactory newInstance = new PersistenceManagerFactory(coreSettings);
            PersistenceSettings persistenceSettings = coreSettings.getPersistenceSettings();
            newInstance.maybeUpdateDatabase = persistenceSettings.isAutoUpdateDatabase();
            return newInstance;
        });
        instance.maybeUpdateDatabase();
        return instance;
    }

    public static PersistenceManagerFactory getInstance(CoreSettings coreSettings) {
        PersistenceManagerFactory instance = INSTANCES.get(coreSettings);
        if (instance == null) {
            instance = PersistenceManagerFactory.init(coreSettings);
        }
        return instance;
    }

    private PersistenceManagerFactory(CoreSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException("settings must be non-null");
        }
        this.settings = settings;
        String pmiClsName = settings.getPersistenceSettings().getPersistenceManagerImplementationClass();
        try {
            Class<?> clazz = Class.forName(pmiClsName, false, this.getClass().getClassLoader());
            if (!PersistenceManager.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Class " + pmiClsName + " does not implement the interface PersistenceManager");
            }
            this.persistenceManagerClass = clazz;
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Could not generate PersistenceManager instance: Class '" + pmiClsName + "' could not be found", ex);
        }
    }

    public PersistenceManager create() {
        PersistenceManager persistenceManager = null;
        try {
            persistenceManager = this.persistenceManagerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            persistenceManager.init(this.settings);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException ex) {
            LOGGER.error("{} Class '{}' could not be instantiated", ERROR_MSG, this.settings.getPersistenceSettings().getPersistenceManagerImplementationClass(), ex);
        }
        return persistenceManager;
    }

    public void maybeUpdateDatabase() {
        if (this.maybeUpdateDatabase) {
            Set<LiquibaseUser> liquibaseUsers;
            PersistenceManager pm = this.create();
            if (pm instanceof LiquibaseUser) {
                LiquibaseUser liquibaseUser = (LiquibaseUser)((Object)pm);
                LiquibaseUtils.maybeUpdateDatabase(LOGGER, liquibaseUser);
            }
            if ((liquibaseUsers = this.settings.getLiquibaseUsers()).isEmpty()) {
                return;
            }
            for (LiquibaseUser lbu : liquibaseUsers) {
                if (!LiquibaseUtils.maybeUpdateDatabase(LOGGER, lbu)) continue;
                return;
            }
            this.maybeUpdateDatabase = false;
        }
    }
}

