/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence;

import com.github.fge.jsonpatch.JsonPatch;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityChangedMessage;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.PkValue;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.DefModel;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntity;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.service.InitResult;
import de.fraunhofer.iosb.ilt.frostserver.service.UpdateMode;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.SecurityModel;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncompleteEntityException;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.NoSuchEntityException;
import java.security.Principal;
import java.util.List;

public interface PersistenceManager
extends AutoCloseable {
    public boolean validatePath(ResourcePath var1);

    public boolean insert(Entity var1, UpdateMode var2) throws NoSuchEntityException, IncompleteEntityException;

    public Entity get(EntityType var1, PkValue var2);

    public Object get(ResourcePath var1, Query var2);

    default public <T> T get(ResourcePath path, Query query, Class<T> clazz) {
        Object result = this.get(path, query);
        if (!clazz.isAssignableFrom(result.getClass())) {
            throw new IllegalArgumentException("The resourcepath does not result in an instance of class " + clazz.getName());
        }
        return clazz.cast(result);
    }

    public boolean delete(PathElementEntity var1) throws NoSuchEntityException;

    public void delete(ResourcePath var1, Query var2) throws NoSuchEntityException;

    public void deleteRelation(PathElementEntity var1, NavigationPropertyMain var2, PathElementEntity var3) throws IncompleteEntityException, NoSuchEntityException;

    public boolean update(PathElementEntity var1, Entity var2, UpdateMode var3) throws NoSuchEntityException, IncompleteEntityException;

    public boolean update(PathElementEntity var1, JsonPatch var2) throws NoSuchEntityException, IncompleteEntityException;

    public List<EntityChangedMessage> getEntityChangedMessages();

    public InitResult init(CoreSettings var1);

    public CoreSettings getCoreSettings();

    public void setRole(Principal var1);

    public void commit();

    public void rollback();

    @Override
    public void close();

    default public void rollbackAndClose() {
        this.rollback();
        this.close();
    }

    default public void commitAndClose() {
        this.commit();
        this.close();
    }

    default public void addModelMapping(DefModel modelDefinition) {
    }

    default public void addSecurityDefinition(SecurityModel.SecurityEntry entry) {
    }
}

