/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.path;

import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.path.SyntheticPropertyRegistry;
import java.util.Map;
import java.util.TreeMap;

public class Version {
    private static final SyntheticPropertyRegistry spr = new SyntheticPropertyRegistry();
    public static final String VERSION_STA_V10_NAME = "v1.0";
    public static final String VERSION_STA_V11_NAME = "v1.1";
    public static final Version V_1_0 = new Version("v1.0", spr, "@iot.count", "@iot.id", "@iot.selfLink", "@iot.nextLink", "@iot.navigationLink");
    public static final Version V_1_1 = new Version("v1.1", spr, "@iot.count", "@iot.id", "@iot.selfLink", "@iot.nextLink", "@iot.navigationLink");
    public final String urlPart;
    public final SyntheticPropertyRegistry syntheticPropertyRegistry;
    public final Map<CannedResponseType, CannedResponse> responses = new TreeMap<CannedResponseType, CannedResponse>();
    public final String countName;
    public final String idName;
    public final String navLinkName;
    public final String nextLinkName;
    public final String selfLinkName;

    public Version(String urlPart, String countName, String idName, String navLinkName, String nextLinkName, String selfLinkName) {
        this(urlPart, new SyntheticPropertyRegistry(), countName, idName, selfLinkName, nextLinkName, navLinkName);
    }

    public Version(String urlPart, SyntheticPropertyRegistry spr, String countName, String idName, String selfLinkName, String nextLinkName, String navLinkName) {
        this.urlPart = urlPart;
        this.syntheticPropertyRegistry = spr;
        this.countName = countName;
        this.idName = idName;
        this.selfLinkName = selfLinkName;
        this.nextLinkName = nextLinkName;
        this.navLinkName = navLinkName;
    }

    public String toString() {
        return this.urlPart;
    }

    public CannedResponse getCannedResponse(CannedResponseType type) {
        return this.responses.getOrDefault((Object)type, type.dflt);
    }

    public String getCountName() {
        return this.countName;
    }

    public String getIdName() {
        return this.idName;
    }

    public String getNavLinkName() {
        return this.navLinkName;
    }

    public String getNextLinkName() {
        return this.nextLinkName;
    }

    public String getSelfLinkName() {
        return this.selfLinkName;
    }

    static {
        spr.registerProperty(ModelRegistry.EP_SELFLINK);
    }

    public static enum CannedResponseType {
        NOTHING_FOUND(new CannedResponse(404, "Not Found"));

        public final CannedResponse dflt;

        private CannedResponseType(CannedResponse dflt) {
            this.dflt = dflt;
        }
    }

    public static class CannedResponse {
        public final int code;
        public final String message;

        public CannedResponse(int code, String message) {
            this.code = code;
            this.message = message;
        }
    }
}

