/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.path;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElement;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementArrayIndex;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntity;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementProperty;
import de.fraunhofer.iosb.ilt.frostserver.path.UrlHelper;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ResourcePath {
    private String serviceRootUrl;
    private Version version;
    private String path;
    private boolean ref;
    private boolean value;
    private boolean entityProperty;
    private final List<PathElement> pathElements = new ArrayList<PathElement>();
    private PathElement mainElement;
    private PathElementEntity identifiedElement;

    public ResourcePath() {
    }

    public ResourcePath(String serviceRootUrl, Version version, String pathUrl) {
        this.version = version;
        this.serviceRootUrl = serviceRootUrl;
        this.path = pathUrl;
    }

    public boolean isRef() {
        return this.ref;
    }

    public ResourcePath setRef(boolean ref) {
        this.ref = ref;
        return this;
    }

    public boolean isValue() {
        return this.value;
    }

    public ResourcePath setValue(boolean value) {
        this.value = value;
        return this;
    }

    public boolean isEntityProperty() {
        return this.entityProperty;
    }

    public int size() {
        return this.pathElements.size();
    }

    public boolean isEmpty() {
        return this.pathElements.isEmpty();
    }

    public PathElement get(int index) {
        return this.pathElements.get(index);
    }

    public PathElement getMainElement() {
        return this.mainElement;
    }

    public EntityType getMainElementType() {
        PathElement pathElement = this.mainElement;
        if (pathElement instanceof PathElementEntity) {
            PathElementEntity entityPathElement = (PathElementEntity)pathElement;
            return entityPathElement.getEntityType();
        }
        pathElement = this.mainElement;
        if (pathElement instanceof PathElementEntitySet) {
            PathElementEntitySet entitySetPathElement = (PathElementEntitySet)pathElement;
            return entitySetPathElement.getEntityType();
        }
        return null;
    }

    public PathElement getLastElement() {
        if (this.pathElements.isEmpty()) {
            return null;
        }
        return this.pathElements.get(this.pathElements.size() - 1);
    }

    public PathElementEntity getIdentifiedElement() {
        return this.identifiedElement;
    }

    public ResourcePath setMainElement(PathElement mainElementType) {
        this.mainElement = mainElementType;
        return this;
    }

    public ResourcePath setIdentifiedElement(PathElementEntity identifiedElement) {
        this.identifiedElement = identifiedElement;
        return this;
    }

    public List<PathElement> getPathElements() {
        return this.pathElements;
    }

    public ResourcePath addPathElement(int index, PathElement pe) {
        this.pathElements.add(index, pe);
        return this;
    }

    public ResourcePath addPathElement(PathElement pe) {
        this.addPathElement(pe, false, false);
        return this;
    }

    public ResourcePath addPathElement(PathElement pe, boolean isMain, boolean isIdentifier) {
        this.pathElements.add(pe);
        if (isMain && pe instanceof PathElementEntity || pe instanceof PathElementEntitySet) {
            this.setMainElement(pe);
        }
        if (isIdentifier && pe instanceof PathElementEntity) {
            PathElementEntity epe = (PathElementEntity)pe;
            this.setIdentifiedElement(epe);
        }
        this.entityProperty = pe instanceof PathElementProperty;
        return this;
    }

    public ResourcePath compress() {
        for (int i = this.pathElements.size() - 1; i > 0; --i) {
            PathElement current = this.pathElements.get(i);
            if (!(current instanceof PathElementEntity)) continue;
            PathElementEntity epe = (PathElementEntity)current;
            if (!(this.pathElements.get(i - 1) instanceof PathElementEntitySet) || !epe.primaryKeyFullySet()) continue;
            this.pathElements.subList(0, i - 1).clear();
            this.setIdentifiedElement(epe);
            this.pathElements.get(0).setParent(null);
            return this;
        }
        return this;
    }

    public String getServiceRootUrl() {
        return this.serviceRootUrl;
    }

    public ResourcePath setServiceRootUrl(String serviceRootUrl) {
        this.serviceRootUrl = serviceRootUrl;
        return this;
    }

    public Version getVersion() {
        return this.version;
    }

    public ResourcePath setVersion(Version version) {
        this.version = version;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public ResourcePath setPath(String pathUrl) {
        this.path = pathUrl;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.serviceRootUrl, this.ref, this.value, this.pathElements, this.mainElement, this.identifiedElement);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourcePath other = (ResourcePath)obj;
        return Objects.equals(this.serviceRootUrl, other.serviceRootUrl) && this.version == other.version && this.ref == other.ref && this.value == other.value && Objects.equals(this.pathElements, other.pathElements) && Objects.equals(this.mainElement, other.mainElement) && Objects.equals(this.identifiedElement, other.identifiedElement);
    }

    public String getFullUrl() {
        StringBuilder sb = new StringBuilder(this.serviceRootUrl).append('/').append(this.version.urlPart);
        for (PathElement rpe : this.pathElements) {
            PathElementEntity epe;
            if (rpe instanceof PathElementEntity && (epe = (PathElementEntity)rpe).primaryKeyFullySet()) {
                sb.append("(").append(UrlHelper.quoteForUrl(epe.getEntityType().getPrimaryKey(), epe.getPkValues())).append(")");
                continue;
            }
            if (rpe instanceof PathElementArrayIndex) {
                sb.append(rpe.toString());
                continue;
            }
            sb.append("/");
            sb.append(rpe.toString());
        }
        if (this.isRef()) {
            sb.append("/$ref");
        } else if (this.isValue()) {
            sb.append("/$value");
        }
        return sb.toString();
    }

    public String toString() {
        return this.getFullUrl();
    }
}

