/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.path;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.PkValue;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElement;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntityType;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePathVisitor;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import java.util.Objects;

public class PathElementEntity
implements PathElementEntityType {
    private final NavigationPropertyMain.NavigationPropertyEntity np;
    private final EntityType entityType;
    private PathElement parent;
    private PkValue pkValue;

    public PathElementEntity(NavigationPropertyMain.NavigationPropertyEntity np, PathElement parent) {
        this.np = np;
        this.entityType = null;
        this.parent = parent;
    }

    public PathElementEntity(EntityType entityType, PathElement parent) {
        this.np = null;
        this.entityType = entityType;
        this.parent = parent;
    }

    public PathElementEntity(PkValue pk, EntityType entityType, PathElement parent) {
        this.np = null;
        this.entityType = entityType;
        this.parent = parent;
        this.pkValue = pk;
    }

    public PkValue getPkValues() {
        return this.pkValue;
    }

    public PathElementEntity setPkValues(PkValue pkValue) {
        this.pkValue = pkValue;
        return this;
    }

    @Deprecated
    public PathElementEntity setPkValues(Object ... pkValues) {
        this.pkValue = new PkValue(pkValues);
        return this;
    }

    public boolean primaryKeyFullySet() {
        if (this.pkValue == null) {
            return false;
        }
        for (Object value : this.pkValue) {
            if (value != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        if (this.np != null) {
            return this.np.getName();
        }
        return this.entityType.entityName;
    }

    @Override
    public NavigationPropertyMain.NavigationPropertyEntity getNavigationProperty() {
        return this.np;
    }

    @Override
    public EntityType getEntityType() {
        if (this.np != null) {
            return this.np.getEntityType();
        }
        return this.entityType;
    }

    @Override
    public PathElement getParent() {
        return this.parent;
    }

    @Override
    public void setParent(PathElement parent) {
        this.parent = parent;
    }

    @Override
    public void visit(ResourcePathVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return Objects.hash(this.pkValue, this.entityType, this.np, this.parent);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathElementEntity other = (PathElementEntity)obj;
        return Objects.equals(this.pkValue, other.pkValue) && this.np == other.np && this.entityType == other.entityType && Objects.equals(this.parent, other.parent);
    }
}

