/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.path;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyCustom;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyCustomLink;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.property.PropertyReference;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.util.HashMap;
import java.util.Map;

public class ParserContext {
    private final ParserContext parentContext;
    private final ModelRegistry modelRegistry;
    private final Map<String, PropertyReference> lambdaVariables = new HashMap<String, PropertyReference>();

    public ParserContext(ModelRegistry modelRegistry) {
        this.parentContext = null;
        this.modelRegistry = modelRegistry;
    }

    public ParserContext(ParserContext parentContext) {
        this.parentContext = parentContext;
        this.modelRegistry = parentContext.getModelRegistry();
    }

    public void registerVariable(String name, PropertyReference type) {
        if (this.getVariable(name) != null) {
            throw new IllegalArgumentException("Variable name '" + name + "' used multiple times.");
        }
        this.lambdaVariables.put(name, type);
    }

    public PropertyReference getVariable(String name) {
        PropertyReference variable = this.lambdaVariables.get(name);
        if (variable == null && this.parentContext != null) {
            return this.parentContext.getVariable(name);
        }
        return variable;
    }

    public ModelRegistry getModelRegistry() {
        return this.modelRegistry;
    }

    public Property parseProperty(EntityType type, String propertyName, Property previous) {
        String decodedName = StringHelper.urlDecode(propertyName);
        PropertyReference variable = this.getVariable(decodedName);
        if (variable != null) {
            return variable;
        }
        if (previous instanceof EntityPropertyMain || previous instanceof EntityPropertyCustom) {
            return this.parseCustomProperty(decodedName);
        }
        NavigationPropertyMain navProp = type.getNavigationProperty(decodedName);
        if (navProp != null) {
            return navProp;
        }
        EntityPropertyMain entityProp = type.getEntityProperty(decodedName);
        if (entityProp != null) {
            return entityProp;
        }
        throw new IllegalArgumentException("Could not place " + propertyName + " under type " + type + " after " + previous);
    }

    private Property parseCustomProperty(String decodedName) {
        EntityType typeForCustomLink = this.modelRegistry.getCustomLinksHelper().getTypeForCustomLinkName(decodedName);
        if (typeForCustomLink == null) {
            return new EntityPropertyCustom(decodedName);
        }
        return new EntityPropertyCustomLink(decodedName, typeForCustomLink);
    }
}

